; machine.lsp -- machine/system-dependent definitions
; 	rs6000

(if (not (boundp '*default-sf-format*))
    (setf *default-sf-format* snd-head-NeXT))

(if (not (boundp '*default-sound-file*))
    (compute-default-sound-file))

(if (not (boundp '*default-sf-dir*))
    (setf *default-sf-dir* "/tmp/"))

(if (not (boundp '*default-sf-mode*))
    (setf *default-sf-mode* snd-head-mode-pcm))

(if (not (boundp '*default-sf-bits*))
    (setf *default-sf-bits* 16))

(if (not (boundp '*default-plot-file*))
    (setf *default-plot-file* "points.dat"))

; local definition for play


(defun r ()
  (system (format nil
           "acpaplay ~A/~A"
	   *default-sf-dir*
           *default-sound-file*)))


(defmacro play (expr)
  `(prog ()
         (s-save ,expr NY:ALL *default-sound-file*)
         (r)))


; PLAY-FILE -- play a file
(defun play-file (name)
  (system (format nil "acpaplay ~A" (soundfilename name))))


; save the standard function to write points to a file
;
(setfn s-plot-points s-plot)

; S-PLOT - plot a small number of points
;
(defun s-plot (&rest args)
  (let ((n (soundfilename *default-plot-file*)))
    (apply #'s-plot-points args)
    (system (format nil "xterm -t -e sys/unix/rs6k/plotscript ~A" n))))


; S-EDIT - run the audio editor on a sound
;
(defmacro s-edit (&optional expr)
  `(prog ()
         (if ,expr (s-save ,expr 1000000000 *default-sound-file*))
         (system (format nil "audio_editor ~A &" 
                         (soundfilename *default-sound-file*)))))

