#include <stdio.h>
#include "../PVLIB/pv.h"

complex zero = { 0., 0. };
complex one = { 1., 0. };
float PI;
float TWOPI;
float synt ;
float NYQUIST ;
extern char *arg_option;
main(argc, argv)
    int argc; char *argv[];
{
  int R=44100, N=1024, N2, Nw = 4096, Nw2, D = 512, I = 512, in, on, 
  eof = 0, obank = 0, aflag = 0, sflag = 0;
  float P = 1., len, tincr, tpos, *Hwin, *Wanal, *Wsyn, *input, *winput,
  *buffer, *channel, *output; 
  char	ch, *dbuf;
  char fname[128] = "func";
  char pfname[128] = "pfunc";
  float duration=0., outdur=0.;
  int pvcount = 0;
  int N_Frames = 0;
  int N_OutFrames;
  int i,j;
  int flen, pflen, ppos;
  float **wherehouse;
  float *lookupfunc, *tfunc, *pitchfunc;
  FILE *openfile(), *fp, *fp2;
  int bad_read_flag;
  int new_frame_len;
  int ioffset;
  float time_offset = 0.0;
  float funcbot=0., functop=1.;
  float pitchfac ;
  int rescaleflag = 0;
  float syntgen = .001;
  float getthresh();
    if (isatty(0))
	usage(1);
    while( (ch= crack( argc, argv, "R|N|M|I|F|f|i|o|O|h|s|S|p|g|", 0  )) != NULL ) {
	switch(ch) {
	    case 'R':	R = atoi(arg_option);
			break;
	    case 'N':	N = atoi(arg_option);
			break;
	    case 'M':	Nw = atoi(arg_option);
			break;
	    case 'I':	I = atoi(arg_option);
			break;
	    case 'F': 	N_Frames = atoi(arg_option);
	    		break;
	    case 'i':   duration = atof(arg_option);
			break;
	    case 'o':   outdur = atof(arg_option);
	    		break;
	    case 'O':   time_offset = atof(arg_option);
	    		break;
	    case 's':   funcbot = atof(arg_option);
	    		rescaleflag = 1 ;
	    		break;
	    case 'S':   functop = atof(arg_option);
	    		rescaleflag = 1 ;
	    		break;
	    case 'f':   strcpy(fname, arg_option);
			break;
	    case 'p':   strcpy(pfname, arg_option);
			break;
	    case 'g':   syntgen = atof(arg_option);
			break;

	    case 'h':	usage(1);
	}
    }
    NYQUIST = R/2.0 ;
    if( duration <= 0.0  ) {
      fprintf(stderr,"must specify input duration\n");
      exit(-1);
    }
    if( outdur <= 0.0  ) {
      fprintf(stderr,"must specify output duration\n");
      exit(-1);
    }
    N_Frames = (int) ((((float)R+(float)Nw)/(float)D)*duration);
    fp = openfile( fname, "r" );
    flen = readin( fp, &lookupfunc);
      // OPTIONAL FUNCTION RESCALE
    fp2 = openfile( pfname, "r" );
    pflen = readin( fp2, &pitchfunc);
    if( rescaleflag )
       norman( lookupfunc, funcbot, functop, flen );
    for(i = 0; i < flen; i++ )
       if( (lookupfunc[i] < 0.0) || (lookupfunc[i] > 1.0) ){
          fprintf(stderr,"Lookup function exceeds enforced boundaries 0.0-1.0\n");
	  exit(-1);
        }
      // OPTIONAL FUNCTION TIME OFFSET
      if( time_offset != 0.0 ){
         tfunc = (float *) space( flen, sizeof(float) );	
         ioffset = (time_offset/outdur)*(float)flen ;
	 fprintf(stderr,"FUNCTION OFFSET = %d\n", ioffset);
	 for( i = 0; i < flen ; i++)
	    tfunc[i] = lookupfunc[(i+ioffset)%flen] ;
	 for( i = 0; i < flen ; i++)
	    lookupfunc[i] = tfunc[i] ;
      }
    N_OutFrames =(int)((float)N_Frames * (outdur/duration));
    if (Nw == 0)
	Nw = N;
    if (I == 0)
	I = D;

    PI = 4.*atan(1.);
    TWOPI = 8.*atan(1.);
    obank = P != 0.;
    N2 = N>>1;
    Nw2 = Nw>>1;
    Wanal = (float *) space( Nw, sizeof(float) );
    Wsyn = (float *) space( Nw, sizeof(float) );
    input = (float *) space( Nw, sizeof(float) );
    Hwin = (float *) space( Nw, sizeof(float) );
    winput = (float *) space( Nw, sizeof(float) );
    buffer = (float *) space( N+2, sizeof(float) );	   
    channel = (float *) space( N+2, sizeof(float) );    
    output = (float *) space( Nw, sizeof(float) );	
    if( ( wherehouse = (float **) calloc(N_Frames, sizeof(float *) ) ) == NULL) 
       memerr();
    for ( i=0; i < N_Frames; i++ ) 
       if( (*(wherehouse+i) = (float *) calloc(N+2, sizeof(float)) ) == NULL) 
          memerr();

    makewindows( Hwin, Wanal, Wsyn, Nw, N, I, obank );

    in = -Nw;
    on = in;

bad_read_flag = 0;
// READ ANALYSIS FROM STDIN 
   for( i = 0 ; i < N_Frames; i++ ){
      for( j = 0; j < N+2; j++ )
	 if ( fread(&wherehouse[i][j],sizeof(float),1,stdin) == NULL ){
	    bad_read_flag = 1;
	    break;
         }
      if( bad_read_flag){
	 new_frame_len = i;
	 N_OutFrames =(int)((float)new_frame_len * (outdur/duration));
	 break;
	 }
    }
    if( bad_read_flag) N_Frames = new_frame_len;
    fprintf(stderr,"PRESIDENT: ANALYSIS SCAN COMPLETED\n");
 // SCALE FUNCTION TO NUMBER OF ANALYSIS FRAMES
    rescale( lookupfunc, flen, N_Frames );
    ShowExtrema(lookupfunc, flen, "FRAME LOOKUP");
    
    /* SYNTHESIS LOOP */
    
    for(j = 0; j < N_OutFrames ; j++) {
	on += I;
	i = getloc(j, flen, lookupfunc, N_OutFrames, N_Frames);
	ppos = ((float)j/(float)N_OutFrames)*(float)(pflen-1);
	pitchfac = pitchfunc[ ppos ];
	synt = getthresh(wherehouse[i], N, syntgen);
	MultPitch( buffer, wherehouse[i], N2, pitchfac );
        noscbank( buffer, N2, R, Nw, I, P, output );
	shiftout( output, Nw, I, on+Nw-I );
    }
// TERMINATE
    fprintf(stderr,"PRESIDENT: SYNTHESIS COMPLETED\n");
    exit(0);
}

MultPitch( dest, src, N, P ) float *dest, *src, P; int N;
{
   register int i, freq, amp;
   
   for( i = 0; i < N; i++ ){
      freq = ( amp = ( i << 1 ) ) + 1;
      dest[freq] = src[freq] * P ;
      dest[amp] = src[amp];
      // KILL ALIASING
      if( dest[freq] > NYQUIST )
         dest[amp] = 0.0 ;
   }
}
rescale( arr, len, max ) float arr[]; int len, max;
{
  int i;
  for(i = 0; i < len ; i++){
    arr[i] *= (float) max;
  }
}
getloc( pos, flen, arr, max, maxf)
int pos, flen, max, maxf; float arr[];
{
int frame;
int fpos;
double rint();
  max -= 1;
  flen -= 1;
  fpos = (int) rint((float)pos * ((float)flen / (float) max ));
  if( fpos > flen ) 
     fprintf(stderr,"getloc: array out of bounds: pos = %d, len = %d, fpos = %d\n",
      pos,flen,fpos);
  frame = (int) rint(arr[fpos]);
  if( frame >= maxf ) 
    frame = maxf-1;
  if( frame < 0 )
    frame = 0;
  return(frame);
}
usage(meow)
{
    fprintf(stderr, "%s",
	"president:  pvoc data surfing with pitch deviation\n"
	"president   [flags] < floatsams > floatsams\n"
	"	N:	fft length [1024]\n"
	"	R:	sampling rate [44100]\n"
	"	M:	window size in samples [4096]\n"
	"	I:	interpolation factor in samples [512]\n"
	"	f:	lookup control function [func]\n"
	"	p:	pitch control function [pfunc]\n"
	"	i:	duration of input [undefined]\n"
	"	o:	duration of output [undefined]\n"
	"	O:	time offset for function [0.]\n"
	"	s:	floor for rescaling control function\n"
	"	S:	ceiling for rescaling control function\n"
	"	g:	multiplier for amplitude threshold[.001]\n"
	);
    exit(meow);
}

memerr()
{
fprintf(stderr,"Richard Wagner Alert: No Memory Left\n");
exit(-1);
}
ShowExtrema( arr, len, name ) float *arr; int len; char *name;
{
   float min = 100000000.;
   float max = 0.;
   int i;
   
   for(i = 0; i < len; i++ ){
      if( min > arr[i] ) min = arr[i];
      if( max < arr[i] ) max = arr[i];
   }
   fprintf(stderr,"%s EXTREMES: %.0f %.0f\n",name,min,max);
}
