#include <stdlib.h>
#include <stdio.h>
#include "../PVLIB/pv.h"

complex zero = { 0., 0. };
complex one = { 1., 0. };
float PI;
float TWOPI;
float synt = 0.;

extern char *arg_option ;

main(argc, argv)
    int argc; char *argv[];
{
    int 	R=44100,
		N=1024,
		N2,
		Nw = 4096,
		Nw2, 
		D = 512, 
		I = 512,
		i,
		hoop,			/* looping variable */
		in,
		on,
		eof = 0,
		obank = 0,
		aflag = 0,
		sflag = 0;
    float 	P = 0.,
		len,
		tincr,
		tpos,
		*Hwin,
		*Wanal,
		*Wsyn,
		*input,
		*winput,
		*buffer,
		*channel,
		*output;
    char	ch,
		*dbuf;
float threshgen = .005;
float getthresh();
int Qflag ;
int nframes=0, bincnt=0, bins;
float 
  thresh_interval = 1.0, // dB amplitude gate step size
  max_atten = -6.0 , // dB attenuation for highest amplitudes
  atten_interval = 2.0 ; // dB attenuation step size
    if (isatty(0))
	usage();

    while( (ch= crack( argc, argv, "R|N|M|D|I|P|q|t|s|h|m|g|a|", 0  )) != NULL ) {
	switch(ch) {
	    case 'R':	R = atoi(arg_option);
			break;
	    case 'N':	N = atoi(arg_option);
			break;
	    case 'M':	Nw = atoi(arg_option);
			break;
	    case 'D':	D = atoi(arg_option);
			break;
	    case 'I':	I = atoi(arg_option);
			break;
	    case 'P':	P = atof(arg_option);
			break;
	    case 't':	synt = atof(arg_option);
			break;
	    case 'm':	max_atten = atof(arg_option);
			break;
	    case 'a':	atten_interval = atof(arg_option);
			break;
	    case 'g':	thresh_interval = atof(arg_option);
			break;
	    case 'q':	Qflag = 1;
			break;
	    case 's':	sflag = 1;
			break;
	    case 'h':	usage();
	}
    }
    if( max_atten == 0. ){
       fprintf(stderr,"attenuation cannot equal 0dB\n");
       exit(-1);
    } 
    if (Nw == 0)
	Nw = N;

	if (I == 0)
	    I = D;

    if (sflag)
      D = 0;

    PI = 4.*atan(1.);
    TWOPI = 8.*atan(1.);
    obank = P != 0.;
    N2 = N>>1;
    Nw2 = Nw>>1;


    Wanal = (float *) space( Nw, sizeof(float) );	
    Wsyn = (float *) space( Nw, sizeof(float) );	
    input = (float *) space( Nw, sizeof(float) );	
    Hwin = (float *) space( Nw, sizeof(float) );
    winput = (float *) space( Nw, sizeof(float) );
    buffer = (float *) space( N, sizeof(float) );
    channel = (float *) space( N+2, sizeof(float) );
    output = (float *) space( Nw, sizeof(float) );

    makewindows( Hwin, Wanal, Wsyn, Nw, N, I, obank );

    in = -Nw;
    if ( D )
	on = (in*I)/D;
    else
	on = in;

    while ( !eof ) {

	in += D;
	on += I;
	if ( D == 0 ) {
	  for ( hoop=0; hoop < N+2; hoop++ ) {
	    if ( fread(channel+hoop,sizeof(float),1,stdin) <= 0 )
	      eof = 1;
	  } 
	} 
	else {
	    eof = shiftin( input, Nw, D );
	    fold( input, Wanal, Nw, buffer, N, in );
	    rfft( buffer, N2, FORWARD );
	    if(Qflag)
	       convert( buffer, channel, N2, D, R );
	    else
	       leanconvert( buffer, channel, N2, D, R );
	}	
	bins = pvcompand(channel,N2,max_atten,thresh_interval,atten_interval);
	bincnt += bins;
	++nframes;
	if ( obank ) {
	    synt = getthresh( channel, N, threshgen );
	    noscbank( channel, N2, R, Nw, I, P, output );
	    shiftout( output, Nw, I, on+Nw-I );
	} 

	else {
	    if(Qflag)
	       unconvert( channel, buffer, N2, I, R );
	    else
	       leanunconvert( channel, buffer, N2, I, R );
	    rfft( buffer, N2, INVERSE );	
	    overlapadd( buffer, N, Wsyn, output, Nw, on );
	    shiftout( output, Nw, I, on );
	}
    }
    fprintf(stderr,"SCAMPI: RESYNTHESIS COMPLETED\n");
    fprintf(stderr,"average bins affected: %.0f\n",(float)bincnt/(float)nframes);
    exit(0);
}
pvcompand(arr, N, max_atten, tstep, gstep)
float *arr, max_atten, tstep, gstep ; int N;
{
static int first = 1;
int i, j;
static int count;
static float *curthresh ;
static float *atten, *thresh ;
float nowamp, nowthresh;
float maxamp, cutoff; 
float ampdb();
int bincount;
if( first ){
   first = 0 ;
   thresh = (float *) space( N, sizeof(float) );
   atten = (float *) space( N, sizeof(float) );
   curthresh = (float *) space( N, sizeof(float) );
   nowamp = max_atten ;
   nowthresh = 0.0 ;
   count = 0;
   if( nowamp < 0.0 ) // COMPRESSION
      while( nowamp < 0.0 ){
         atten[count] = ampdb( nowamp );
         nowamp += gstep ;
         ++count;
      }
   else if( nowamp > 0.0 ) // EXPANSION
      while( nowamp > 0.0 ){
         atten[count] = ampdb( nowamp );
         nowamp -= gstep ;
         ++count;
      }

   for( i = 0; i < count; i++){
      thresh[i] = ampdb( nowthresh );
      nowthresh -= tstep ;
   }
   // debug   
   for( i = 0; i < count; i++)
      fprintf(stderr,"thresh %f gain %f\n",thresh[i], atten[i]);
   }
   bincount = 0;
   // RESET THRESHOLDS RELATIVE TO MAXAMP
   maxamp = 0.;
   for( i = 0; i < N; i+= 2 )
      if( maxamp < arr[i] )
         maxamp = arr[i] ;
   for( i = 0; i < count; i++ )
      curthresh[i] = thresh[i]*maxamp ;
   cutoff = curthresh[count-1];
   for( i = 0; i < N; i += 2){
      if( arr[i] > cutoff ){
        ++bincount ;
         j = count-1;
         while( arr[i] > curthresh[j] ){
	    j--;
	    if( j < 0 ){
	       j = 0;
	       fprintf(stderr,"j index < 0\n");
	       fprintf(stderr,"%.12f > than %.12f\n",
	       arr[i], thresh[j]);
	       break;
	    }
	 }
	 arr[i] *= atten[j];
      }
   }
 return( bincount );
}
float ampdb( db ) float db;
{
double pow();
float amp;
   amp = pow((double)10.0, (double)(db/20.0)) ;
   return( amp );
}
usage()
{
    fprintf(stderr, "%s",
	"scampi:  spectral compander\n"
	"scampi   [flags] < floatsams > floatsams\n"
	"	N:	fft length [1024]\n"
	"	R:	sampling rate [44100]\n"
	"	M:	window size in samples [4096]\n"
	"	D:	decimation factor in samples [512]\n"
	"	I:	interpolation factor in samples [512]\n"
	"	m:	maximum rescale in dB [-6.]\n"
	"	a:	attenuation stepsize in dB  [2.]\n"
	"	g:	gate stepsize in dB [1.]\n"
	"	P:	pitch factor [0.]\n"
	"	t:	threshold generator [.005]\n"
	"	q:	maintain phase coherence\n"
	"	s:	synthesize analysis input\n"
	);
    exit(-1);
}

