#include <stdio.h>
#include "../PVLIB/pv.h"
complex zero = { 0., 0. } ;
complex one = { 1., 0. } ;
float PI ;
float TWOPI ;
float synt ;
extern char *arg_option;
main( argc, argv )
    int argc ; char *argv[] ;
{
char ch;
 int R=44100, N=1024, N2, Nw=4096, Nw2, D=512, I=512, i, in, on, eof = 0, obank = 0 ;
 float P=1.0, *Hwin, *Wanal, *Wsyn, *input, *winput, *lpcoef, *buffer, *channel, *output ;
 float value;
 int hoop;
 float funcmin=10000.0, funcmax=0.0; 
 FILE *fp1, *fp2, *fopen();
float *warpfunc, *offsetfunc, *diffs;
float tadv, realtime, tlength=0.0;
int index_offset,ofunlen, ipos, wpos;
char filename1[128] = "wfunc" 
,filename2[128] = "ofunc";
float sthresh;
float syntgen = .001;
float amp_max;
int sflag=0;
int j;
int alias_flag = 0;
float NYQUIST;
float effectscale, freqscale;
if( isatty(1) ) usage(-1);
    while( (ch= crack( argc, argv, "R|N|M|D|I|F|l|w|o|s|g|d|a|h", 0  )) != NULL ) {
	switch(ch) {
	    case 'R':	R = atoi(arg_option);
			break;
	    case 'N':	N = atoi(arg_option);
			break;
	    case 'M':	Nw = atoi(arg_option);
			break;
	    case 'D':	D = atoi(arg_option);
			break;
	    case 'I':	I = atoi(arg_option);
			break;
	    case 'w':   strcpy(filename1, arg_option);
			break;
	    case 'o':   strcpy(filename2, arg_option);
	    		break;
	    case 'a':   alias_flag = 1;
	    		break;
	    case 'd':   tlength = atof(arg_option);
			break;
	    case 'g':   syntgen = atof(arg_option);
			break;
	    case 's':	sflag = 1;
			break;
	    case 'h':	usage(1);
	}
    }
if( tlength == 0. )
{
  fprintf(stderr,"please specify duration\n\n");
  usage(-1);
}
NYQUIST = (float)R/2.0;
    PI = 4.*atan(1.) ;
    TWOPI = 8.*atan(1.) ;
    obank = P != 0. ;
    N2 = N>>1 ;
    Nw2 = Nw>>1 ;
    fvec( Wanal, Nw ) ;		/* analysis window */
    fvec( Wsyn, Nw ) ;		/* synthesis window */
    fvec( input, Nw ) ;		/* input buffer */
    fvec( Hwin, Nw ) ;		/* plain Hamming window */
    fvec( winput, Nw ) ;	/* windowed input buffer */
    fvec( buffer, N ) ;		/* FFT buffer */
    fvec( warpfunc, N2+1 ) ;		/* FFT buffer */
    fvec( channel, N+2 ) ;	/* analysis channels */
    fvec( output, Nw ) ;	/* output buffer */
    fvec( diffs, N+2 ) ;	

    if ( (fp1 = fopen( filename1, "r" )) == NULL ) {
	fprintf(stderr,"warp function %s not found\n",filename1);
	exit(-1);
    }
    if ( (fp2 = fopen( filename2, "r" )) == NULL ) {
	fprintf(stderr,"offset function %s not found\n",filename2);
	exit(-1);
    }
    if (fread(warpfunc, sizeof(float), N2, fp1) == 0) {
	fprintf(stderr,"where is the rest of the warp function?\n");
 	exit(-1);
    }
    ofunlen = readin( fp2, &offsetfunc );
    // REPORT EXTREMES OF WARP
    for(i=0; i<N2; i++){
       if( funcmin > warpfunc[i] )
          funcmin = warpfunc[i];
       if( funcmax < warpfunc[i] )
          funcmax = warpfunc[i];
    }
    fprintf(stderr,"WARP FUNCTION EXTREMES: %f %f\n",funcmin,funcmax);
    funcmin = 100000000. ; funcmax = 0.;
    for(i=0; i<ofunlen; i++){
       if( funcmin > offsetfunc[i] )
          funcmin = offsetfunc[i];
       if( funcmax < offsetfunc[i] )
          funcmax = offsetfunc[i];
    }
    fprintf(stderr,"OFFSET FUNCTION EXTREMES: %f %f\n",funcmin,funcmax);

    tadv = (float)I/(float)R ;
    if (sflag)
      D = 0;

    realtime = 0.0;
    makewindows( Hwin, Wanal, Wsyn, Nw, N, I, obank ) ;
    in = -Nw ;
    if ( D )
	on = (in*I)/D ;
    else
	on = in ;
    for( i = 0; i < N2; i++ )
       diffs[i] = warpfunc[i] - 1.0 ;
    while ( !eof ) 
    {
        ipos = (int)((realtime/tlength)*(float)ofunlen);
	if( ipos >= ofunlen) ipos -= ofunlen;
	effectscale = offsetfunc[ ipos ];
	realtime += tadv;
	in += D ;
	on += I ;
	if ( D == 0 ) {
	    for ( hoop=0; hoop < N+2; hoop++ ) {
		if ( fread(channel+hoop, sizeof(float), 1, stdin) == 0 )
		    eof = 1;
	    }
	}else {
	   eof = shiftin( input, Nw, D ) ;
	   fold( input, Wanal, Nw, buffer, N, in ) ;
	   rfft( buffer, N2, FORWARD ) ;
	   convert( buffer, channel, N2, D, R ) ;
	}
        amp_max = 0.0;
	for(i=0;i<N;i+=2){
	   if(channel[i] > amp_max ) 
 	     amp_max = channel[i];
        }
	synt = amp_max * syntgen;
        for ( i=1, j=0; i < N; i+=2, j++  ) 
	{
	   freqscale = 1. + (diffs[j] * effectscale);
	   channel[i] *= freqscale;
	   if( channel[i] >= NYQUIST){
	      if( !alias_flag ){
	         channel[i-1] = 0.0;
		 }
	   }
	}

	if ( obank ) {
	    noscbank(channel, N2, R, Nw, I, P, output);
	    shiftout( output, Nw, I, on+Nw-I ) ;
	} else {
	    unconvert( channel, buffer, N2, I, R ) ;
	    rfft( buffer, N2, INVERSE ) ;
	    overlapadd( buffer, N, Wsyn, output, Nw, on ) ;
	    shiftout( output, Nw, I, on ) ;
	}
    }
    fprintf(stderr,"SQUEEGIE: RESYNTHESIS COMPLETED\n");
    exit( 0 ) ;
   
}

usage(meow)
{
    fprintf(stderr, "%s",
	"squeegie:  dynamic spectral warping\n"
	"squeegie   [flags] < floatsams > floatsams\n"
	"	N:	fft length [1024]\n"
	"	R:	sampling rate [44100]\n"
	"	M:	window size in samples [4096]\n"
	"	D:	decimation factor in samples [512]\n"
	"	I:	interpolation factor in samples [512]\n"
	"	w:	warp function [wfunc]\n"
	"	o:	scaling function [ofunc]\n"
	"	a:	permit aliasing\n"
	"	d:	duration of output [undefined]\n"
	"	g:	threshold generator [.001]\n"
	"	s:	synthesize analysis input\n"
	);
    exit(meow);
}
