#include "fury.h"

makewindows( H, A, S, Nw, N, I, osc )
    float H[], A[], S[]; int Nw, N, I, osc;
{
 int i;
 float sum;

    for ( i = 0; i < Nw; i++ )
	H[i] = A[i] = S[i] = 0.54 - 0.46*cos( TWOPI*i/(Nw - 1) );

    if ( Nw > N ) {
     float x;
     float PI = 4.*atan(1.);

	x = -(Nw - 1)/2.;
	for ( i = 0; i < Nw; i++, x += 1. )
	    if ( x != 0. ) {
		A[i] *= N*sin( PI*x/N )/(PI*x);
		if ( I )
		    S[i] *= I*sin( PI*x/I )/(PI*x);
	    }
    }

    for ( sum = i = 0; i < Nw; i++ )
	sum += A[i];

    for ( i = 0; i < Nw; i++ ) {
     float afac = 2./sum;
     float sfac = Nw > N ? 1./afac : afac;
	A[i] *= afac;
	S[i] *= sfac;
    }

    if ( Nw <= N && I ) {
	for ( sum = i = 0; i < Nw; i += I )
	    sum += S[i]*S[i];
	for ( sum = 1./sum, i = 0; i < Nw; i++ )
	    S[i] *= sum;
    }
}
