#include "pv.h"

complex zero = { 0., 0. } ;
complex one = { 1., 0. } ;
float PI ;
float TWOPI ;
float synt ;

main( argc, argv )
    int argc ; char *argv[] ;
{
static float SRATE = 44100.;
 int R, N, N2, Nw, Nw2, D, I, i, in, on, eof = 0, obank = 0, Np ;
 float P, *Hwin, *Wanal, *Wsyn, *input, *winput, *lpcoef, *buffer, *channel, *output ;
 float cutoff;
 float lpa(), maxamp() ;
 int maxbin;
 float maxampval,maxigain,threshfac;


    if ( argc < 8 ) {
	fprintf( stderr, "%s%s%s%s%s%s%s%s%s%s",
"USAGE: pv  R N Nw D I P threshfac cutoff < floatsams  > floatsams\n",
"	R    - sampling rate in Hz\n",
"	N    - FFT length in samples (must be 2^n)\n",
"	Nw   - window size in samples\n",
"	D    - decimation factor in samples [0 for synthesis only]\n",
"	I    - interpolation factor in samples [0 for analysis only]\n",
"	P    - oscillator bank pitch factor [0 for overlap-add resynthesis]\n",
"	thresh - scalar for floor below highest amp in frame\n",
"	cutoff  - highest frequency to resynthesize\n",
"	put your 8K function into /scratch/eric/func\n"
) ;
	exit( 0 ) ;
    }
/*
 * pick up arguments from command line
 */
    R     = atoi( argv[1] ) ;	/* sampling rate */
    N     = atoi( argv[2] ) ;	/* FFT length */
    Nw    = atoi( argv[3] ) ;	/* window size */
    D     = atoi( argv[4] ) ;	/* decimation factor */
    I     = atoi( argv[5] ) ;	/* interpolation factor */
    P     = atof( argv[6] ) ;	/* oscillator bank pitch factor */
    threshfac = atof( argv[7] ) ;	/* highest freq to resynthesize */
    cutoff= atof( argv[8] ) ;	/* highest freq to resynthesize */
    maxbin =  (cutoff/((SRATE/2.0)/(float)Nw))/2;
    synt = 0.;
    Np = 0;

    freopen( "pv.out", "w", stderr ) ;
    fprintf( stderr, "pv parameters:\n" ) ;
    fprintf( stderr, "R = %d\n", R ) ;
    fprintf( stderr, "N = %d\n", N ) ;
    fprintf( stderr, "Nw = %d\n", Nw ) ;
    fprintf( stderr, "D = %d\n", D ) ;
    fprintf( stderr, "I = %d\n", I ) ;
    fprintf( stderr, "P = %g\n", P ) ;
    fprintf( stderr, "Np = %d\n", Np ) ;
    fprintf( stderr, "synt = %g\n", synt ) ;
    fprintf(stderr,"resynthesizing %d bins out of %d\n",maxbin,N/2);
    fflush(stderr);

    PI = 4.*atan(1.) ;
    TWOPI = 8.*atan(1.) ;
    obank = P != 0. ;
    N2 = N>>1 ;
    Nw2 = Nw>>1 ;
/*
 * allocate memory
 */
    fvec( Wanal, Nw ) ;		/* analysis window */
    fvec( Wsyn, Nw ) ;		/* synthesis window */
    fvec( input, Nw ) ;		/* input buffer */
    fvec( Hwin, Nw ) ;		/* plain Hamming window */
    fvec( winput, Nw ) ;	/* windowed input buffer */
    fvec( lpcoef, Np+1 ) ;	/* lp coefficients */
    fvec( buffer, N ) ;		/* FFT buffer */
    fvec( channel, N+2 ) ;	/* analysis channels */
    fvec( output, Nw ) ;	/* output buffer */
/*
 * create windows
 */
    makewindows( Hwin, Wanal, Wsyn, Nw, N, I, obank ) ;
/*
 * initialize input and output time values (in samples)
 */
    in = -Nw ;
    if ( D )
	on = (in*I)/D ;
    else
	on = in ;
/*
 * main loop--perform phase vocoder analysis-resynthesis
 */
    while ( !eof ) {
/*
 * increment times
 */
	in += D ;
	on += I ;
/*
 * analysis: input D samples; window, fold and rotate input
 * samples into FFT buffer; take FFT; and convert to
 * amplitude-frequency (phase vocoder) form
 */
	    eof = shiftin( input, Nw, D ) ;
	    fold( input, Wanal, Nw, buffer, N, in ) ;
	    rfft( buffer, N2, FORWARD ) ;
	    convert( buffer, channel, N2, D, R ) ;
/*
 * at this point channel[2*i] contains amplitude data and
 * channel[2*i+1] contains frequency data (in Hz) for phase
 * vocoder channels i = 0, 1, ... N/2; the center frequency
 * associated with each channel is i*f, where f is the
 * fundamental frequency of analysis R/N; 
 */
/*
 * oscillator bank resynthesis
 */
 maxampval = 0.;
 for(i=0;i<maxbin;i++){
	if(channel[2*i] > maxampval ) maxampval = channel[2*i];
 }
 maxigain = maxampval*threshfac;
piggybank( channel, N2, lpcoef, Np, R, Nw, I, P, output, maxigain, maxbin) ;
	   shiftout( output, Nw, I, on+Nw-I ) ;
    }
    exit( 0 ) ;
}


/*
 * oscillator bank resynthesizer for phase vocoder analyzer
 * uses sum of N+1 cosinusoidal table lookup oscillators to 
 * compute I (interpolation factor) samples of output O
 * from N+1 amplitude and frequency value-pairs in C;
 * frequencies are scaled by P
 */
piggybank( C, N, lpcoef, npoles, R, Nw, I, P, O , maxgain, maxbin)
    float C[], lpcoef[], O[], P, maxgain ; int N, Nw, npoles, R, I, maxbin ;
{
 FILE *fink;
int omit=0;
 static int NP, L = 32768, first = 1 ;
 static float Iinv, *lastamp, *lastfreq, *index, *table , *rampup, *rampdown;
 static int active[32768];
 static int INACTIVE = 0;
 static int ACTIVE = 1;
 static int GOING_UP = 2;
 static int GOING_DOWN = 3;
 static float Pinc, ffac ;
 int amp, freq, n, chan ;
 int z;

/*
 * FIRST TIME ONLY: allocate memory to hold previous values
 * of amplitude and frequency for each channel, the table
 * index for each oscillator, and the table itself; also
 * compute constants
 */
    if ( first ) {
     float TWOPIoL = TWOPI/L, tabscale ;
	first = 0 ;
	fvec( lastamp, N+1 ) ;
	fvec( lastfreq, N+1 ) ;
	fvec( index, N+1 ) ;
	fvec( table, L ) ;
	fvec( rampup, I );
	fvec( rampdown, I );
	/* tabscale = npoles ? 2./Nw : ( Nw >= N ? N : 8*N ) ; */
        tabscale = 8.0*(float)N;
	fink = fopen("/scratch/eric/func","r");
	nabfunc(table,fink);
	for(z=0;z<L;z++) table[z] *= tabscale;
	for( n = 0; n < I; n++){
		rampup[n] = (float)n/(float)I;
		rampdown[n] = 1.0 - rampup[n];
	}
	Iinv = 1./I ;
	Pinc = P*L/R ;
	ffac = P*PI/N ;
	if ( P > 1. )
	    NP = N/P ;
	else
	    NP = N ;
	for(n=0;n<NP;n++) active[n] = INACTIVE;
    }
/*
 * for each channel, compute I samples using linear
 * interpolation on the amplitude and frequency
 * control values
 */
 fprintf(stderr,"maxgain: %f\n",maxgain); fflush(stderr);
    for ( chan =  0 ; chan < maxbin ; chan++ ) {
     register float a, ainc, f, finc, address ;
	freq = ( amp = ( chan << 1 ) ) + 1 ;
	if ( C[amp] < maxgain || maxgain == 0.){  
		 ++omit;
		if(active[chan] == INACTIVE) continue;
		else active[chan] = GOING_DOWN;
	}
	if( active[chan] == INACTIVE) active[chan] = GOING_UP;
    /* fprintf(stderr,"loopcnt %d status %d\n",chan,active[chan]); fflush(stderr); */
    /* fprintf(stderr,"%d\n",chan); fflush(stderr);  */

	C[freq] *= Pinc ;
	finc = ( C[freq] - ( f = lastfreq[chan] ) )*Iinv ;
	ainc = ( C[amp] - ( a = lastamp[chan] ) )*Iinv ;
	address = index[chan] ;
/*
 * accumulate the I samples from each oscillator into
 * output array O (initially assumed to be zero);
 * f is frequency in Hz scaled by oscillator increment
 * factor and pitch (Pinc); a is amplitude;
 */
	if( active[chan] == ACTIVE){
		for ( n = 0 ; n < I ; n++ ) {
	    		O[n] += a*table[ (int) address ] ;
	    		address += f ;
	    		while ( address >= L )
			address -= L ;
	    		while ( address < 0 )
			address += L ;
	    		a += ainc ;
	    		f += finc ;
		} 
	}
	else if( active[chan] == GOING_UP ){
		for ( n = 0 ; n < I ; n++ ) {
	    		O[n] += (a*table[ (int) address ])*rampup[n] ;
	    		address += f ;
	    		while ( address >= L )
			address -= L ;
	    		while ( address < 0 )
			address += L ;
	    		a += ainc ;
	    		f += finc ;
		} 
		active[chan] = ACTIVE;
	}
	else if( active[chan] == GOING_DOWN ){
		for ( n = 0 ; n < I ; n++ ) {
	    		O[n] += (a*table[ (int) address ])*rampdown[n] ;
	    		address += f ;
	    		while ( address >= L )
			address -= L ;
	    		while ( address < 0 )
			address += L ;
	    		a += ainc ;
	    		f += finc ;
		} 
		active[chan] = INACTIVE;
	}
/*
 * save current values for next iteration
 */
	lastfreq[chan] = C[freq] ;
	lastamp[chan] = C[amp] ;
	index[chan] = address ;
    }
    fprintf(stderr,"%d channels omitted\n",omit);
    fflush(stderr);
}
#define FLEN 8192
/* read a function into table */
nabfunc( A, fptr) float A[] ;  FILE *fptr;
{
	int i ;
	int shirtsamp;
	static int valid = -1 ;

	if ( fread( A, sizeof(float), FLEN, fptr ) == NULL ) {
		valid = i ;
  	}
}
