#include <stdio.h>
#include <math.h>

extern int diag;

/*  compression/expansion routine! */ 
	
double squat( buffer, thresh, ratio, nt, nmult, N )
float *buffer, thresh, ratio, nt, nmult;
int N;
{
  register int		i;
  static int 		hoax = 1;
  double 		rms = 0.;
  static float		dbthr,
  			save = 0.;
  register float 	mult;

  if (hoax) {
    dbthr = 10. * log10(thresh);
    hoax = 0;
  }

  for ( i=0; i < N; i++ )
    rms += ( *(buffer+i) * *(buffer+i) );

  rms = sqrt(rms/N);
  if (rms < nt && ratio < 1.)
    mult = nmult;
  else
    mult = pow( 10., (( dbthr - (( dbthr - (10. * log10(rms)) ) * ratio) ) / 10.) ) / rms;

  if (diag) {
    if (rms <= thresh)
      fprintf(stderr,"below  dbthr: %f  dbrms: %f rms: %f  mult: %f\n", dbthr, (10. * log10(rms)), rms, mult);
    else
      fprintf(stderr,"above  dbthr: %f  dbrms: %f rms: %f  mult: %f\n", dbthr, (10. * log10(rms)), rms, mult);
  }

  for ( i=0; i < N; i++ )
    *(buffer+i) *= mult;

  return rms;
}

