#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include "crack.h"
#include "pv.h"
#include "stridex.h"

float fthresh = 1000.;

main(argc, argv)
    int argc; char *argv[];
{
    int 	R,
		N,
		N2,
		Nw = 0,
		D = 128, 
		I = 0,
		i,j,
		in,
		on,
    		nt = 0,
		eof = 0;
    float 	P = 1.,
    		hoax,
		ster,
		len,
		*Hwin,
		*Wanal,
		*Wsyn,
		*input,
		*buffer,
		*chan,
		*output;
    char	ch,
    		*space(),
    		filename[128];
    FILE	*fp;
    Harry	*harms;

    synt = 0.;
    zero.re = 0.;
    zero.im = 0.;
    one.re = 1.;
    one.im = 0.;

    if (isatty(0))
	usage(1);

    while( (ch= crack( argc, argv, "R|N|M|D|I|P|f|g|n|t|h", 0  )) != NULL ) {
	switch(ch) {
	    case 'R':	R = atoi(arg_option);
			break;
	    case 'N':	N = atoi(arg_option);
			break;
	    case 'M':	Nw = atoi(arg_option);
			break;
	    case 'D':	D = atoi(arg_option);
			break;
	    case 'I':	I = atoi(arg_option);
			break;
	    case 'P':	sscanf(arg_option, "%f", &P);
			break;
	    case 'f':	strcpy( filename, arg_option );
			break;
	    case 'g':	sscanf(arg_option, "%f", &synt);
			break;
	    case 'n':	nt = atoi(arg_option);
	      		break;
	    case 't':	fthresh = atof(arg_option);
			break;
	    case 'h':	usage(1);
	}
    }

    if (Nw == 0)
	Nw = N;

    if (I == 0)
	I = D;

    PI = 4.*atan(1.);
    TWOPI = 8.*atan(1.);
    N2 = N>>1;

    Wanal = (float *) space( Nw, sizeof(float) );
    Wsyn = (float *) space( Nw, sizeof(float) );
    input = (float *) space( Nw, sizeof(float) );
    Hwin = (float *) space( Nw, sizeof(float) );
    buffer = (float *) space( N, sizeof(float) );
    chan = (float *) space( N+2, sizeof(float) );
    output = (float *) space( Nw, sizeof(float) );

    makewindows( Hwin, Wanal, Wsyn, Nw, N, I, 1 );

    if ( (fp = fopen( filename, "r" )) == NULL ) {
        fprintf( stderr,"what is %s?\n", filename);
        exit(-1);
    }

    if (nt < 0) {
	fprintf(stderr,"you got to have some tables\n");
	usage(1);
    }

    if (nt == 0) {
      harms = (Harry *) space( Harm_Tables, sizeof(Harry) );
      for ( i=0; i < Harm_Tables; i++ ) {
	(harms+i)->harm = (float *) space( Max_Harm, sizeof(float) );
	(harms+i)->stor = (float *) space( Max_Harm, sizeof(float) );
      }

      i = 0;
      while( (fscanf( fp, "%f ", &hoax )) != EOF && i < Max_Harm ) {
	*(harms->stor+i) = hoax;
	++i;
      } 
      harms->elms = i;
    }
    else {
      harms = (Harry *) space( nt, sizeof(Harry) );
      for ( i=0; i < nt; i++ ) {
	(harms+i)->harm = (float *) space( Max_Harm, sizeof(float) );
	(harms+i)->stor = (float *) space( Max_Harm, sizeof(float) );
      }

      for ( j=0; j < nt; j++ ) {
	i = 0;
	while ( (ch=getc(fp)) != '\n' && ch != EOF ) {
          ungetc(ch, fp);
          fscanf(fp,"%f %f ", &hoax, &ster);
	  *((harms+j)->harm+i) = hoax;
	  *((harms+j)->stor+i) = ster;
	  ++i;
	}
	(harms+j)->elms = i;
      }
    }

    in = -Nw;
    if ( D )
	on = (in*I)/D;
    else
	on = in;

    while ( !eof ) {
      in += D;
      on += I;

      eof = shiftin( input, Nw, D );
      fold( input, Wanal, Nw, buffer, N, in );
      rfft( buffer, N2, FORWARD );
      convert( buffer, chan, N2, D, R );
      dexbank( chan, N2, R, Nw, I, P, output, harms, nt );
      shiftout( output, Nw, I, on+Nw-I );
    }
    exit(0);
}

usage(woof)
{
    fprintf(stderr, "%s%s%s%s%s%s%s%s%s%s%s%s%s",
	"stridex:  linear distortion processor\n",
	"stridex   [flags] < floatsams > floatsams\n",
	"	N:	fft length [2^n]\n",
	"	R:	sampling rate\n",
	"	M:	window size in samples\n",
	"	D:	decimation factor in samples\n",
	"	I:	interpolation factor in samples\n",
	"	P:	oscillator bank pitch factor\n",
	"	f:	harmonics data file\n",
	"	n:	number of tables\n",
	"	g:	oscillator resynthesis gate threshold\n",
	"	t:	frequency cut-off threshold\n",
	"	h:	this warm and fuzzy place\n");
    exit(woof);
}

