#include "pv.h"

/*	This routine is a hack of the phase-vocoder convert subroutine.
	It gets the real part of the FFT amplitude for each 'bin' and
	multiplies these by a filter function.
*/ 
	
void turnip( float *S1, float *S2, float *C1, float *C2, int N2, float mult )
{
 int real, imag, amp, phase;
 float a1,a2, b1,b2,
       min, diff;
 int i ;
 Bound ext,
       extrema();

    for ( i = 0 ; i <= N2 ; i++ ) {
	imag = phase = ( real = amp = i<<1 ) + 1 ;
	a1 = ( i == N2 ? S1[1] : S1[real] ) ;
	b1 = ( i == 0 || i == N2 ? 0. : S1[imag] ) ;
	a2 = ( i == N2 ? S2[1] : S2[real] ) ;
	b2 = ( i == 0 || i == N2 ? 0. : S2[imag] ) ;
	C1[amp] = hypot( a1, b1 );
	C1[phase] = -atan2( b1, a1 );
	C2[amp] = hypot( a2, b2 );
	C2[phase] = -atan2( b2, a2 );
    }
    
    ext = extrema(N2, C2);
    min = ext.min;
    diff = ext.max - ext.min;
    if (diff == 0.)
      diff = 1.;  /* negative difference just for laughs */

    for ( i=0; i <= N2; i++ ) {
	amp = i<<1;
        C1[amp] *= ( (C2[amp] - min) / diff * mult);
    }

    for ( i = 0 ; i <= N2 ; i++ ) {
	imag = phase = ( real = amp = i<<1 ) + 1 ;
	S1[real] = *(C1+amp) * cos( *(C1+phase) );
	if ( i != N2 ) 
	    S1[imag] = -*(C1+amp) * sin( *(C1+phase) );
	    
    }
}

