#include <stdlib.h>
#include <stdio.h>
#include "sfheader.h"
#include "immolate.h"
#include "crack.h"

#define Max_Table_Size 65536

int		R = 44100,
		N = 1024,
  		N2,
  		D = 0,
  		I = 0,
		its = 64,	/* number of decimated filters */
  		obank = 0;
float 		PI,
 		TWOPI,
 		synt = 0.,
		mult = .5;
complex 	zero = { 0., 0. };
complex 	one = { 1., 0. };
Chan		*chin1, *chin2;

main(argc, argv)
int argc; char *argv[];
{
    int 	i,
		hoop,		/* looping variable */
		Nw,
		Nw2,
		in,
		on,
    		eof = 0,
		aflag = 0,
		sflag = 0,
		Np = 0;
    float 	*Hwin,
		*Wanal,
		*Wsyn,
		*input1,
                *input2,
		*buffer1,
                *buffer2,
		*channel1,
                *channel2,
		*output,
                grab,
    		P = 0.;
    char	ch,
		file1[128],
                file2[128],
                amapfile[128],
		*dbuf;
    FILE	*fp1,
                *fp2;

    if (argc < 3)
	usage(1);

    while( (ch= crack( argc, argv, "R|N|M|D|I|i|P|m|f|F|A|t|g|ash", 0  )) != NULL ) {
	switch(ch) {
	    case 'R':	R = atoi(arg_option);
			break;
	    case 'N':	N = atoi(arg_option);
			break;
	    case 'M':	Nw = atoi(arg_option);
			break;
	    case 'D':	D = atoi(arg_option);
			break;
	    case 'I':	I = atoi(arg_option);
			break;
	    case 'P':	P = atof(arg_option);
	      		break;
	    case 'i':	its = atoi(arg_option);
			break;
	    case 'm':   mult = atof(arg_option);
	                break;
	    case 'f':	strcpy(file1, arg_option);
	      		break;
	    case 'F':	strcpy(file2, arg_option);
	      		break;
	    case 'A':   strcpy(amapfile, arg_option);
	                break;
	    case 'a':	aflag = 1;
			break;
	    case 's':	sflag = 1;
			break;
	    case 'h':	usage(1);
	}
    }

    if (Nw == 0)
	Nw = N;

    if (aflag && sflag) {
	fprintf(stderr,"specify either -a or -s not both\n");
	exit(1);
    }

    if (sflag)
	D = 0;
    else {
      if (D == 0)
	D = N / 8;
    }

    if (aflag)
	I = 0;
    else
	if (I == 0)
	    I = D;

    PI = 4.*atan(1.);
    TWOPI = 8.*atan(1.);
    N2 = N>>1; 
    Nw2 = Nw>>1;
    obank = P != 0.;

/* allocate memory */

    Wanal = (float *) space( Nw, sizeof(float) );        /* analysis window */
    Wsyn = (float *) space( Nw, sizeof(float) );	/* synthesis windows */
    input1 = (float *) space( Nw, sizeof(float) );	/* input buffers */
    input2 = (float *) space( Nw, sizeof(float) );
    Hwin = (float *) space( Nw, sizeof(float) );	/* plain Hamming window */
    buffer1 = (float *) space( N, sizeof(float) );	/* FFT buffer */
    buffer2 = (float *) space( N, sizeof(float) );
    channel1 = (float *) space( N+2, sizeof(float) );	/* analysis channels */
    channel2 = (float *) space( N+2, sizeof(float) );
    output = (float *) space( Nw, sizeof(float) );	/* output buffer */
    chin1 = (Chan *) space( its, sizeof(Chan) );
    chin2 = (Chan *) space( its, sizeof(Chan) );

/* create windows */

    makewindows( Hwin, Wanal, Wsyn, Nw, N, I, 0 );

/* initialize input and output time values (in samples) */

    in = -Nw;
    if ( D )
	on = (in*I)/D;
    else
	on = in;

/* open input files */

    if ( (fp1 = fopen( file1, "r" )) == NULL ) {
	fprintf(stderr,"Where is %s?\n",file1);
	exit(-1);
    }
    if ( (fp2 = fopen( file2, "r" )) == NULL ) {
	fprintf(stderr,"Where is %s?\n",file2);
	exit(-1);
    }
    
    (void) stripheader(fp1);
    (void) stripheader(fp2);

/* main loop--perform phase vocoder analysis-resynthesis */

    while ( !eof ) {

/* increment times */

	in += D;
	on += I;

/* analysis: input D samples; window, fold and rotate input
   samples into FFT buffer; take FFT; and convert to
   amplitude-frequency (phase vocoder) form */

	eof = turnin( input1, Nw, D, fp1 );
	if (eof)
	    (void) turnin( input2, Nw, D, fp2 );
	else
	    eof = turnin( input2, Nw, D, fp2 );

	fold( input1, Wanal, Nw, buffer1, N, in );
	fold( input2, Wanal, Nw, buffer2, N, in );
	rfft( buffer1, N2, FORWARD );
	rfft( buffer2, N2, FORWARD );
	immolate( buffer1, buffer2, channel1, channel2 );
	
	if ( I == 0 ) {
	    fwrite( channel1, sizeof(float), N+2, stdout );
	    fflush( stdout );
	    continue;
	}

	else {
	  noscbank( channel1, its<<1, R, Nw, I, P, output );
	  shiftout( output, Nw, I, on+Nw-I );
        }
    }
    exit(0);
}

stripheader(fp)
FILE *fp;
{
  register int i;

  for ( i=0; i < SIZEOF_HEADER; i++ )
    fgetc(fp);
}

usage(woof)
{
    fprintf(stderr, "%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s",
	"immolate: phase vocoder based spectral interpolation\n",
	"immolate  [flags] > floatsams\n",
	"	N:	fft length [2^n]\n",
	"	R:	sampling rate\n",
	"	M:	window size in samples\n",
	"	D:	decimation factor in samples\n",
	"	P:	oscillator bank pitch factor\n",
	"	I:	interpolation factor in samples\n",
	"	m:	interpolation multiplier\n",
	"	i:	number of decimated filters\n",
	"	f:	first input file\n",
	"	F:	second input file\n",
	"	t:	amplitude discrimination threshold\n",
	"	g:	oscillator resynthesis gate threshold\n",
	"	a:	analysis data output\n",
	"	s:	synthesize analysis input\n");
    exit(woof);
}
