#include <stdlib.h>
#include <math.h>
#include "pv.h"
#include "stridex.h"

dexbank( C, N, R, Nw, I, P, O, harms, nt )
    float C[], O[], P; int N, Nw, R, I, nt; Harry *harms;
{
  static int 	NP,
		L = 65536,
  		ttype = 0,
 		first = 1;
  static float 	Iinv,
		*lastamp,
 		*lastfreq,
 		**index,
		*table_sine;
  static float 	Pinc,
		ffac;
  float		div,
		dif,
  		a,
  		ainc,
  		f,
		finc,
  		sf,sa,
		hfinc,hainc,
		hfmult,hamult,
		address;
  int 		amp,
		freq,
  	        tabl,
		ptabl,
  		h,
		n,
		i,j,
		count,
		chan;
  static Extr	cext;
  Extr 		pext,
    		extrema();

  if ( nt == 0 ) {
    ttype = 1;
    nt = Harm_Tables;
  }

  if ( first ) {
    float TWOPIoL = TWOPI/L, tabscale;
    first = 0;
    lastamp = (float *) space( N+1, sizeof(float *) );
    lastfreq = (float *) space( N+1, sizeof(float *) );
    table_sine = (float *) space( L, sizeof(float) );
    index = (float **) space( harms->elms, sizeof(float *) );
    for ( i=0; i < harms->elms; i++ )
      *(index+i) = (float *) space( N+1, sizeof(float) );

    tabscale = ( Nw >= N ? N : 8*N );
    for ( n = 0; n < L; n++ )
      table_sine[n] = tabscale*cos( TWOPIoL*n );
    Iinv = 1./I;
    Pinc = P*L/R;
    ffac = P*PI/N;
    if ( P > 1. )
      NP = N/P;
    else
      NP = N;

    pext.min = 0.;
    pext.max = 0.;

    if (ttype) {
      h = harms->elms;

      for ( i=0; i < h; i++ )
	*(harms->harm+i) = (float) (i+1);

      for ( i=1; i < Harm_Tables; i++ ) {
	for ( j=0; j < harms->elms; j++ ) {
	  *((harms+i)->stor+j) = *((harms+(i-1))->stor+j);
	  *((harms+i)->harm+j) = *((harms+(i-1))->harm+j);
	}
	while ( *(((harms+i)->stor)+h-1) <= 0. )
	  --h;
	div = 1.;
	for ( j=h; j > 0; j-- ) {
	  dif = *(((harms+i)->stor)+(j-1)) * ( (float) h / (Harm_Tables - 
			(i-1)) / div );
	  if ( dif > *(((harms+i)->stor)+(j-1)) )
	    dif = *(((harms+i)->stor)+(j-1));
	  *(((harms+i)->stor)+(j-1)) -= dif;
	  *((harms+i)->stor) += dif;
	  div *= 2.;
	}
	(harms+i)->elms = harms->elms;
      }
    }
/*
    for ( i=0; i< Harm_Tables; i++ ) {
      for ( j=0; j < (harms+i)->elms; j++ ) {
	fprintf(stderr,"%f %f ", *((harms+i)->harm+j), *((harms+i)->stor+j)); 
      }
      fprintf(stderr,"\n");
    }
*/
  }


    pext.min = cext.min;
    pext.max = cext.max;
    cext = extrema(N, C);

    a = ainc = f = finc = address = 0.;
    for ( chan = 0; chan < NP; chan++ ) {
      if ( *(C+amp) < synt )
	continue;
      freq = ( amp = ( chan << 1 ) ) + 1;

      *(C+freq) *= Pinc;
      if ( *(C+freq) > fthresh )
	tabl = 0;
      else
	tabl = ((int) (( (*(C+amp) - cext.min) / cext.max ) * 
		       ( (float) nt - 1. )) % nt);
      ptabl = ((int) (( (*(lastamp+chan) - pext.min) / pext.max ) * 
		      ( (float) nt - 1. )) % nt);

      finc = ( *(C+freq) - ( f = *(lastfreq+chan) ) ) * Iinv;
      ainc = ( *(C+amp) - ( a = *(lastamp+chan) ) ) * Iinv;
      sa = a;
      sf = f;

      for ( i=0; i < harms->elms; i++ ) {
	hfinc = (*((harms+tabl)->harm+i) - *((harms+ptabl)->harm+i)) * Iinv;
	hainc = (*((harms+tabl)->stor+i) - *((harms+ptabl)->stor+i)) * Iinv;
	hfmult = *((harms+tabl)->harm+i);
	hamult = *((harms+tabl)->stor+i);
	for ( n = 0; n < I; n++ ) {
	  address = *(*(index+i)+chan);
	  *(O+n) += (a * hamult) * *( table_sine + ((int) address) );
	  address += (f * hfmult);
	  while ( address >= L )
	    address -= L;
	  while ( address < 0 )
	    address += L;
	  *(*(index+i)+chan) = address;
	  a += ainc;
	  f += finc;
	  hfmult += hfinc;
	  hamult += hainc;
	}
	a = sa;
	f = sf;
      } 
      *(lastfreq+chan) = *(C+freq);
      *(lastamp+chan) = *(C+amp);
    }
  pext.min = cext.min;
  pext.max = cext.max;
}

float rtnlook( incr, crloc, t, l )
float   incr,
        *crloc,
  	*t;
int     l;
{
    float      rtn;

    while ( ((int) *crloc) > l )
        *crloc -= (float) l;
    while ( ((int) *crloc) < 0 )
        *crloc += (float) l;
    rtn = *(t + ( (int) *crloc ));
    *crloc += incr;
    return rtn;
}


Extr extrema( n, data )
int n; float *data;
{
    int i;
    Extr extr;

    extr.min = *data;
    for( i=0; i < n; i++ ) {
        if ( extr.min > fabs( *(data + (i*2))) )
            extr.min = fabs( *(data + (2*i)) );
    }
    extr.max = *data;
    for( i=0; i < n; i++ ) {
        if ( extr.max < fabs( *(data + (2*i))) )
            extr.max = fabs( *(data + (i*2)) );
    }
    return extr;
}
