/*************************************************************************
 *                                                                       *
 *               ROUTINES IN THIS FILE:                                  *
 *                                                                       *
 *                      inverse_nl(): nonlinear processing; intended as  *
 *                              a kind of inverse for pre-rasta          *
 *                              nonlinearities                           *
 *                                                                       *
 ************************************************************************/

#include <stdio.h>
#include <math.h>
#include "rasta.h"
#include "functions.h"

/*
 *	This routine computes a nonlinear function of
 *	an fvec array (floats).
 *	Currently this is  just the exp, which is the inverse
 *	of the log compression used in log rasta.
 *
 *	The first time that this program is called, we do
 *	the usual allocation.
 */
struct fvec *inverse_nonlin( const struct param *pptr, struct fvec *in)
{

	int i, lastfilt;
	char *funcname;

	static struct fvec *outptr = NULL; 
			/* array for nonlinear auditory spectrum */

	funcname = "inverse_nonlin";

	if(outptr == (struct fvec *)NULL)
	{
		outptr = alloc_fvec( pptr->nfilts );
	}

	lastfilt = pptr->nfilts - pptr->first_good;

	/* We only check on the incoming vector, as the output
		is allocated here so we know how long it is. */
	fvec_check(funcname, in, lastfilt - 1);

	for(i=pptr->first_good; i<lastfilt; i++)
	{
		if(pptr->lrasta == TRUE || pptr->jrasta == TRUE)
		{
			outptr->values[i] 
			= exp((in->values[i]));
		}
		else
		{
			outptr->values[i] 
			= (in->values[i]);
		}
	}

	return( outptr );
}

