/*
**
** Matrix-Matrix Code for the operation:
**    C = A*B
**
** Automatically Generated by mm_gen ($Revision: 1.1 $) using the command:
**    /n/burrito/da/bilmes/phipac/mm_gen/mm_gen -cb 2 2 2 -cb 4 4 4 -beta 0 -prec doub -file mul_mdmd_md.c -routine_name mul_mdmd_md 
**
** Run '/n/burrito/da/bilmes/phipac/mm_gen/mm_gen -help' for help.
**
** Generated on: Tuesday October 17 1995, 16:45:34 PDT
** Created by: Jeff Bilmes <bilmes@cs.berkeley.edu>
**
**
** Usage:
**    mul_mdmd_md(const int M, const int K, const int N, const double *const A, const double *const B, double *const C, const int Astride, const int Bstride, const int Cstride)
** where
**  A is an MxK matrix
**  B is an KxN matrix
**  C is an MxN matrix
**  Astride is the number of entries between the start of each row of A
**  Bstride is the number of entries between the start of each row of B
**  Cstride is the number of entries between the start of each row of C
**
*/

#define LOAD1x1(c00,C,Cstride) \
{\
   double * _cp = C; \
   c00 = _cp[0]; \
}

#define STORE1x1(c00,C,Cstride) \
{\
   double *_cp = C; \
   _cp[0] = c00; \
}

/* Fixed M,K,N = 1,1,1 fully-unrolled matrix matrix multiply. */
#define mul_md1x1md1x1_md1x1(c00,A0,B,Bstride) \
{ \
   register double _b0; \
   register double _a0; \
   \
   \
   _b0 = B[0]; \
   B += Bstride; \
   _a0 = A0[0]; \
   c00 += _a0*_b0; \
}


/* Fixed M,K,N = 1,2,1 fully-unrolled matrix matrix multiply. */
#define mul_md1x2md2x1_md1x1(c00,A0,B,Bstride) \
{ \
   register double _b0; \
   register double _a0; \
   \
   \
   _b0 = B[0]; \
   B += Bstride; \
   _a0 = A0[0]; \
   c00 += _a0*_b0; \
   \
   _b0 = B[0]; \
   B += Bstride; \
   _a0 = A0[1]; \
   c00 += _a0*_b0; \
}


#define LOAD1x2(c00,c01,C,Cstride) \
{\
   double * _cp = C; \
   c00 = _cp[0]; c01 = _cp[1]; \
}

#define STORE1x2(c00,c01,C,Cstride) \
{\
   double *_cp = C; \
   _cp[0] = c00; _cp[1] = c01; \
}

/* Fixed M,K,N = 1,1,2 fully-unrolled matrix matrix multiply. */
#define mul_md1x1md1x2_md1x2(c00,c01,A0,B,Bstride) \
{ \
   register double _b0,_b1; \
   register double _a0; \
   \
   \
   _b0 = B[0]; _b1 = B[1]; \
   B += Bstride; \
   _a0 = A0[0]; \
   c00 += _a0*_b0; c01 += _a0*_b1; \
}


/* Fixed M,K,N = 1,2,2 fully-unrolled matrix matrix multiply. */
#define mul_md1x2md2x2_md1x2(c00,c01,A0,B,Bstride) \
{ \
   register double _b0,_b1; \
   register double _a0; \
   \
   \
   _b0 = B[0]; _b1 = B[1]; \
   B += Bstride; \
   _a0 = A0[0]; \
   c00 += _a0*_b0; c01 += _a0*_b1; \
   \
   _b0 = B[0]; _b1 = B[1]; \
   B += Bstride; \
   _a0 = A0[1]; \
   c00 += _a0*_b0; c01 += _a0*_b1; \
}


#define LOAD2x1(c00,c10,C,Cstride) \
{\
   double * _cp = C; \
   c00 = _cp[0]; \
   _cp += Cstride; \
   c10 = _cp[0]; \
}

#define STORE2x1(c00,c10,C,Cstride) \
{\
   double *_cp = C; \
   _cp[0] = c00; \
   _cp += Cstride; \
   _cp[0] = c10; \
}

/* Fixed M,K,N = 2,1,1 fully-unrolled matrix matrix multiply. */
#define mul_md2x1md1x1_md2x1(c00,c10,A0,A1,B,Bstride) \
{ \
   register double _b0; \
   register double _a0,_a1; \
   \
   \
   _b0 = B[0]; \
   B += Bstride; \
   _a0 = A0[0]; \
   c00 += _a0*_b0; \
   _a1 = A1[0]; \
   c10 += _a1*_b0; \
}


/* Fixed M,K,N = 2,2,1 fully-unrolled matrix matrix multiply. */
#define mul_md2x2md2x1_md2x1(c00,c10,A0,A1,B,Bstride) \
{ \
   register double _b0; \
   register double _a0,_a1; \
   \
   \
   _b0 = B[0]; \
   B += Bstride; \
   _a0 = A0[0]; \
   c00 += _a0*_b0; \
   _a1 = A1[0]; \
   c10 += _a1*_b0; \
   \
   _b0 = B[0]; \
   B += Bstride; \
   _a0 = A0[1]; \
   c00 += _a0*_b0; \
   _a1 = A1[1]; \
   c10 += _a1*_b0; \
}


#define LOAD2x2(c00,c01,c10,c11,C,Cstride) \
{\
   double * _cp = C; \
   c00 = _cp[0]; c01 = _cp[1]; \
   _cp += Cstride; \
   c10 = _cp[0]; c11 = _cp[1]; \
}

#define STORE2x2(c00,c01,c10,c11,C,Cstride) \
{\
   double *_cp = C; \
   _cp[0] = c00; _cp[1] = c01; \
   _cp += Cstride; \
   _cp[0] = c10; _cp[1] = c11; \
}

/* Fixed M,K,N = 2,1,2 fully-unrolled matrix matrix multiply. */
#define mul_md2x1md1x2_md2x2(c00,c01,c10,c11,A0,A1,B,Bstride) \
{ \
   register double _b0,_b1; \
   register double _a0,_a1; \
   \
   \
   _b0 = B[0]; _b1 = B[1]; \
   B += Bstride; \
   _a0 = A0[0]; \
   c00 += _a0*_b0; c01 += _a0*_b1; \
   _a1 = A1[0]; \
   c10 += _a1*_b0; c11 += _a1*_b1; \
}


/* Fixed M,K,N = 2,2,2 fully-unrolled matrix matrix multiply. */
#define mul_md2x2md2x2_md2x2(c00,c01,c10,c11,A0,A1,B,Bstride) \
{ \
   register double _b0,_b1; \
   register double _a0,_a1; \
   \
   \
   _b0 = B[0]; _b1 = B[1]; \
   B += Bstride; \
   _a0 = A0[0]; \
   c00 += _a0*_b0; c01 += _a0*_b1; \
   _a1 = A1[0]; \
   c10 += _a1*_b0; c11 += _a1*_b1; \
   \
   _b0 = B[0]; _b1 = B[1]; \
   B += Bstride; \
   _a0 = A0[1]; \
   c00 += _a0*_b0; c01 += _a0*_b1; \
   _a1 = A1[1]; \
   c10 += _a1*_b0; c11 += _a1*_b1; \
}


/* Fixed M,N = 8,8, Arbitrary K L0-blocked matrix matrix multiply. */
static void
mul_mdmd_md_l1_arb_k(int K, const double *const A, const double *const B, double *const C, const int Astride, const int Bstride, const int Cstride)
{
   const double *a0,*b0;
   double *c0;
   const double *ap0_0,*ap0_1;
   const double *bp0;
   double *cp0;
   const int A_sbs_stride = Astride*2;
   const int C_sbs_stride = Cstride*2;
   const int k_marg_el = K & 1;
   const int k_norm = K - k_marg_el;
   double *const c0_endp = C+8*Cstride;
   register double c00,c01,c10,c11;
   for (c0=C,a0=A; c0!= c0_endp; c0+=C_sbs_stride,a0+=A_sbs_stride) {
      const double* const ap0_endp = a0 + k_norm;
      double* const cp0_endp = c0 + 8;
      for (b0=B,cp0=c0; cp0!=cp0_endp; b0+=2,cp0+=2) {
         ap0_0 = a0;
         ap0_1 = ap0_0 + Astride;
         bp0=b0;
         LOAD2x2(c00,c01,c10,c11,cp0,Cstride);
         for (; ap0_0!=ap0_endp; ap0_0+=2,ap0_1+=2) {
            mul_md2x2md2x2_md2x2(c00,c01,c10,c11,ap0_0,ap0_1,bp0,Bstride);
         }
         if (k_marg_el & 0x1) {
            mul_md2x1md1x2_md2x2(c00,c01,c10,c11,ap0_0,ap0_1,bp0,Bstride);
         }
         STORE2x2(c00,c01,c10,c11,cp0,Cstride);
      }
   }
}

/* Arbitrary M,K,N L0-blocked matrix matrix multiply. */
static void
mul_mdmd_md_l1_arb_all(const int M, const int K, const int N, const double *const A, const double *const B, double *const C, const int Astride, const int Bstride, const int Cstride)
{
   const double *a0,*b0;
   double *c0;
   const double *ap0_0,*ap0_1;
   const double *bp0;
   double *cp0;
   const int A_sbs_stride = Astride*2;
   const int C_sbs_stride = Cstride*2;
   const int k_marg_el = K & 1;
   const int k_norm = K - k_marg_el;
   const int m_marg_el = M & 1;
   const int m_norm = M - m_marg_el;
   const int n_marg_el = N & 1;
   const int n_norm = N - n_marg_el;
   double *const c0_endp = C+m_norm*Cstride;
   register double c00,c01,c10,c11;
   for (c0=C,a0=A; c0!= c0_endp; c0+=C_sbs_stride,a0+=A_sbs_stride) {
      const double* const ap0_endp = a0 + k_norm;
      double* const cp0_endp = c0 + n_norm;
      for (b0=B,cp0=c0; cp0!=cp0_endp; b0+=2,cp0+=2) {
         ap0_0 = a0;
         ap0_1 = ap0_0 + Astride;
         bp0=b0;
         LOAD2x2(c00,c01,c10,c11,cp0,Cstride);
         for (; ap0_0!=ap0_endp; ap0_0+=2,ap0_1+=2) {
            mul_md2x2md2x2_md2x2(c00,c01,c10,c11,ap0_0,ap0_1,bp0,Bstride);
         }
         if (k_marg_el & 0x1) {
            mul_md2x1md1x2_md2x2(c00,c01,c10,c11,ap0_0,ap0_1,bp0,Bstride);
         }
         STORE2x2(c00,c01,c10,c11,cp0,Cstride);
      }
   }
   for (c0=C,a0=A; c0!= c0_endp; c0+=C_sbs_stride,a0+=A_sbs_stride) {
      const double* const ap0_endp = a0 + k_norm;
      b0 = B+n_norm;
      cp0 = c0+n_norm;
      if (n_marg_el & 0x1) {
         ap0_0 = a0;
         ap0_1 = ap0_0 + Astride;
         bp0=b0;
         LOAD2x1(c00,c10,cp0,Cstride);
         for (; ap0_0!=ap0_endp; ap0_0+=2,ap0_1+=2) {
            mul_md2x2md2x1_md2x1(c00,c10,ap0_0,ap0_1,bp0,Bstride);
         }
         if (k_marg_el & 0x1) {
            mul_md2x1md1x1_md2x1(c00,c10,ap0_0,ap0_1,bp0,Bstride);
         }
         STORE2x1(c00,c10,cp0,Cstride);
      }
   }
   if (m_marg_el & 0x1) {
      const double* const ap0_endp = a0 + k_norm;
      double* const cp0_endp = c0 + n_norm;
      for (b0=B,cp0=c0; cp0!=cp0_endp; b0+=2,cp0+=2) {
         ap0_0 = a0;
         bp0=b0;
         LOAD1x2(c00,c01,cp0,Cstride);
         for (; ap0_0!=ap0_endp; ap0_0+=2) {
            mul_md1x2md2x2_md1x2(c00,c01,ap0_0,bp0,Bstride);
         }
         if (k_marg_el & 0x1) {
            mul_md1x1md1x2_md1x2(c00,c01,ap0_0,bp0,Bstride);
         }
         STORE1x2(c00,c01,cp0,Cstride);
      }
      if (n_marg_el & 0x1) {
         ap0_0 = a0;
         bp0=b0;
         LOAD1x1(c00,cp0,Cstride);
         for (; ap0_0!=ap0_endp; ap0_0+=2) {
            mul_md1x2md2x1_md1x1(c00,ap0_0,bp0,Bstride);
         }
         if (k_marg_el & 0x1) {
            mul_md1x1md1x1_md1x1(c00,ap0_0,bp0,Bstride);
         }
         STORE1x1(c00,cp0,Cstride);
      }
   }
}

/* Fixed M,K,N = 8,8,8 L0-blocked matrix matrix multiply. */
static void
mul_mdmd_md_l1(const double *const A, const double *const B, double *const C, const int Astride, const int Bstride, const int Cstride)
{
   const double *a0,*b0;
   double *c0;
   const double *ap0_0,*ap0_1;
   const double *bp0;
   double *cp0;
   const int A_sbs_stride = Astride*2;
   const int C_sbs_stride = Cstride*2;
   double *const c0_endp = C+8*Cstride;
   register double c00,c01,c10,c11;
   for (c0=C,a0=A; c0!= c0_endp; c0+=C_sbs_stride,a0+=A_sbs_stride) {
      const double* const ap0_endp = a0 + 8;
      double* const cp0_endp = c0 + 8;
      for (b0=B,cp0=c0; cp0!=cp0_endp; b0+=2,cp0+=2) {
         ap0_0 = a0;
         ap0_1 = ap0_0 + Astride;
         bp0=b0;
         LOAD2x2(c00,c01,c10,c11,cp0,Cstride);
         for (; ap0_0!=ap0_endp; ap0_0+=2,ap0_1+=2) {
            mul_md2x2md2x2_md2x2(c00,c01,c10,c11,ap0_0,ap0_1,bp0,Bstride);
         }
         STORE2x2(c00,c01,c10,c11,cp0,Cstride);
      }
   }
}

void
mul_mdmd_md(const int M, const int K, const int N, const double *const A, const double *const B, double *const C, const int Astride, const int Bstride, const int Cstride)
{
   /* Code for L1-blocked routine. */
   int m2,k2,n2;
   const double *a2,*b2;
   double *c2;
   const double *ap2,*bp2;
   double *cp2;
   {
      double *cprb,*cpre,*cp,*cpe;
      cpre = C + M*Cstride;
      for (cprb = C; cprb != cpre; cprb += Cstride) {
         cpe = cprb + N;
         for (cp = cprb; cp != cpe; cp++) {
            *cp = 0.0;
         }
      }
   }
   if (M < 9 && K < 9 && N < 9) {
      mul_mdmd_md_l1_arb_all(M,K,N,A,B,C,Astride,Bstride,Cstride);
      return;
   }
   for (m2=0; m2<=M-8; m2+=8) {
      c2 = C + m2*Cstride;
      a2 = A + m2*Astride;
      for (n2=0,b2=B,cp2=c2; n2<=N-8; n2+=8,b2+=8,cp2+=8) {
         for (k2=0,bp2=b2,ap2=a2; k2<=K-8; k2+=8,bp2+=8*Bstride,ap2+=8) {
            mul_mdmd_md_l1(ap2,bp2,cp2,Astride,Bstride,Cstride);
         }
         if (k2 < K) {
            mul_mdmd_md_l1_arb_k(K-k2,ap2,bp2,cp2,Astride,Bstride,Cstride);
         }
      }
      if (n2 < N) {
         for (k2=0,bp2=b2,ap2=a2; k2<=K-8; k2+=8,bp2+=8*Bstride,ap2+=8) {
            mul_mdmd_md_l1_arb_all(8,8,N-n2,ap2,bp2,cp2,Astride,Bstride,Cstride);
         }
         if (k2 < K) {
            mul_mdmd_md_l1_arb_all(8,K-k2,N-n2,ap2,bp2,cp2,Astride,Bstride,Cstride);
         }
      }
   }
   if (m2 < M) {
      c2 = C + m2*Cstride;
      a2 = A + m2*Astride;
      for (n2=0,b2=B,cp2=c2; n2<=N-8; n2+=8,b2+=8,cp2+=8) {
         for (k2=0,bp2=b2,ap2=a2; k2<=K-8; k2+=8,bp2+=8*Bstride,ap2+=8) {
            mul_mdmd_md_l1_arb_all(M-m2,8,8,ap2,bp2,cp2,Astride,Bstride,Cstride);
         }
         if (k2 < K) {
            mul_mdmd_md_l1_arb_all(M-m2,K-k2,8,ap2,bp2,cp2,Astride,Bstride,Cstride);
         }
      }
      if (n2 < N) {
         for (k2=0,bp2=b2,ap2=a2; k2<=K-8; k2+=8,bp2+=8*Bstride,ap2+=8) {
            mul_mdmd_md_l1_arb_all(M-m2,8,N-n2,ap2,bp2,cp2,Astride,Bstride,Cstride);
         }
         if (k2 < K) {
            mul_mdmd_md_l1_arb_all(M-m2,K-k2,N-n2,ap2,bp2,cp2,Astride,Bstride,Cstride);
         }
      }
   }
}
