/*********************************************************************

This software module was originally developed by

Eric D. Scheirer (MIT Media Laboratory)

in the course of development of the MPEG-2 NBC/MPEG-4 Audio standard
ISO/IEC 13818-7, 14496-1,2 and 3. This software module is an
implementation of a part of one or more MPEG-2 NBC/MPEG-4 Audio tools
as specified by the MPEG-2 NBC/MPEG-4 Audio standard.  ISO/IEC gives
users of the MPEG-2 NBC/MPEG-4 Audio standards free license to this
software module or modifications thereof for use in hardware or
software products claiming conformance to the MPEG-2 NBC/ MPEG-4 Audio
standards. Those intending to use this software module in hardware or
software products are advised that this use may infringe existing
patents. The original developer of this software module and his/her
company, the subsequent editors and their companies, and ISO/IEC have
no liability for use of this software module or modifications thereof
in an implementation.

This software module is hereby released into the public domain.

***********************************************************************/

%token IDENT INTGR NUMBER STRCONST AOPCODE ELSE EXPORTS EXTEND GLOBAL
%token IF IMPORTS INCHANNELS 
%token INPUTMOD INSTR IOPCODE IVAR TABLE KOPCODE KRATE KSIG ASIG MAP
%token OPCODE OUTBUS OUTCHANNELS OUTPUT ROUTE SEND SEQUENCE
%token SRATE TEMPLATE TURNOFF WHILE WITH XSIG AND OR GEQ LEQ
%token NEQ EQEQ MINUS STAR
%token SLASH PLUS GT LT Q COL LP RP LC RC LB RB SEM COM EQ RETURN NOT
%token ARRAYREF OPCALL IMPEXP VARDECL NOTAG SPECIALOP
%{
#include <unistd.h>
#include "saol.h"
#define YYDEBUG 1
extern sa_decoder *cur_sa;
%}

%start orcfile
%left AND OR
%nonassoc LT GT LEQ GEQ EQEQ NEQ
%left PLUS MINUS
%left STAR SLASH
%right UNOT
%right UMINUS
%token HIGHEST

%%

orcfile           : proclist 
		  | error { parse_error("Error in orcfile"); } 
                  ;
proclist          : proclist instrdecl {
		      if (!cur_sa->all->il)
			 cur_sa->all->il = new_instr_list();
		      add_instr_list(cur_sa->all->il,ptr_index($2));
		      printf("Read instr %s.\n",((instr_decl *)ptr_index($2))->name);
		      }
		  | proclist opcodedecl {
		      if (!cur_sa->all->op)
		        cur_sa->all->op = new_opcode_list();
		      add_opcode_list(cur_sa->all->op,ptr_index($2));
		      printf("Read opcode %s.\n",((opcode_decl *)ptr_index($2))->name);
		      }
		  | proclist globaldecl {
		      printf("Read global block.\n");
		      }
		  | proclist templatedecl {
		      deal_with_template(cur_sa,ptr_index($2));
		      }
		  |
		  | error { parse_error("Error in proclist."); } 
		  ;
instrdecl	  : INSTR IDENT LP identlist RP LC vardecls block RC {
		      instr_decl *i;

		      i = new_instr_decl(ptr_index($2),ptr_index($4),
		                         ptr_index($7),ptr_index($8));
		      $$ = add_ptr_index(i);
		      }
		  | error { parse_error("Error in instr."); } 
		  ;
opcodedecl	  : optype IDENT LP paramlist RP LC opvardecls block RC {
		      opcode_decl *o;

		      o = new_opcode_decl(ptr_index($2),ptr_index($4),
		                          ptr_index($7),ptr_index($8),
					  $1);
		      $$ = add_ptr_index(o);
		      }
		  | error { parse_error("Error in opcode."); }
		  ;
globaldecl	  : GLOBAL LC globalblock RC {
		      if (!cur_sa->all->g) 
		         cur_sa->all->g = new_orc_global();
		      else
		         warn_line("Using multiple global blocks.",yyline);
		      sort_global_decls(cur_sa,cur_sa->all->g,ptr_index($3));
		      }
		  | error { parse_error("Error in global block."); } 
		  ;
templatedecl	  : TEMPLATE LT identlist GT LP identlist RP
		     MAP LC identlist RC
		     WITH LC mapblock RC LC
		     vardecls block RC {
		       template_decl *t;

		       t = new_template_decl(ptr_index($3),ptr_index($6),
		                             ptr_index($10),ptr_index($14),
					     ptr_index($17),ptr_index($18));
		       $$ = add_ptr_index(t);
		       }
		    
		  | error { parse_error("Error in template."); }
		  ;
mapblock	  : mapblock COM LT terminal_list GT {
		       add_mapblock(ptr_index($1),ptr_index($4));
		       $$ = $1;
		       }
		  | LT terminal_list GT {
		       mapblock *map;

		       map = new_mapblock(ptr_index($2));
		       $$ = add_ptr_index(map);
		       }
		  | { parse_error("Empty map block not allowed."); }
		  | error { parse_error("Bad map block."); }
		  ;
terminal_list	  : terminal_list COM terminal {
		     add_terminal_list(ptr_index($1),ptr_index($3));
		     $$ = $1;
		     }
		  | terminal {
		     terminal_list *tl;
		     tl = new_terminal_list(ptr_index($1));
		     $$ = add_ptr_index(tl);
		     }
		  | error { parse_error("Bad values for mapping."); }
		  ;
terminal	  : IDENT {
		     terminal *t;
		     t = new_terminal(IDENT,ptr_index($1));
		     $$ = add_ptr_index(t);
		     }
		  | const {
		     terminal *t;
		     t = new_terminal(NUMBER,ptr_index($1));
		     $$ = add_ptr_index(t);
		     }
		  | STRCONST {
		     terminal *t;
		     t = new_terminal(STRCONST, ptr_index($1));
		     $$ = add_ptr_index(t);
		     }
		  ;
globalblock	  : globalblock globaldef {
		     add_gblock(ptr_index($1),ptr_index($2));
		     }
		  | /* null */ {
		     global_block *gb;
		     
		     gb = new_gblock();
		     $$ = add_ptr_index(gb);
		     }
		  | error { parse_error("Bad global block."); }
		  ;
globaldef	  : rtparam { $$ = $1; }
		  | vardecl {
		      global_decl *g;
		      g = new_global(VARDECL);
		      set_global_vardecl(g,ptr_index($1));
		      $$ = add_ptr_index(g);
		      }
		  | routedef { $$ = $1; }
		  | senddef { $$ = $1; }
		  | inputmoddef { $$ = $1; }
		  | seqdef { $$ = $1; }
		  | error { parse_error("Bad global declaration"); }
		  ;
rtparam		  : SRATE INTGR SEM {
		     global_decl *g;

		     g = new_global(SRATE);
		     set_global_rtparam(g,atoi(ptr_index($2)));
		     $$ = add_ptr_index(g);
		     }
		  | KRATE INTGR SEM {
		     global_decl *g;

		     g = new_global(KRATE);
		     set_global_rtparam(g,atoi(ptr_index($2)));
		     $$ = add_ptr_index(g);
		     }
		  | INCHANNELS INTGR SEM {
		     global_decl *g;

		     g = new_global(INCHANNELS);
		     set_global_rtparam(g,atoi(ptr_index($2)));
		     $$ = add_ptr_index(g);
		     }
		  | OUTCHANNELS INTGR SEM {
		     global_decl *g;

		     g = new_global(OUTCHANNELS);
		     set_global_rtparam(g,atoi(ptr_index($2)));
		     $$ = add_ptr_index(g);
		     }
		  | error { parse_error("Bad real-time parameter."); }
		  ;
routedef	  : ROUTE LP IDENT COM identlist RP SEM {
                     global_decl *g;
		     routedef *r;

		     r = new_routedef(ptr_index($3),ptr_index($5));
		     g = new_global(ROUTE);
		     set_global_routedef(g,r);
		     $$ = add_ptr_index(g);
		     }
senddef		  : SEND LP IDENT SEM exprlist SEM identlist RP SEM {
		     global_decl *g;
		     senddef *s;

		     s = new_senddef(ptr_index($3),ptr_index($5),
		                     ptr_index($7));
		     g = new_global(SEND);
		     set_global_senddef(g,s);
		     $$ = add_ptr_index(g);
		     }
		  | error { parse_error("Bad send definition."); }
		  ;
inputmoddef	  : INPUTMOD LP IDENT SEM exprlist RP SEM {
		     global_decl *g;
		     inputmod *inmod;

		     inmod = new_inmod(ptr_index($3),ptr_index($5));
		     g = new_global(INPUTMOD);
		     set_global_inputmod(g,inmod);
		     $$ = add_ptr_index(g);
		     }
		  | error { parse_error("Bad input modifier."); }
		  ;
seqdef		  : SEQUENCE LP identlist RP SEM {
		     global_decl *g;
		     seqdef *s;
		     
		     s = new_seqdef(ptr_index($3));
		     g = new_global(SEQUENCE);
		     set_global_seqdef(g,s);
		     $$ = add_ptr_index(g);
		     }
		  | error { parse_error("Bad sequence."); }
		  ;
block		  : block statement {
		      add_block(ptr_index($1),ptr_index($2));
		      $$ = $1;
		      }
		  | /* null */ {
		      block *b;
		      long i;

		      b = new_block();
		      i = add_ptr_index(b);
		      $$ = i;
		      }
		  | error { parse_error("; exprected"); }
		  ;
statement	  : lvalue EQ expr SEM {
		      statement *st;
		      long i;
		    
 		      st = new_statement(EQ,ptr_index($3),NULL);
		      set_statement_lvalue(st,ptr_index($1));
		      i = add_ptr_index(st);
		      $$ = i;
		      }
		  | IF LP expr RP LC block RC {
		      statement *st;
		      long i;

		      st = new_statement(IF,ptr_index($3),ptr_index($6));
		      i = add_ptr_index(st);
		      $$ = i;
		      }
		  | IF LP expr RP LC block RC ELSE LC block RC {
		      statement *st;
		      long i;

		      st = new_statement(ELSE,ptr_index($3),ptr_index($6));
		      set_statement_else(st,ptr_index($10));
		      i = add_ptr_index(st);
		      $$ = i;
		      }
		  
		  | WHILE LP expr RP LC block RC {
		      statement *st;
		      long i;

		      st = new_statement(WHILE,ptr_index($3),ptr_index($6));
		      i = add_ptr_index(st);
		      $$ = i;
		      }
		  | INSTR IDENT LP exprlist RP SEM {
		      statement *st;
		      
		      st = new_statement(INSTR,NULL,NULL);
		      set_statement_iname(st,ptr_index($2));
		      set_statement_params(st,ptr_index($4));
		      $$ = add_ptr_index(st);
		      }
		  | OUTPUT LP exprlist RP SEM {
		      statement *st;
		      long i;

		      st = new_statement(OUTPUT,NULL,NULL);
		      set_statement_params(st,ptr_index($3));
		      i = add_ptr_index(st);
		      $$ = i;
		      }
  		     
		  | OUTBUS LP IDENT COM exprlist RP SEM {
		      statement *st;
		      long i;

      		      st = new_statement(OUTBUS,NULL,NULL);
		      set_statement_bus(st,ptr_index($3));
		      set_statement_params(st,ptr_index($5));
		      i = add_ptr_index(st);
		      $$ = i;
		      }
		  | EXTEND LP expr RP SEM {
		      statement *st;
		      st = new_statement(EXTEND,ptr_index($3),NULL);
		      $$ = add_ptr_index(st);
		      }
		  | TURNOFF SEM {
		      statement *st;
		      st = new_statement(TURNOFF,NULL,NULL);
		      $$ = add_ptr_index(st);
		      }
  		     
		  | RETURN LP expr RP SEM { 
		      statement *st;
		      long i;

		      st = new_statement(RETURN,ptr_index($3),NULL);
		      i = add_ptr_index(st);
		      $$ = i;
		      }
		      
		  | error { parse_error("Bad statement."); }
		  ;
lvalue		  : IDENT {
		      terminal *t;
		      expr *p;

		      t = new_terminal(IDENT,ptr_index($1));
		      p = new_expr(NULL,NULL,NULL,IDENT);
		      set_expr_data(p,t);
		      $$ = add_ptr_index(p);
		      }
		  | IDENT LB expr RB {
		      terminal *t;
		      expr *p;

		      t = new_terminal(IDENT,ptr_index($1));
		      p = new_expr(ptr_index($3),NULL,NULL,ARRAYREF);
		      set_expr_data(p,t);
		      $$ = add_ptr_index(p);
		      }
		  | error { parse_error("Bad lvalue in exprression"); }
		  ;
identlist	  : identlist COM IDENT {
		      name *v;
		      v = new_name(ptr_index($3),1);
		      add_namelist(ptr_index($1),v);
		      $$ = $1;
		      }
		  | IDENT {
		      name *v;
		      namelist *nl;

		      v = new_name(ptr_index($1),1);
		      nl = new_namelist(v);
		      $$ = add_ptr_index(nl);
		      }
		  | /* null */ {
		      namelist *nl;

		      nl = new_namelist(NULL);
		      $$ = add_ptr_index(nl);
		      }
		  | error { parse_error("Bad identifier list."); }
		  ;
paramlist	  : paramlist COM paramdecl {
		      add_formalparam_list(ptr_index($1),ptr_index($3));
		      $$ = $1;
		      }
		  | paramdecl {
		      formalparam_list *fpl;

		      fpl = new_formalparam_list();
		      add_formalparam_list(fpl,ptr_index($1));
		      $$ = add_ptr_index(fpl);
		      }
		  |   /* null */ {
		      formalparam_list *fpl;

		      fpl = new_formalparam_list();
		      $$ = add_ptr_index(fpl);
		      }
		  | error { parse_error("Bad parameter list."); }
		  ;
vardecls	  : vardecls vardecl {
		     add_vardecl_list(ptr_index($1),ptr_index($2));
		     $$ = $1;
		     }
		  | /* null */ {
		     vardecl_list *vdl;

		     vdl = new_vardecl_list();
		     $$ = add_ptr_index(vdl);
		     }
		  | error { parse_error("Bad declaration list."); }
		  ;
vardecl		  : taglist stype namelist SEM { 
		     vardecl *v;

		     v = new_vardecl($2,$1,ptr_index($3));
		     $$ = add_ptr_index(v);
		     } 
		  | tabledecl SEM {
		     vardecl *v;
		     v = new_vardecl(TABLE,NOTAG,NULL);
		     set_vardecl_tabledef(v,ptr_index($1));
		     $$ = add_ptr_index(v);
		     }
		  | error { parse_error("Bad declaration."); }
		  ;
opvardecls	  : opvardecls opvardecl {
		     add_vardecl_list(ptr_index($1),ptr_index($2));
		     $$ = $1;
		     }
		  | /* null */ {
		     vardecl_list *vdl;

		     vdl = new_vardecl_list();
		     $$ = add_ptr_index(vdl);
		     }
		  | error { parse_error("Bad declaration list."); }
		  ;
opvardecl	  : taglist otype namelist SEM {
                     vardecl *v;

		     v = new_vardecl($2,$1,ptr_index($3));
		     $$ = add_ptr_index(v);
		     }
		  | error { parse_error("Bad declaration."); }
		  ;
paramdecl	  : otype name {
		     formalparam *fp;

		     fp = new_formalparam($1,ptr_index($2));
		     $$ = add_ptr_index(fp);
		     }
		  | error { parse_error("Bad parameter."); }
		  ;
namelist	  : namelist COM name {
		      add_namelist(ptr_index($1),ptr_index($3));
		      $$ = $1;
		      }
		  | name {
		      namelist *v;
		      v = new_namelist(ptr_index($1));
		      $$ = add_ptr_index(v);
		      }
		  | error { parse_error("Bad variable list."); }
		  ;
name		  : IDENT {
		      name *v;
		      v = new_name(ptr_index($1),1);
		      $$ = add_ptr_index(v);
		      }
		  | IDENT LB INTGR RB {
					/* add expressions here */
		      name *v;
		      v = new_name(ptr_index($1),atoi(ptr_index($3)));
		      $$ = add_ptr_index(v);
		      }
		  | error { parse_error("Bad variable declaration."); }
		  ;
stype		  : IVAR { $$ = IVAR; }
		  | KSIG { $$ = KSIG; }
		  | ASIG { $$ = ASIG; }
		  | TABLE { $$ = TABLE; }
		  | error { parse_error("Unexprected type."); }
		  ;
otype		  : XSIG { $$ = XSIG; }
		  | stype { $$ = $1; }
		  | error { parse_error("Unexprected opcode type."); }
		  ;
tabledecl	  : TABLE IDENT LP IDENT COM exprstrlist RP {
		      tabledef *t;

		      t = new_tabledef(ptr_index($2),ptr_index($4),
		                        ptr_index($6));
		      $$ = add_ptr_index(t);
		      }
		  | error { parse_error("Table placeholder must be global."); }
		  ;
taglist		  : IMPORTS { $$ = IMPORTS; } 
		  | EXPORTS { $$ = EXPORTS; } 
		  | IMPORTS EXPORTS { $$ = IMPEXP; }
		  | EXPORTS IMPORTS { $$ = IMPEXP; }
		  | {$$ = NOTAG; }
		  | error { parse_error("Unknown tag."); }
		  ;
optype		  : AOPCODE { $$ = AOPCODE; } 
		  | KOPCODE { $$ = KOPCODE; } 
		  | IOPCODE { $$ = IOPCODE; } 
		  | OPCODE { $$ = OPCODE; } 
		  | error { parse_error("Invalid opcode type."); }
		  ;
expr		  : IDENT {
		      expr *p;
		      terminal *t;
		      long i;

		      p = new_expr(NULL,NULL,NULL,IDENT);
		      t = new_terminal(IDENT,ptr_index($1));
		      set_expr_data(p,t);
		      i = add_ptr_index(p);
		      $$ = i;
		      }
		        
		  | const {
		      long i;
		      expr *p;
		      terminal *t;

		      p = new_expr(NULL,NULL,NULL,NUMBER);
		      t = new_terminal(NUMBER,ptr_index($1));
		      set_expr_data(p,t);

		      i = add_ptr_index(p);
		      $$ = i;
		      }
		      		  
		  | IDENT LB expr RB { /* array reference */
		      long i;
		      expr *p;
		      terminal *t;

		      t = new_terminal(IDENT,ptr_index($1));
		      p = new_expr(ptr_index($3),NULL,NULL,ARRAYREF);
		      set_expr_data(p,t);

		      i = add_ptr_index(p);
		      $$ = i;
		      }
		      
		  | IDENT LP exprlist RP { /* opcode call */
		      long i;
		      expr *p;
		      terminal *t;

		      t = new_terminal(IDENT,ptr_index($1));
		      p = new_expr(NULL,NULL,NULL,OPCALL);
		      set_expr_params(p,ptr_index($3));
		      set_expr_data(p,t);

		      i = add_ptr_index(p);
		      $$ = i;
		      }
		      
		  | expr Q expr COL expr { /* a ? b : c */
		      long i;
		      expr *p;

		      p = new_expr(ptr_index($1),ptr_index($3),ptr_index($5),Q);
		      i = add_ptr_index(p);
		      $$ = i;
		      }
		      
		  | expr LEQ expr {
		      long i;
		      expr *p;

		      p = new_expr(ptr_index($1),ptr_index($3),NULL,LEQ);
		      i = add_ptr_index(p);
		      $$ = i;
		      }
		      
		  | expr GEQ expr {
		      long i;
		      expr *p;

		      p = new_expr(ptr_index($1),ptr_index($3),NULL,GEQ);
		      i = add_ptr_index(p);
		      $$ = i;
		      }
		      

		  | expr NEQ expr {
		      long i;
		      expr *p;

		      p = new_expr(ptr_index($1),ptr_index($3),NULL,NEQ);
		      i = add_ptr_index(p);
		      $$ = i;
		      }

		  | expr EQEQ expr {
		      long i;
		      expr *p;

		      p = new_expr(ptr_index($1),ptr_index($3),NULL,EQEQ);
		      i = add_ptr_index(p);
		      $$ = i;
		      }

		  | expr GT expr {
		      long i;
		      expr *p;

		      p = new_expr(ptr_index($1),ptr_index($3),NULL,GT);
		      i = add_ptr_index(p);
		      $$ = i;
		      }

		  | expr LT expr {
		      long i;
		      expr *p;

		      p = new_expr(ptr_index($1),ptr_index($3),NULL,LT);
		      i = add_ptr_index(p);
		      $$ = i;
		      }

		  | expr AND expr    {
		      long i;
		      expr *p;

		      p = new_expr(ptr_index($1),ptr_index($3),NULL,AND);
		      i = add_ptr_index(p);
		      $$ = i;
		      }

		  | expr OR expr {
		      long i;
		      expr *p;

		      p = new_expr(ptr_index($1),ptr_index($3),NULL,OR);
		      i = add_ptr_index(p);
		      $$ = i;
		      }

		  | expr PLUS expr {
		      long i;
		      expr *p;

		      p = new_expr(ptr_index($1),ptr_index($3),NULL,PLUS);
		      i = add_ptr_index(p);
		      $$ = i;
		      }

		  | expr MINUS expr {
		      long i;
		      expr *p;

		      p = new_expr(ptr_index($1),ptr_index($3),NULL,MINUS);
		      i = add_ptr_index(p);
		      $$ = i;
		      }

		  | expr STAR expr {
		      long i;
		      expr *p;

		      p = new_expr(ptr_index($1),ptr_index($3),NULL,STAR);
		      i = add_ptr_index(p);
		      $$ = i;
		      }

		  | expr SLASH expr {
		      long i;
		      expr *p;

		      p = new_expr(ptr_index($1),ptr_index($3),NULL,SLASH);
		      i = add_ptr_index(p);
		      $$ = i;
		      }
		  | NOT expr     %prec UNOT    {
		      expr *p;

		      p = new_expr(ptr_index($2),NULL,NULL,NOT);
		      $$ = add_ptr_index(p);
		      }

		  | MINUS expr  {
		      long i;
		      expr *p;

		      p = new_expr(ptr_index($2),NULL,NULL,UMINUS);
		      i = add_ptr_index(p);
		      $$ = i;
		      }

		  | LP expr RP {
		     long i;
		     expr *p;
		     p = new_expr(ptr_index($2),NULL,NULL,LP);
		     i = add_ptr_index(p);
		     $$ = i;
		     }
		  | error { parse_error("Bad exprression."); }
		  ;
exprlist		  : exprlist COM expr {
		      add_exprlist(ptr_index($1),ptr_index($3));
		      $$ = $1;
		      }
		  | expr {
		      exprlist *e;
		      long i;
		      e = new_exprlist(ptr_index($1));
		      i = add_ptr_index(e);
		      $$ = i;
		      }
		  | /* null */ {
		      exprlist *e;
		      long i;
		      e = new_exprlist(NULL);
		      i = add_ptr_index(e);
		      $$ = i;
		      }
		  | error { parse_error("Bad parameter list."); }
		  ;
exprstrlist	  : exprstrlist COM expr {
		     add_exprlist(ptr_index($1),ptr_index($3));
		     $$ = $1;
		     }
		  | exprstrlist COM STRCONST {
		     terminal *t;
		     expr *p;
		     t = new_terminal(STRCONST,ptr_index($3));
		     p = new_expr(NULL,NULL,NULL,STRCONST);
		     set_expr_data(p,t);
		     add_ptr_index(p);
		     add_exprlist(ptr_index($1),p);
		     $$ = $1;
		     }
		  | STRCONST {
		     exprlist *e;
		     terminal *t;
		     expr *p;
		     long i;
		     t = new_terminal(STRCONST,ptr_index($1));
		     p = new_expr(NULL,NULL,NULL,STRCONST);
		     set_expr_data(p,t);
		     add_ptr_index(p);
		     e = new_exprlist(p);
		     i = add_ptr_index(e);
		     $$ = i;
		     }		    
		  | expr {
		     exprlist *e;
		     long i;
		     e = new_exprlist(ptr_index($1));
		     i = add_ptr_index(e);
		     $$ = i;
		     }
		  | error { parse_error("Bad table initializer."); }
		  ;		 
const   	  : INTGR { $$ = $1; }
		  | NUMBER { $$ = $1; }
		  | error { parse_error("Bad numeric constant."); }
		  ;
%%

#include "lex.yy.c"

void parse_error(char *status) {
  int i;
  char c;
  
  printf("Line %d: %s\n", yyline,status);
  printf("%s\n",thisline);
  for (i=0;i<yycol-strlen(yytext)-1 && i < 100;i++) printf(" ");
  printf("^\n");
  cur_sa->synerror = 1;
  }

void parse_error_line(char *status,int line) {
  int i;
  char c;
  
  printf("Line %d: %s\n", line,status);
  printf("   %s\n\n",all_lines[line-1]);
  cur_sa->synerror = 1;
  }

void warn_line(char *status,int line) {
  int i;
  char c;
 
  if (line) { 
    printf("Warning: Line %d: %s\n", line,status);
    printf("   %s\n\n",all_lines[line-1]);
    }
  else printf("Warning: %s\n",status);
  }

  

void yyerror(char *foo) {}
