/*********************************************************************

This software module was originally developed by

Eric D. Scheirer (MIT Media Laboratory)

in the course of development of the MPEG-2 NBC/MPEG-4 Audio standard
ISO/IEC 13818-7, 14496-1,2 and 3. This software module is an
implementation of a part of one or more MPEG-2 NBC/MPEG-4 Audio tools
as specified by the MPEG-2 NBC/MPEG-4 Audio standard.  ISO/IEC gives
users of the MPEG-2 NBC/MPEG-4 Audio standards free license to this
software module or modifications thereof for use in hardware or
software products claiming conformance to the MPEG-2 NBC/ MPEG-4 Audio
standards. Those intending to use this software module in hardware or
software products are advised that this use may infringe existing
patents. The original developer of this software module and his/her
company, the subsequent editors and their companies, and ISO/IEC have
no liability for use of this software module or modifications thereof
in an implementation.

This software module is hereby released into the public domain.

***********************************************************************/

#include "saol_interp.h"
#include "fft.h"

struct core_opcode_struct *is_core_opcode(char *name);
double eval_core_opcode(context *cx, expr *p, long rate);

typedef struct core_opcode_struct {
  char *name;
  long oprate;  /* rate of the opcode */
  long p1type, p2type, p3type, p4type, p5type, p6type;
  /* rates of the arguments */
  long varargs; /* rate of the terminal vararg sequence */
  long storage; /* local storage needed for each instance of the opcode */
  double (*code)(context *cx, long rate, int p_ct);
    /* function pointer to the code needed */
} core_opcode;

#define PROT_MAL_CO(op_storage) \
if (!(cx->cop_storage = (void *)malloc(sizeof(op_storage)))) \
  interror("Couldn't allocate space in co_opcode");

void add_sym_table_core_opcodes(sa_decoder *sa,symtable *t);
int opcode_is_varargs(char *name);
table_storage *co_param_table(context *cx, int which);
double co_param(context *cx, int which);

typedef struct int_storage_struct { int shold; } int_storage;
double co_int(context *cx, long rate, int p_ct); 
typedef struct frac_storage_struct { int shold; } frac_storage;
double co_frac(context *cx, long rate, int p_ct); 
typedef struct dbamp_storage_struct { int shold; } dbamp_storage;
double co_dbamp(context *cx, long rate, int p_ct); 
typedef struct ampdb_storage_struct { int shold; } ampdb_storage;
double co_ampdb(context *cx, long rate, int p_ct); 
typedef struct abs_storage_struct { int shold; } abs_storage;
double co_abs(context *cx, long rate, int p_ct); 
typedef struct exp_storage_struct { int shold; } exp_storage;
double co_exp(context *cx, long rate, int p_ct); 
typedef struct log_storage_struct { int shold; } log_storage;
double co_log(context *cx, long rate, int p_ct); 
typedef struct sqrt_storage_struct { int shold; } sqrt_storage;
double co_sqrt(context *cx, long rate, int p_ct); 
typedef struct sin_storage_struct { int shold; } sin_storage;
double co_sin(context *cx, long rate, int p_ct); 
typedef struct cos_storage_struct { int shold; } cos_storage;
double co_cos(context *cx, long rate, int p_ct); 
typedef struct atan_storage_struct { int shold; } atan_storage;
double co_atan(context *cx, long rate, int p_ct); 
typedef struct octpch_storage_struct { int shold; } octpch_storage;
double co_octpch(context *cx, long rate, int p_ct); 
typedef struct pchoct_storage_struct { int shold; } pchoct_storage;
double co_pchoct(context *cx, long rate, int p_ct); 
typedef struct cpspch_storage_struct { int shold; } cpspch_storage;
double co_cpspch(context *cx, long rate, int p_ct); 
typedef struct pchcps_storage_struct { int shold; } pchcps_storage;
double co_pchcps(context *cx, long rate, int p_ct); 
typedef struct cpsoct_storage_struct { int shold; } cpsoct_storage;
double co_cpsoct(context *cx, long rate, int p_ct); 
typedef struct octcps_storage_struct { int shold; } octcps_storage;
double co_octcps(context *cx, long rate, int p_ct); 
typedef struct pchmidi_storage_struct { int shold; } pchmidi_storage;
double co_pchmidi(context *cx, long rate, int p_ct); 
typedef struct midipch_storage_struct { int shold; } midipch_storage;
double co_midipch(context *cx, long rate, int p_ct); 
typedef struct octmidi_storage_struct { int shold; } octmidi_storage;
double co_octmidi(context *cx, long rate, int p_ct); 
typedef struct midioct_storage_struct { int shold; } midioct_storage;
double co_midioct(context *cx, long rate, int p_ct); 
typedef struct cpsmidi_storage_struct { int shold; } cpsmidi_storage;
double co_cpsmidi(context *cx, long rate, int p_ct); 
typedef struct midicps_storage_struct { int shold; } midicps_storage;
double co_midicps(context *cx, long rate, int p_ct); 
typedef struct ftlen_storage_struct { int shold; } ftlen_storage;
double co_ftlen(context *cx, long rate, int p_ct); 
typedef struct ftloop_storage_struct { int shold; } ftloop_storage;
double co_ftloop(context *cx, long rate, int p_ct); 
typedef struct ftloopend_storage_struct { int shold; } ftloopend_storage;
double co_ftloopend(context *cx, long rate, int p_ct); 
typedef struct ftsr_storage_struct { int shold; } ftsr_storage;
double co_ftsr(context *cx, long rate, int p_ct);
double co_ftbasecps(context *cx, long rate, int p_ct); 
typedef struct tableread_storage_struct { int shold; } tableread_storage;
double co_tableread(context *cx, long rate, int p_ct); 
typedef struct tablewrite_storage_struct { int shold; } tablewrite_storage;
double co_tablewrite(context *cx, long rate, int p_ct);

typedef struct oscil_storage_struct {
  double ph;
  int loops;
} oscil_storage;

double co_oscil(context *cx, long rate, int p_ct);

typedef struct loscil_storage_struct {
  double idx;
} loscil_storage;

double co_loscil(context *cx, long rate, int p_ct);

typedef struct doscil_storage_struct {
  double idx;
} doscil_storage;

double co_doscil(context *cx, long rate, int p_ct);

typedef struct kline_storage_struct {
  double left,right,dur,durtime;
  int done,varargs_pos;
} kline_storage;
double co_kline(context *cx, long rate, int p_ct); 

typedef struct aline_storage_struct {
  double left,right,dur,durtime;
  int done,varargs_pos;
} aline_storage;
double co_aline(context *cx, long rate, int p_ct);

typedef struct kexpon_storage_struct {
  double left,right,dur,durtime;
  int done,varargs_pos;
 } kexpon_storage;
double co_kexpon(context *cx, long rate, int p_ct); 
typedef struct aexpon_storage_struct {
  double left,right,dur,durtime;
  int done,varargs_pos;
} aexpon_storage;

double co_aexpon(context *cx, long rate, int p_ct); 
typedef struct kphasor_storage_struct { double ph; } kphasor_storage;
double co_kphasor(context *cx, long rate, int p_ct); 
typedef struct aphasor_storage_struct { double ph; } aphasor_storage;
double co_aphasor(context *cx, long rate, int p_ct); 
typedef struct pluck_storage_struct { int shold; } pluck_storage;
double co_pluck(context *cx, long rate, int p_ct);

typedef struct buzz_storage_struct {
  double ph;
} buzz_storage;
double co_buzz(context *cx, long rate, int p_ct);

typedef struct fof_storage_struct { int shold; } fof_storage;
double co_fof(context *cx, long rate, int p_ct); 
typedef struct irand_storage_struct { int shold; } irand_storage;
double co_irand(context *cx, long rate, int p_ct); 
typedef struct krand_storage_struct { int shold; } krand_storage;
double co_krand(context *cx, long rate, int p_ct); 
typedef struct arand_storage_struct { int shold; } arand_storage;
double co_arand(context *cx, long rate, int p_ct); 
typedef struct ilinrand_storage_struct { int shold; } ilinrand_storage;
double co_ilinrand(context *cx, long rate, int p_ct); 
typedef struct klinrand_storage_struct { int shold; } klinrand_storage;
double co_klinrand(context *cx, long rate, int p_ct); 
typedef struct alinrand_storage_struct { int shold; } alinrand_storage;
double co_alinrand(context *cx, long rate, int p_ct); 
typedef struct iexprand_storage_struct { int shold; } iexprand_storage;
double co_iexprand(context *cx, long rate, int p_ct); 
typedef struct kexprand_storage_struct { int shold; } kexprand_storage;
double co_kexprand(context *cx, long rate, int p_ct); 
typedef struct aexprand_storage_struct { int shold; } aexprand_storage;
double co_aexprand(context *cx, long rate, int p_ct); 

typedef struct kpoissonrand_storage_struct {
  int wait;
} kpoissonrand_storage;

double co_kpoissonrand(context *cx, long rate, int p_ct);

typedef struct apoissonrand_storage_struct {
  int wait;
} apoissonrand_storage;

double co_apoissonrand(context *cx, long rate, int p_ct);

typedef struct igaussrand_storage_struct { int shold; } igaussrand_storage;
double co_igaussrand(context *cx, long rate, int p_ct); 
typedef struct kgaussrand_storage_struct { int shold; } kgaussrand_storage;
double co_kgaussrand(context *cx, long rate, int p_ct); 
typedef struct agaussrand_storage_struct { int shold; } agaussrand_storage;
double co_agaussrand(context *cx, long rate, int p_ct); 
typedef struct port_storage_struct { int shold; } port_storage;
double co_port(context *cx, long rate, int p_ct); 

typedef struct hipass_storage_struct {
  real oldcut, a1,a2,a0,b1,b2,b0,d1,d2;
} hipass_storage;

double co_hipass(context *cx, long rate, int p_ct); 

typedef struct lopass_storage_struct {
  real oldcut, a1,a2,a0,b1,b2,b0,d1,d2;
} lopass_storage;

double co_lopass(context *cx, long rate, int p_ct);

typedef struct bandpass_storage_struct {
  real oldcf, oldbw, a1, a2, a0, b1, b2, b0, d1, d2;
} bandpass_storage;

double co_bandpass(context *cx, long rate, int p_ct);

typedef struct bandstop_storage_struct {
  real oldcf, oldbw, a1, a2, a0, b1, b2, b0, d1, d2;
} bandstop_storage;

double co_bandstop(context *cx, long rate, int p_ct);

typedef struct fft_storage_struct {
  complex *basis;
  real *buf,*inbuf;
  int pt,framept,framect;
  int p2,ready;
} fft_storage;

double co_fft(context *cx, long rate, int p_ct);

typedef struct ifft_storage_struct {
  complex *basis;
  real *buf;
  int pt,ct,p2;
} ifft_storage;
double co_ifft(context *cx, long rate, int p_ct);

typedef struct rms_storage_struct { 
	double *buf;
	double last;
	int pt;
} rms_storage;
double co_rms(context *cx, long rate, int p_ct); 

typedef struct gain_storage_struct {
	double *buf;
	double rms;
	int pt;
} gain_storage;

double co_gain(context *cx, long rate, int p_ct); 

typedef struct balance_storage_struct {
	double *inbuf, *refbuf;
	double inrms, refrms;
	int pt;
 } balance_storage;

double co_balance(context *cx, long rate, int p_ct); 

typedef struct decimate_storage_struct { double last; } decimate_storage;
double co_decimate(context *cx, long rate, int p_ct); 

typedef struct upsamp_storage_struct { 
	double last;
	int ct;
} upsamp_storage;
double co_upsamp(context *cx, long rate, int p_ct); 

typedef struct downsamp_storage_struct { 
	double *buf;
	int pt;
 } downsamp_storage;
double co_downsamp(context *cx, long rate, int p_ct); 

typedef struct samphold_storage_struct {
	double hold;
	double gate;
 } samphold_storage;
double co_samphold(context *cx, long rate, int p_ct);

typedef struct delay_storage_struct {
  double *dline;
  int pt;
} delay_storage;

double co_delay(context *cx, long rate, int p_ct);

typedef struct delay1_storage_struct { double last; } delay1_storage;

double co_delay1(context *cx, long rate, int p_ct);

typedef struct biquad_storage_struct { 
	double d1,d2;
} biquad_storage;

double co_biquad(context *cx, long rate, int p_ct);

typedef struct fdelay_storage_struct {
  double *dline;
  int pt;
} fdelay_storage;

double co_fdelay(context *cx, long rate, int p_ct); 

typedef struct comb_storage_struct {
  double *dline;
  int pt;
} comb_storage;

double co_comb(context *cx, long rate, int p_ct);

typedef struct allpass_storage_struct {
  double *dline;
  int pt;
} allpass_storage;

double co_allpass(context *cx, long rate, int p_ct);
