/*********************************************************************

This software module was originally developed by

Eric D. Scheirer (MIT Media Laboratory)

in the course of development of the MPEG-2 NBC/MPEG-4 Audio standard
ISO/IEC 13818-7, 14496-1,2 and 3. This software module is an
implementation of a part of one or more MPEG-2 NBC/MPEG-4 Audio tools
as specified by the MPEG-2 NBC/MPEG-4 Audio standard.  ISO/IEC gives
users of the MPEG-2 NBC/MPEG-4 Audio standards free license to this
software module or modifications thereof for use in hardware or
software products claiming conformance to the MPEG-2 NBC/ MPEG-4 Audio
standards. Those intending to use this software module in hardware or
software products are advised that this use may infringe existing
patents. The original developer of this software module and his/her
company, the subsequent editors and their companies, and ISO/IEC have
no liability for use of this software module or modifications thereof
in an implementation.

This software module is hereby released into the public domain.

***********************************************************************/

#ifndef _SAOL_INTERP_H

#define _SAOL_INTERP_H

#include "saol.h"

typedef struct {
  double *d;
  char *name;
  long size;
  int srate;
  long loop, loopend;
  double base;
} table_storage;

typedef double asig_frame;

typedef struct {
  double val;
  table_storage *table;
  asig_frame *asig;
} frameval;

typedef struct child_cx_list_struct {
  expr *ref;
  struct context_struct *cx;
  struct child_cx_list_struct *next;
} child_cx_list;


typedef struct actparam_list_struct {
  double val;
  expr *ref; /* for call by reference */
  struct actparam_list_struct *next;
  int rate; /* the rate of the incoming exprression */
} actparam_list;

typedef struct context_struct {
  frameval **framevals;     /* the values and/or pointers for this frame */
  int *frameref;            /* for each frameval, is it a call-by-reference? */
  long xsigrate;            /* the rate of xsigs in this context */
  symtable *localvars;      /* the local symbol table */
  actparam_list *varargs;   /* any extra var-args arguments */
  struct instr_handle_struct *instr;      /* the instance handle for this context */
  child_cx_list *ccx;       /* list of child contexts */
  void *cop_storage;        /* extra storage for a core opcode */
  void *cop_dyn;            /* a pointer to any dynamic core opcode stuff */
  int asample_ptr;
  int init;
  int inchan;
	sa_decoder *sa;    /* the decoder this context is a part of */
} context;


void runtime(char *s);
double eval_block(context *cx,block *b, long rate);
double eval_expr(context *cx, expr *p, long rate);
double eval_opcode(context *cx, expr *p, actparam_list *val, long rate);
double eval_core_opcode(context *cx, expr *p, long rate);

void push_context(context *cx, context *enc_cx,
			   actparam_list *val, long rate);
void pop_context(context *cx, context *enc_cx,
			    actparam_list *val, long rate);

context *new_context(sa_decoder *sa,symtable *t,int inchan);
context *get_child_context(context *cx, expr *p); 
context *new_child_context(context *cx, expr *p,actparam_list *pval); 
frameval *new_frameval(double val, table_storage *table, asig_frame *asig); 
frameval *get_frameval(context *cx, expr *p, int index); 
void set_frameval(context *cx, expr *p, int index, frameval *val); 

table_storage *make_table(context *cx, tabledef *td);
actparam_list *make_varargs_list(actparam_list *p, context *cx);
asig_frame *make_asig_frame(int ksmps);
void set_var_value(context *cx, expr *p, int index, double val);
void set_var_value_byname(context *cx, char *vname, int index, double val);
double get_var_value(context *cx, expr *p, int index); 

actparam_list *add_actparam_list(actparam_list *pl, double val,
				 expr *ref, long rate); 
void free_actparam_list(actparam_list *pl); 

table_storage *gen_table(char *gen,actparam_list *pf);

struct instr_handle_struct 
    *new_instr_instance(sa_decoder *sa,
		char *iname, actparam_list *pl,
		int inchan);
void add_default_host_vars(struct instr_handle_struct *h);
void add_imported_host_vars(struct instr_handle_struct *h);
void run_itime(instr_decl *id, context *cx, actparam_list *pf);
void run_katime(instr_decl *id, context *cx, long rate);
void set_asample_ptr(context *cx, int i); 

extern int ksmps;

#endif
