PROJ = SHORTEN
!IFNDEF DEBUG
DEBUG = OFF
!ENDIF
!IFNDEF SYSTEM
SYSTEM          = DOS4G
!ENDIF
LABEL = LINES

# optimized path searching
.OPTIMIZE

ASM             = ML
AFLAGS_G        = /nologo /c /Cp /W3 /Zp4
AFLAGS_OFF      = $(AFLAGS_G)
AFLAGS_ON       = $(AFLAGS_OFF) /Zi
AFLAGS_CHECK    = /Zs /W3 /Zp4

!IFEQ SYSTEM DOS
CC              = wcc
CFLAGS_G        = /ml /5 /j /wx /ze /zm /zp4 /fpi87
!ELSE
CC              = wcc386
CFLAGS_G        = /mf /5r /j /wx /ze /zm /zp4 /fpi87
!ENDIF
CFLAGS_OFF      = $(CFLAGS_G) /oneatx
CFLAGS_ON       = $(CFLAGS_G) /Od /d1+
CFLAGS_CHECK    = $(CFLAGS_G) /zs /j /w4 /zp4

DEFS            = -DHAVE_STDARG_H -DWATCOM_$(SYSTEM) -DMSDOS
#need to be modifed to look like the original file

SRC             = .\
OBJ             = .\
PMODEW_DIR      = .\

.C:     $(SRC)
.OBJ:   $(OBJ)
.ASM:   $(SRC)

BOBJS = $(OBJ)MKBSHIFT.OBJ
COBJS = $(OBJ)EXIT.OBJ $(OBJ)ARRAY.OBJ $(OBJ)SULAWALA.OBJ
SOBJS = $(OBJ)MAIN.OBJ $(OBJ)SHORTEN.OBJ $(OBJ)FIXIO.OBJ $(OBJ)VARIO.OBJ $(OBJ)POLY.OBJ $(OBJ)LPC.OBJ $(OBJ)HSGETOPT.OBJ $(OBJ)DUPFINFO.OBJ $(OBJ)LICENSE.OBJ

.C.OBJ:
        $(CC) $(CFLAGS_$(DEBUG)) $(DEFS) /Fo$@ $[*.c
.ASM.OBJ:
        $(ASM) $(AFLAGS_$(DEBUG)) /Fo$@ $[*.asm

MOBJS = $(BOBJS) $(COBJS)
OBJS = $(COBJS) $(SOBJS)

$(SRC)SHORTEN.EXE : $(SRC)MKBSHIFT.EXE $(SRC)BITSHIFT.H $(OBJS) $(SRC)SHORTEN.LNK
        WLINK @$(SRC)SHORTEN.LNK

$(SRC)SHORTEN.LNK : $(SRC)MAKEFILE.WAT
        ECHO NAME $^& >$^@
        ECHO DEBUG $(LABEL) >>$^@
!IFEQ SYSTEM PMODEW
        @ECHO SYSTEM BEGIN PMODEW >>$^@
        @ECHO OPTION OSNAME='PMODE/W' >>$^@
        @ECHO OP STUB=$(PMODEW_DIR)PMODEW.EXE >>$^@
        @ECHO FORMAT OS2 LE >>$^@
        @ECHO END >>$^@
!ENDIF
        @ECHO SYSTEM $(SYSTEM) >>$^@
        ECHO OPTION CACHE OPTION ELIMINATE OPTION CASEEXACT SORT ALPHABETICAL >>$^@
        ECHO OPTION STACK=8192 >>$^@
        ECHO OPTION MAP=$(OBJ)SHORTEN.MAP >>$^@
        ECHO OPTION SYMFILE=$(SRC)SHORTEN >>$^@
        FOR %I IN ($(OBJS)) DO ECHO FILE %I >>$^@

$(SRC)MKBSHIFT.EXE : $(MOBJS) $(SRC)MKBSHIFT.LNK
        WLINK @$(SRC)MKBSHIFT.LNK

$(SRC)MKBSHIFT.LNK : $(SRC)MAKEFILE.WAT
        ECHO NAME $^& >$^@
        ECHO DEBUG $(LABEL) >>$^@
!IFEQ SYSTEM PMODEW
        @ECHO SYSTEM BEGIN PMODEW >>$^@
        @ECHO OPTION OSNAME='PMODE/W' >>$^@
        @ECHO OP STUB=$(PMODEW_DIR)PMODEW.EXE >>$^@
        @ECHO FORMAT OS2 LE >>$^@
        @ECHO END >>$^@
!ENDIF
        @ECHO SYSTEM $(SYSTEM) >>$^@
        ECHO OPTION CACHE OPTION ELIMINATE OPTION CASEEXACT SORT ALPHABETICAL >>$^@
        ECHO OPTION STACK=8192 >>$^@
        ECHO OPTION MAP=$(OBJ)MKBSHIFT.MAP >>$^@
        ECHO OPTION SYMFILE=$(SRC)MKBSHIFT >>$^@
        FOR %I IN ($(MOBJS)) DO ECHO FILE %I >>$^@

$(OBJ)MKBSHIFT.OBJ : $(SRC)MKBSHIFT.C .AUTODEPEND

$(SRC)BITSHIFT.H : $(SRC)MKBSHIFT.EXE
        $(SRC)MKBSHIFT.EXE

$(OBJ)MAIN.OBJ : $(SRC)MAIN.C .AUTODEPEND

$(OBJ)SHORTEN.OBJ : $(SRC)SHORTEN.C .AUTODEPEND

$(OBJ)FIXIO.OBJ : $(SRC)FIXIO.C .AUTODEPEND

$(OBJ)VARIO.OBJ : $(SRC)VARIO.C .AUTODEPEND

$(OBJ)LPC.OBJ : $(SRC)LPC.C .AUTODEPEND

$(OBJ)POLY.OBJ : $(SRC)POLY.C .AUTODEPEND

$(OBJ)HSGETOPT.OBJ : $(SRC)HSGETOPT.C .AUTODEPEND

$(OBJ)DUPFINFO.OBJ : $(SRC)DUPFINFO.C .AUTODEPEND

$(OBJ)EXIT.OBJ : $(SRC)EXIT.C .AUTODEPEND

$(OBJ)ARRAY.OBJ : $(SRC)ARRAY.C .AUTODEPEND

$(OBJ)SULAWALA.OBJ : $(SRC)SULAWALA.C .AUTODEPEND

$(OBJ)LICENSE.OBJ : $(SRC)LICENSE.C .AUTODEPEND

clean : .SYMBOLIC
        del *.err /Y
        del $(BOBJS) /Y
        del $(COBJS) /Y
        del $(SOBJS) /Y
        del $(SRC)BITSHIFT.H $(SRC)SHORTEN.LNK $(SRC)MKBSHIFT.LNK /Y
        del $(OBJ)SHORTEN.MAP $(SRC)SHORTEN.SYM $(OBJ)MKBSHIFT.MAP $(SRC)MKBSHIFT.SYM /Y

cleanglobber : .SYMBOLIC clean
        del $(OBJ)SHORTEN.MAP $(SRC)SHORTEN.SYM $(OBJ)MKBSHIFT.MAP $(SRC)MKBSHIFT.SYM /Y
        del $(SRC)SHORTEN.EXE $(SRC)MKBSHIFT.EXE /Y

install : .SYMBOLIC
        copy shorten.exe \bin
        copy shorten.man \bin
