#define CURSOR_IN_VIEW 0
#define CURSOR_ON_LEFT 1
#define CURSOR_ON_RIGHT 2
#define CURSOR_IN_MIDDLE 3
#define CURSOR_UPDATE_DISPLAY 4
#define CURSOR_NO_ACTION 5
#define CURSOR_CLAIM_SELECTION 6
#define KEYBOARD_NO_ACTION 7

#define MAX_NUM_PEAKS 100
#define REGIONS 16

typedef struct {int op; void *op0; void *op1; float fval; int type;} sop;

typedef struct {
  int s_type;
  int size;
  int *fragments;
} ed_list;

typedef struct {
  int s_type;             /* run-time pointer type checks */
  char *name;             /* full name */
  int samples;            /* total samples = chans * samples/chan */
  int data_location;      /* bytes */
  int srate;
  int chans;
  int format;             /* data format (snd_16_linear etc) */
  int type;               /* header type (AIFF etc) */
  int distributed;        /* is header scattered around (1) or in one place (0) */
  int comment_start;      /* comment location (bytes) */
  int comment_end;
  int depth;              /* directory depth from top dir */
} file_info;

typedef struct {
  int s_type;
  int type;
  int *data;    
  int *io;      
  char *filename;
  file_info *hdr;
  int temporary;
} snd_data;

typedef struct {
  int s_type;
  ed_list *current_state;
  int *cb;
  int cbi;
  int eof;
  int *first;
  int *last;
  int *data;
  snd_data **sounds;
  int current_value;
  int beg,end;
  int direction;
  void *cp;
} snd_fd;

extern snd_fd *snd_search_fd;
extern int snd_IO_error;

typedef struct {float freq; float amp;} fft_peak;

typedef struct {
  int s_type;
  float y0,y1;                         /* scroller-dependent axis bounds */
  double x0,x1;
  float xmin,xmax,ymin,ymax;           /* data-dependent absolute limits */
  float y_scale;
  double x_scale;
  char *xlabel,*ylabel;
  int y_label_x,y_label_y,x_label_x,x_label_y;
  int y_axis_x0,x_axis_x0,
      y_axis_y0,x_axis_y0,
      x_axis_x1,
      y_axis_y1;
  int graph_active;
  int losamp,hisamp;                   /* displayed x-axis bounds in terms of sound sample numbers */
  int graph_x0;                        /* x axis offset relative to window (for double graphs) */
  void *x_ticks,*y_ticks;
  axis_context *ax;
  int width,height;
  void *ss;                            /* back pointers for debugging and whatnot */
  void *cp;
  float sx,sy,zx,zy;                   /* as set by user, 0.0 - 1.0 */
  int y_offset,window_width;
} axis_info;

typedef struct {
  int samp;
  char *name;
  int visible;
} mark;

typedef struct {
  float *data;
  int pts;
} env;

typedef struct {
  unsigned int s_type;
  int size;
  int current_size;
  int window;              /* fft window in this case, not a display window */
  int ok;
  float beta;
  axis_info *axis;
  float *data;
  void *chan;
} fft_info;

typedef struct {
  int s_type;
  int n;
  void *r;
  void *dp;
  void *ss;
  void *rg;
} region_info;

typedef struct {
  int total_slices;        /* size of the data array (max for allocation checks) */
  int total_bins;          /* size other axis data array */
  int active_slices;       /* how many slices contain current data */
  int target_bins;         /* this many bins Y-side */
  int target_slices;       /* how many slices in full display (current) */
  float **data;            /* data[total_slices][bins] -> each is a spectral magnitude */
  int *begs;               /* associated begin times (for data reuse) */
  void *cp;                /* the usual backpointer */
  float scale;
} sono_info;

typedef struct {
  unsigned int s_type;     /* CHAN_INFO */
  int chan;                /* which chan are we */
  int *samples;            /* current length */
  int ffting;              /* f button state */
  int waving;              /* w button state */
  int ufuning;             /* external function display state */
  void *ui;
  int cursor_on;           /* channel's cursor */
  int cursor_visible;      /* for XOR decisions */
  int border_visible;
  int cursor;              /* sample */
  int cx,cy;               /* graph-relative cursor loc (for XOR) */
  int edit_ctr;            /* channel's edit history */
  int edit_size;           /* current edit list size */
  ed_list **edits;         /* the edit list */
  int sound_size;          /* edit_list associated temp sound buffers */
  int sound_ctr;           /* current location in sounds list */
  snd_data **sounds;       /* the associated temp buffer/file/struct list */
  fft_info *fft;           /* possibly null fft data */
  void *sound;             /* snd_info backpointer */
  void *state;             /* snd_state backpointer */
  axis_info *axis,*active_axis;
  mark ***marks;           /* current marks, indexed by edit_ctr, then mark_number, then the mark pointer */
  int marks_size;
  int *mark_size;
  int *mark_ctr;
  chan_context *cgx;       /* graphics/window context */
  chan_context *tcgx;      /* when combining chans, all should use chan[0]'s context */
  void *amp_env;
  void *original_env;
  void *sonogram_data;
  void *last_sonogram;
  void *fft_data;          /* parallels sonogram -- try to avoid repeating large ffts needlessly */
  int clear;
  int ps_fd;
  int printing;
  int drawing;
  float gsy,gzy;
  void *mixes;
  int mix_size;
} chan_info;

typedef struct {
  unsigned int s_type;
  int inuse;
  int index;
  void *playing;
  mark *playing_mark;
  int syncing;
  int expanding;
  int contrasting;
  int reverbing;
  int filtering;
  int recording,replaying,applying;
  float amp;
  float srate;                  /* playback srate, not original */
  float expand,exp_seglen,exp_ramp,exp_hop;
  float contrast;
  float revlen,revscl,revfb,revlp;
  int filter_order;
  env *filter_env;
  int filter_is_envelope;
  int play_direction;
  int selected_channel;
  char *fullname;
  char *shortname;
  int nchans;
  sop *search_tree;
  char *search_expr;
  int searching,marking,evaling,filing,finding_mark,amping,reging,printing,loading,ufuning,macroing;
  sop *eval_tree;
  char *eval_expr;
  float *ufun_args;
  int ufun_nargs;
  void *ufunp;
  int auto_ufun;
  int minibuffer_on;
  int sx_scroll_max;
  int info_active;
  int read_only;
  chan_info **chans;
  void *state;                /* state backpointer */
  snd_context *sgx;
  file_info *hdr;             /* header of file that would be affected if we were to save current edits */
  void *actions;
  void *initial_controls;
  int env_anew;
  int apply_ok;
  float contrast_amp;
  int write_date;             /* check for change behind back while editing */
  char **debug_names;
  float *debug_amps;
  int combining;              /* 0:separate panes per chan, 1:all chans in one pane */
  int allocated_chans;        /* snd_info widget tree is never pruned -- can only grow */
} snd_info;

typedef struct {
  unsigned int s_type;        /* SND_STATE */
  int selected_sound;         /* NO_SELECTION = none selected = which sound is currently receiving user's attention */
  int active_sounds;
  int global_fft_size;
  int global_fft_window;
  int subsampling;
  int dBing;
  int logxing;
  int fft_style;
  int marks_visible;
  int zero_visible;
  int cursor_talks;
  int graph_style;
  int peaking;
  int viewing;
  int ctrls_height,channel_min_height; /* for user-customized start up decisions */
  int from_clm, to_clm;
  snd_info **sounds;
  sop *search_tree;
  char *search_expr;
  sop *eval_tree;
  char *eval_expr;
  int using_schemes;
  state_context *sgx;
  int editor_line_size;
  int place_scroll_size;
  void *help_monolog;
  char *init_file;
  char *backup_file;
  char *eps_file;
  int max_sounds;
  float color_scale;
  int color_inverted;
  float sonogram_cutoff;
  char *temp_dir;
  int play_start_time;
  float reverb_decay;
  int default_output_type;
  snd_info *mx_sp;
  int remember_state;
  char *pending_open;
  char *pending_change;
  char *pending_new;
  int auto_open;
  int fit_data;
  int global_combining;
  int consoling;
  int dot_size;
  int zoom_focus_anchor;
  int spectro_hop,wavo_hop,wavo,spectrogram_color,sonogram_color,wavo_trace;
  float spectro_xscl,spectro_yscl,spectro_zscl,spectro_zangle,spectro_xangle,spectro_yangle,color_cutoff;
  int ask_before_overwrite;
  char *session_name;
  /* there are 3 state/customization/initialization files --
   * init_file = .snd on home directory and contains customizations used all the time
   *             the options menu save-options choice appends to this file.
   * backup_file = .snd-backup on current directory and contains enough to restart current run in case of crash
   *               the backup file is deleted upon normal exit except when remember-state is non-zero.
   * session_name = <name>.snd-session and contains all state needed to restart later in same state
   *                several sessions can exist, this is independent of exit state and so on.
   * the init_file is loaded first, followed by either the session file (if it is specified) or the backup file (if it exists)
   */
} snd_state;

typedef struct {
  char **files;
  char *name;
  int len;
  int size;
} dir;

typedef struct {int srate; int channels; int slice; snd_state *ss;} dac_manager;

typedef struct {
  int chans;
  int *begs;
  chan_info **cps;
} sync_info;

typedef struct {
  int len;
  int *save;
  char **name;
} region_state;

char *get_graph_help(void);
char *get_file_menu_help(void);
char *get_edit_menu_help(void);
char *get_selected_menu_help(void);
char *get_view_menu_help(void);
char *get_options_menu_help(void);
char *get_help_menu_help(void);
char *get_about_snd_help(void);
char *get_fft_menu_help(void);
char *get_fft_keypad_help(void);
char *get_find_menu_help(void);
char *get_undo_menu_help(void);
char *get_sync_menu_help(void);
char *get_speed_menu_help(void);
char *get_expand_menu_help(void);
char *get_reverb_menu_help(void);
char *get_contrast_menu_help(void);
char *get_env_menu_help(void);
char *get_format_menu_help(void);
char *get_info_help(void);
char *get_play_help(void);
char *get_mark_help(void);
char *get_mixing_help(void);
char *get_init_file_help(void);
char *get_resource_help(void);
char *get_region_browser_help(void);
char *get_ufun_help(void);
char *get_expression_help(void);

sop *sop_parse(char *expr);
void free_sop(sop *tree);
float sop_eval(sop *tree);
char *sop_parse_error_name(void);
void sop_add_id(char *name);
void sop_add_snd_id(char *name, int type);
float search_dot(int off);
float search_dot_assign(int off,float val);
int snd_built_in_locals(void);
void save_parser_state (snd_state *ss, int fd);
void save_ufun_state(snd_state *ss, int fd);

int output_type_and_format_ok(int type, int format);
char *sound_type(int type);
char *copy_string (char *str);
void snd_error (char *msg);
char *filename_without_home_directory(char *name);
#ifndef sqr
  float sqr(float a);
#endif
float cube (float a);
char *prettyf(float num, int tens);

char *complete_filename(char *tok);

int snd_pointer_type(void *w);
void snd_pointer_error (char *msg, int good, void *w);
unsigned int make_snd_pointer_type (int type);


int find_and_sort_fft_peaks(float *buf, fft_peak *found, int num_peaks, int fftsize, int srate, float samps_per_pixel);
int find_and_sort_peaks(float *buf, fft_peak *found, int num_peaks, int size);
int fft_window_needs_beta (int window);
void fft_set_current_window_beta(float beta, int window);
float fft_window_beta(int window);
float fft_window_beta_max(int window);
int fftwincpy(char *s1, int type);
Boolean fft_in_slices(void *fftData);
Boolean sonogram_in_slices(void *sono);
fft_info *free_fft_info(fft_info *fp);
void *make_fft_state(chan_info *cp, int simple);
int default_fft_window(snd_state *ss);
void free_sono_info (chan_info *cp);
void make_sonogram_axes(chan_info *cp);
void *make_sonogram_state(chan_info *cp);
void set_sonogram_cutoff(snd_state *ss,float val);
float set_global_fft_size(snd_state *ss,float val);
void display_fft_peaks(chan_info *cp);

axis_info *free_axis_info(axis_info *ap);
short grf_x(double val, axis_info *ap);
short grf_y(float val, axis_info *ap);
void make_axes_1(chan_info *cp,axis_info *ap);
double ungrf_x(axis_info *ap, int x);
axis_info *make_axis_info (chan_info *cp, float xmin, float xmax, float ymin, float ymax, 
			   char *xlabel, float x0, float x1, float y0, float y1,
			   axis_info *old_ap);
void set_y_limits(chan_info *cp, axis_info *ap, float val);
void set_xy_bounds(chan_info *cp,axis_info *ap);
void set_x_bounds(axis_info *ap);

mark *add_mark(int samp, char *name, chan_info *cp);
void free_mark_list(chan_info *cp, int ignore);
void collapse_marks (snd_info *sp);
void delete_mark(int samp, chan_info *cp);
void draw_mark(chan_info *cp, axis_info *ap, mark *mp);
mark *hit_mark(chan_info *cp, int x, int y);
void move_mark(chan_info *cp, mark *mp, int x, int y);
void finish_moving_mark(chan_info *cp, mark *mp);
mark *hit_triangle(chan_info *cp, int x, int y);
void ripple_marks(chan_info *cp, int beg, int change);
void marks_off(chan_info *cp);
void release_pending_marks(chan_info *cp, int edit_ctr);
int goto_mark(chan_info *cp,int count);
int goto_named_mark(chan_info *cp, char *name);
int add_named_mark(chan_info *cp);
void move_mark_2(chan_info *cp);
mark *find_named_mark(chan_info *cp, char *name);
int move_play_mark(chan_info *cp, int *mc, int cx);
void finish_moving_play_mark(chan_info *cp);
void save_marks(snd_info *sp);
void clm_add_marks(snd_info *sp);

char *snd_error_name(int i);
snd_info *snd_open_file (char *filename, snd_state *ss);
void snd_close_file(snd_info *sp,snd_state *ss);
int disk_kspace (int fd);
int file_write_date(char *filename);
int snd_ok (snd_info *sp);
void snd_new_file(snd_state *ss);
int snd_checked_write(snd_state *ss, int fd, unsigned char *buf, int bytes);
int copy_file(char *oldname, char *newname, snd_info *sp);
int snd_translate(snd_state *ss, char *oldname, char *newname);

enum {snd_no_error,snd_cannot_write_header,snd_cannot_open_temp_file,
      snd_cannot_allocate_io_buffers,snd_cannot_write_data,
      snd_cannot_remove_file,snd_cannot_rename_file,
      snd_cannot_read_header,snd_unsupported_file_type,
      snd_cannot_find_file,snd_unsupported_data_format,
      snd_pending_open};

file_info *make_file_info(char *fullname,snd_state *ss);
file_info *make_file_info_1(char *fullname, snd_state *ss);
file_info *free_file_info(file_info *hdr);
file_info *make_temp_header(char *fullname, file_info *old_hdr, int samples);
int *make_file_state(int fd, file_info *hdr, int direction, int chan);
int *free_file_state(int *datai);
dir *filter_sound_files(dir *dp, char *pattern);
dir *find_sound_files_in_dir (char *name);
dir *find_session_files_in_dir (char *name);
dir *free_dir (dir *dp);
int open_temp_file(char *ofile, int chans, file_info *hdr, snd_state *ss);
int close_temp_file(int ofd, file_info *hdr, long bytes, snd_info *sp);
void file_change_samples(int beg, int num, char *tempfile, chan_info *cp, int chan, int auto_delete);
void file_insert_samples(int beg, int num, char *tempfile, chan_info *cp, int chan, int auto_delete);
void file_mix_samples(int beg, int num, char *tempfile, chan_info *cp, int chan);
void file_override_samples(int num, char *tempfile, chan_info *cp, int chan, int auto_delete);
int *load_samples(int beg, int num, chan_info *cp);

void free_edit_list(chan_info *cp);
void free_sound_list (chan_info *cp);
int current_ed_samples(chan_info *cp);
void insert_samples(int beg, int num, int *vals, chan_info *cp);
void delete_samples(int beg, int num, chan_info *cp);
void change_samples(int beg, int num, int *vals, chan_info *cp);
void add_samples(int beg, int num, int *vals, chan_info *cp);
float sample (int samp, chan_info *cp);
snd_fd *free_snd_fd(snd_fd *sf);
snd_fd *copy_snd_fd(snd_fd *sf);
snd_fd *init_sample_read (int samp, chan_info *cp, int direction);
float any_sample(snd_fd *sf, int off);
int next_sound (snd_fd *sf);
int previous_sound (snd_fd *sf);
int next_sub_sound (snd_fd *sf, int inc);
float next_sample (snd_fd *sf);
float previous_sample (snd_fd *sf);
int read_sample_eof (snd_fd *sf);
snd_data *make_snd_data_file(char *name, int *io, int *data, file_info *hdr, int temp);
snd_data *make_snd_data_buffer(int *data, int len);
ed_list *initial_ed_list(int beg, int end);
int next_sample_1 (snd_fd *sf);
int previous_sample_1(snd_fd *sf);
void undo_EDIT(void *ptr,int count,int syncd);
void redo_EDIT(void *ptr,int count,int syncd);

#define NEXT_SAMPLE(val,sf)  {if (sf->data > sf->last) val=next_sound(sf); else val=(*sf->data++);}
#define NEXT_SUB_SAMPLE(val,sf,inc) {if ((int *)(sf->data+inc) > sf->last) val=next_sub_sound(sf,inc); else {val=(*sf->data); sf->data+=inc;}}
#define PREVIOUS_SAMPLE(val,sf)  {if (sf->data < sf->first) val=previous_sound(sf); else val=(*sf->data--);}

int save_edits_1(snd_info *sp, char *new_name);
int chan_save_edits(chan_info *cp, char *ofile);
int save_edits(snd_info *sp, void *ptr);
int revert_edits(chan_info *cp, void *ptr);
char *only_save_edits(snd_info *sp, int *err);

snd_info *make_snd_info(snd_info *sip, void *state, char *filename, file_info *hdr, int snd_slot);
snd_info *free_snd_info(snd_info *sp);
chan_info *make_chan_info(chan_info *cip, int chan, void *sound, void *state);
int map_over_sounds (snd_state *ss, int (*func)(), void *userptr);
int map_over_chans (snd_state *ss, int (*func)(), void *userptr);
int map_over_sound_chans (snd_info *sp, int (*func)(), void *userptr);
int map_over_separate_chans(snd_state *ss, int (*func)(), void *userptr);
char *snd_NAME(void *w);
int snd_SRATE (void *ptr);
int snd_TYPE (void *ptr);
int graph_low_SAMPLE (void *ptr);
int graph_high_SAMPLE (void *ptr);
int active_channels (snd_state *ss,int count_virtual_channels);
int find_free_sound_slot (snd_state *state);
snd_info *selected_sound(snd_state *ss);
int incf_active_sounds (snd_state *ss);
int decf_active_sounds (snd_state *ss);
snd_state *main_STATE(void *w);

void report_in_minibuffer(snd_info *sp, char *message);
void clear_minibuffer(snd_info *sp);
void reflect_file_revert_in_label (snd_info *sp);

snd_info *add_sound_window (char *filename, snd_state *state);
void add_sound_data(char *filename, snd_info *sp, snd_state *ss);
void add_channel_data(char *filename, chan_info *cp, file_info *hdr, snd_state *ss);
void add_channel_data_1(chan_info *cp, snd_info *sp, snd_state *ss, int graphed);
void reflect_sample_change_in_axis(chan_info *cp);

void check_for_first_edit(chan_info *cp);
void handle_cursor(chan_info *cp, int redisplay);
void normalize_all_sounds(snd_state *ss);
void select_channel(snd_info *sp, int chan);
void unselect_channel(void *ptr);
chan_info *selected_channel(void *ptr);
snd_info *any_selected_sound (snd_state *ss);
chan_info *any_selected_channel(snd_info *sp);
int syncd_chans(snd_state *ss);
chan_info *current_channel(void *ptr);
void select_sound (snd_state *ss, snd_info *sp);
int active_selection (chan_info *cp);
chan_info *virtual_selected_channel(chan_info *cp);


int feed_dac(dac_manager *tm);
int dac_is_running(void);
void close_dac (void);
void write_dac(short *buf, int samps, int cadr);
void start_playing(void *ptr, int start);
void stop_playing(void *dp);


void display_channel_data (chan_info *cp, snd_info *sp, snd_state *ss);
void display_channel_marks (chan_info *cp);
void draw_graph_cursor(chan_info *cp);
void show_cursor_info(chan_info *cp);
int update_graph(chan_info *cp, void *ptr);
void apply_x_axis_change(axis_info *ap, chan_info *cp, snd_info *sp);
void sy_changed(int value,chan_info *cp);
void sx_changed(int value,chan_info *cp);
void zy_changed(int value,chan_info *cp);
void zx_changed(int value,chan_info *cp);
void sx_incremented(chan_info *cp, float amount);
void resize_sx(chan_info *cp);
void resize_zx(chan_info *cp);
int move_axis(chan_info *cp, axis_info *ap, int x);
void set_axes(chan_info *cp,float x0,float x1,float y0,float y1);
void gzy_changed(int value,chan_info *cp);
void gsy_changed(int value,chan_info *cp);


int cursor_search(chan_info *cp, int count);
char *global_search(snd_state *ss);

void snd_info_activate(snd_info *sp, int keysym);
void snd_add_locals (snd_state *ss);
float get_snd_var(int var);
float set_snd_var(int var, float val);
void save_snd_options (snd_state *ss);
int open_snd_init_file (snd_state *ss);

int cursor_moveto (chan_info *cp,int samp);
int keyboard_command (chan_info *cp, int keysym, int state);

void load_macro(char *name, char *macdef, int start, int end);
void save_macros(snd_state *ss);
void save_macro(snd_state *ss,char *name);
int execute_macro(chan_info *cp, char *name, int count);
void save_macro_state (snd_state *ss, int fd);

void snd_load_init_file(snd_state *ss);
int get_clm_string(snd_state *ss, int fd);
void snd_load_file(snd_state *ss,char *filename);
void snd_exit_cleanly(snd_state *ss);
void save_snd_state (snd_state *ss);
void restore_state(snd_state *ss, char *file);
void remove_backup_file(snd_state *ss);

void snd_help(snd_state *ss, char *subject, char *help);
void ssnd_help(snd_state *ss, char *subject, ...);

int run_amp_env(snd_info *sp);
int amp_env_usable(chan_info *cp,float samples_per_pixel);
int amp_env_graph(chan_info *cp,float samples_per_pixel);
void clobber_amp_env(chan_info *cp);

env *copy_env(env *e);
env *free_env(env *e);

void init_regions(void);
int region_chans(int n);
snd_info *region_sound(int n);
int selection_is_ours(void);
int selection_len(void);
int selection_beg(chan_info *cp);
int *send_selection(snd_state *ss);
int *send_region(snd_state *ss, int n);
void receive_selection(int *data, int len);
void give_up_selection(void);
int save_selection(char *ofile);
void delete_selection(void);
void paste_region(int n, chan_info *cp);
void add_region(int n, chan_info *cp);
void display_selection(chan_info *cp);
void region_eval_expression(snd_info *sp, int n);
void play_region(snd_state *ss,int n, void *r);
void define_selection(chan_info *cp);
void create_selection(chan_info *cp);
void selection_off(chan_info *cp);
int selection_member(snd_info *sp);
void define_region(chan_info *cp, int beg, int end);
void mark_define_region(chan_info *cp,int count);
int region_len(int n);
int region_srate(int n);
float region_maxamp(int n);
snd_fd *init_region_read (snd_state *ss, int n, int chan);
void start_selection (chan_info *cp,int x);
void select_region(int n);
int delete_region(int n);
void free_region_state (region_state *r);
region_state *region_report(void);
void protect_region(int n,int protect);
void ripple_selection(chan_info *cp, int beg, int num);
void start_keyboard_selection(chan_info *cp, int x);
void finish_keyboard_selection(void);
void cancel_keyboard_selection(void);
void check_keyboard_selection(chan_info *cp, int x);
void cleanup_region_temp_files(void);
void deactivate_selection(void);
file_info *fixup_region_data(chan_info *cp, int chan, int n);
int save_region(int n, char *ofile);

env *scan_envelope(char *str);
void free_chan_env(chan_info *cp);
void free_sound_env(snd_info *sp, int in_progress);
env *load_envelope(char *file);


void free_sync_info (sync_info *si);
sync_info *region_sync(int n);
sync_info *snd_sync(snd_state *ss);
sync_info *make_simple_sync (chan_info *cp, int beg);


void ps_set_grf_points(double x, int j, float ymin, float ymax);
void ps_set_grf_point(double x, int j, float y);
void ps_allocate_grf_points(void);
void ps_draw_grf_points(snd_state *ss,chan_info *cp, axis_info *ap, int j);
void ps_draw_both_grf_points(snd_state *ss,chan_info *cp, axis_info *ap, int j);
void ps_draw_line (chan_info *cp, int x0,int y0,int x1,int y1);
void ps_fill_rectangle (chan_info *cp, int x0, int y0, int width, int height);
void ps_draw_string (chan_info *cp, int x0, int y0, char *str, int len);
void ps_set_number_font(chan_info *cp);
void ps_set_label_font(chan_info *cp);
void ps_set_bold_peak_numbers_font(chan_info *cp);
void ps_set_peak_numbers_font(chan_info *cp);
void ps_draw_sono_rectangle(chan_info *cp, axis_info *ap, int color, float x, float y, float width, float height);
void ps_reset_color(chan_info *cp);
int set_dot_size(snd_state *ss, int val);
void ps_draw_spectro_line(chan_info *cp, axis_info *ap, int color, float x0, float y0, float x1, float y1);

void snd_print(snd_state *ss, char *output, int syncing);
void region_print(char *output, char* title, chan_info *cp);

int invoke_ufun_with_ptr(chan_info *cp, void *ptr, float *args, int nargs, int count, int reg);
void *find_ufun(snd_info *sp, char *fun);
void receive_ufun_selection(int chans, int srate, float **data, int *lens);

typedef struct {
  int length;
  int type;
  float *data;
  axis_info *axis;
  int peaks_ok;
  float scaler;
} ufun_info;

ufun_info *free_ufun_info(chan_info *cp);
int snd_load_ufun(char *library, char *fun);
void receive_ufun_file(char *filename);

void record_amp_change(snd_info *sp,int scroll_val,float amp_val);
void record_speed_change(snd_info *sp,int scroll_val,float speed_val);
void record_expand_change(snd_info *sp,int scroll_val,float expand_val);
void record_reverb_change(snd_info *sp,int scroll_val,float reverb_val);
void record_contrast_change(snd_info *sp,int scroll_val,float contrast_val);
void record_direction_change(snd_info *sp,int scroll_val,float direction_val);

void start_record_and_replay(snd_state *ss, snd_info *sp);
void finish_record_and_replay(void);
void initialize_record(snd_info *sp);
void initialize_replay(snd_info *sp);
int apply_controls(void *sp);
void flush_actions(snd_info *sp);

void replay_amp(void *ap);
void replay_expand(void *ap);
void replay_contrast(void *ap);
void replay_reverb(void *ap);
void replay_speed(void *ap);
void replay_direction(void *ap1);

void save_control_state(snd_info *sp);
void restore_control_state(snd_info *sp);
void free_controls(snd_info *sp);

void initialize_apply(snd_info *sp, int ofd);
int run_apply(snd_info *sp, int ofd);
void finalize_apply(snd_info *sp, int ofd);
void stop_applying(snd_info *sp);
void *make_apply_state(void *xp);

void tickle_clm(snd_state *ss);
void initialize_scrollbars(chan_info *cp);
void clm_doit(snd_state *ss, char *buf, int start, int end);
int amp_env_maxamp_ok(chan_info *cp);
float amp_env_maxamp(chan_info *cp);
void apply_env(chan_info *cp, env *e, int beg, int dur, float scaler, int regexpr);

void display_info(snd_info *sp);
void set_new_header_type(int type);
int get_new_header_type(void);
char *sound_comment(file_info *hdr);
int file_maxamps(char *ifile, float *vals, int *changes);

void reset_spectro(snd_state *state);
int save_selection_1(char *ofile,int type, int format, int srate);
int save_edits_2(snd_info *sp, char *new_name, int type, int format, int srate);
snd_info *find_sound(snd_state *ss, char *name);
snd_info *make_sound_readable(snd_state *ss, char *filename);
void set_session_name (snd_state *ss, char *name);
void report_chan_marks(chan_info *cp, int fd);
void save_state (snd_state *ss, char *session_name);

#ifdef NEXT
char *tempnam(char *ignored, char *tmp);
#endif

void mix_file(snd_state *ss, char *str);
float get_maxamp(snd_state *ss, snd_info *sp, chan_info *cp);
void scale_by(snd_state *ss, snd_info *sp, chan_info *cp, float *scalers, int len, int selection);
void scale_to(snd_state *ss, snd_info *sp, chan_info *cp, float *scalers, int len, int selection);
