/* some of the longer help texts */

static char file_menu_help[] =
"  Open: open a file.\n\
  Close: close the currently selected file.\n\
  Save: save any edits on the current file.\n\
  Save as: save edits on the current file,\n\
      in some new file.\n\
  Revert: undo any edits on the current file.\n\
  New: create an empty sound edit window.\n\
  View: open a file in read-only mode.\n\
  Print: produce graph as Postscript file.\n\
  Exit: leave Snd, without saving any edits.\n\
";

char *get_file_menu_help(void) {return(file_menu_help);}


static char edit_menu_help[] =
"  Undo: undo the last edit in the current file.\n\
  Redo: redo the undone edit.\n\
  Find: a global search -- operates across all\n\
     currently sync'd sounds.\n\
  Cut: store, then delete the selection.\n\
  Paste: insert the selection at the current location\n\
  Mix: add the selection at the current location\n\
  Play: play the current selection.\n\
  Save as: save the current selection in a file.\n\
";

char *get_edit_menu_help(void) {return(edit_menu_help);}

static char view_menu_help[] =
"  Show Controls: display the control pane.\n\
  Normalize: During editing with multiple\n\
     files and channels, some data may be\n\
     obscured or compressed by changed window\n\
     sizes.  Normalize returns Snd to a state\n\
     where everything is equally compressed.\n\
  Info: describe current sound file format.\n\
  Combine channels: combine all channels into\n\
     one graph.\n\
  Dots: display data as dots; the other\n\
     option is the default Lines.\n\
  Show Marks: display mark locations using a\n\
     long vertical line.\n\
  Show Y=0: display the y=0 line.\n\
  Verbose cursor: show cursor loc and sample value.\n\
  Regions: fire up the region browser.\n\
  Color: color browser for sonogram.\n\
  Orientation: sonogram orientation.\n\
";

char *get_view_menu_help(void) {return(view_menu_help);}


static char options_menu_help[] = 
"  FFT Size: set the size of the fft (a power of 2).\n\
   Show Peaks: show fft peaks. The higher peaks are\n\
      in bold face.\n\
   FFT log freq: display the fft data using log x axis.\n\
   FFT in dB: display the fft data in dB.\n\
   FFT Style: display sonogram or single FFT.\n\
   FFT Window: set the fft window choice.\n\
   FFT Beta: if relevant to the fft window, set the\n\
      associated window parameter, sometimes called beta.\n\
   Zoom focus: where to focus during zooms.\n\
   Subsampling off: When large amounts of data are\n\
      being displayed, Snd may subsample the data to\n\
      speed up the display process.  This can introduce\n\
      artifacts of the sampling interval on rare occasions.\n\
   Save Options: save the current Options and View menu settings.\n\
\n\
";

char *get_options_menu_help(void) {return(options_menu_help);}

static char help_menu_help[] =   
"  Click for Help: if you choose this, the\n\
      mouse cursor becomes a '?'; position\n\
      the cursor over the portion of the Snd\n\
      window that interests you, and click\n\
      the button.\n\
  About Snd: this text.\n\
  FFT: a discussion of Snd's FFT options.\n\
  Find: how to perform searches.\n\
  Undo/Redo: how to back up while editing.\n\
  Sync: how to perform multichannel operations.\n\
  Speed: how to change sampling rate.\n\
  Expand: how to change tempo.\n\
  Reverb: how to reverberate.\n\
  Contrast: how to add contrast enhancement.\n\
  Envelope: how to apply an envelope.\n\
  Marks: about marks in Snd.\n\
  Formats: Snd-supported formats and headers.\n\
  Customization: how to customize Snd.\n\
  User functions: how to add your own functions to Snd.\n\
";

char *get_help_menu_help(void) {return(help_menu_help);}


static char about_snd_help[] = 
"Snd is a sound editor. See snd.html for\n\
full details.  To get started, go to the\n\
File menu, Open a sound file, then click\n\
the 'play' button. To see an fft, click the\n\
'f' button on the left.  The left mouse button\n\
is used for most pointing operations; the\n\
middle button pastes in the current selection;\n\
the right button brings up the Snd popup menu.\n\
";

char *get_about_snd_help(void) {return(about_snd_help);}


static char graph_help[] =
"  [Down] zoom out, amount depends on state keys\n\
  [Up] zoom in\n\
  [Left] move window left, amount depends on state keys\n\
  [Right] move window right\n\
  <:   move cursor to sample 0\n\
  >:   move cursor to last sample\n\
  c-<: move cursor to sample 0\n\
  c->: move cursor to last sample\n\
  c-a: move cursor to window start\n\
  c-b: move cursor back one sample\n\
  c-d: delete sample at cursor\n\
  c-e: move cursor to window end\n\
  c-f: move cursor ahead one sample\n\
  c-g: abort current command\n\
  c-h: repeat external function call\n\
  c-i: display cursor info\n\
  c-j: goto mark\n\
  c-k: delete one line's worth of samples\n\
  c-l: position window so cursor is in the middle\n\
  c-m: place (or remove) mark at cursor location\n\
  c-n: move cursor ahead one 'line'\n\
  c-o: insert one zero sample at cursor\n\
  c-p: move cursor back one 'line'\n\
  c-q: play current channel starting at cursor\n\
  c-r: repeat last search backwards\n\
  c-s: search according to an expression\n\
       'y' is the current sample value,\n\
       'y(n) is the value of the sample n from the current\n\
       the find expression syntax is C-like and\n\
       supports much of C and its math library.\n\
       c-s y>.1 finds the next sample greater than .1\n\
  c-t: stop playing\n\
  c-u: start count definition.  If followed by a\n\
       float, the actual count is that number multiplied\n\
       by the current sampling rate.  If the optional\n\
       number is followed by c-m, the count returned\n\
       is the distance from the cursor to the n-th\n\
       successive mark.  That is, c-u c-m c-f is the\n\
       same as c-j.\n\
  c-v: move cursor to mid-window\n\
  c-w: delete current region\n\
  c-x: start extended command (see below)\n\
  c-y: paste in last deleted region. Use c-u\n\
       to paste in earlier regions.\n\
  c-z: set sample at cursor to 0.0\n\
  c-_: undo\n\
  c-[Space]: start region definition\n\
\n\
The extended commands (preceded by c-x) are:\n\
  a: apply envelope to selection\n\
  b: position window so cursor is on left margin\n\
  c: define selection from cursor to nth mark\n\
  d: set temp dir name\n\
  e: execute last keyboard macro\n\
  f: position window so cursor is on right margin\n\
  h: apply external function to selection\n\
  i: insert region\n\
  j: goto named mark\n\
  k: close file\n\
  l: position selection in mid-view\n\
  n: re-evaluate expression over selection\n\
  o: move to next or previous graph\n\
  p: play selection or region n\n\
  q: mix in region\n\
  r: redo last undone edit\n\
  u: undo last edit\n\
  v: position window over current selection\n\
  w: save selection as file\n\
  x: evaluate expression over selection\n\
  y: get and apply external function to selection\n\
  z: smooth selection\n\
  /: place named mark\n\
  (: begin keyboard macro definition\n\
  ): end keyboard macro definition\n\
\n\
  c-a: apply envelope.  If a count is specified,\n\
     the envelope is applied from the cursor for\n\
     that number of samples.  Otherwise, the\n\
     envelope is applied to the entire file, and\n\
     if syncing is on, all sync'd channels.\n\
  c-b: set x window bounds (preceded by 1 arg)\n\
  c-c: hide controls\n\
  c-d: print\n\
  c-e: give last keyboard macro a name\n\
  c-f: open file\n\
  c-g: abort command\n\
  c-h: external function call\n\
  c-i: insert file\n\
  c-l: load user function\n\
  c-m: add named mark\n\
  c-n: re-evaluate expression\n\
  c-o: show controls\n\
  c-p: set window size (preceded by 1 arg)\n\
  c-q: mix in file\n\
  c-r: redo last undone edit\n\
  c-s: save file\n\
  c-u: undo last edit\n\
       Snd supports 'unlimited undo/redo'\n\
  c-v: set window size as percentage of total\n\
  c-w: save current channel in file\n\
  c-y: set up auto-call of external function\n\
  c-x: evaluate expression\n\
  c-z: smooth using cosine\n\
\n\
Unless otherwise noted, case is not significant;\n\
c-a is the same as c-A.\n\
\n\
Most commands can be prefaced by an integer or\n\
a float; the integer causes the command to be repeated\n\
that many times; the float is multiplied by the\n\
sound's sampling rate, then applied that many times.\n\
So, for example, c-u 1.0 c-f causes the cursor to move\n\
ahead one second in the sound.\n\
\n\
The y-axis limit (default = 1.0) can be set\n\
in the minibuffer via the variable 'y_max'.\n\
\n\
A named macro can be invoked with M-x; M-x save-macros\n\
saves the current named macros; M-x save-macro mac\n\
saves one macro named 'mac'; both put the macro\n\
definition in the Snd initialization file, normally '.snd'.\n\
\n\
";

char *get_graph_help(void) {return(graph_help);}

static char fft_keypad_help[] = 
"The keypad keys are mapped to various variables as follows:\n\
\n\
    variable         increase           decrease\n\
  sono_max          PageUp (9)          PageDown (3)\n\
  spectro_hop       Add (+)             Subtract (-)\n\
  spectro_zangle    RightArrow (6)      LeftArrow (4)\n\
  spectro_xangle    Ctrl-UpArrow (8)    Ctrl-DownArrow (2)\n\
  spectro-yangle    Ctrl-RightArrow (6) Ctrl-LeftArrow (4)\n\
  spectro_zscl      UpArrow (8)         DownArrow (2)\n\
  fft_size          Multiply (*)        Divide (/)\n\
  dot_size          Delete (.)          Insert (0)\n\
\n\
You can rotate the spectrogram around the various axes\n\
by holding down the keypad and control keys.  You can get\n\
arbitrarily small or large ffts with the Multiply and\n\
Divide keys.  The x and y axis scalres are named\n\
spectro_xscl and spectro_yscl; they can be set via\n\
C-X C-X.  The keypad Enter key resets all the\n\
spectrogram variables to their default values.\n\
(In Linux, use the corresponding numbered keys --\n\
add shift to the key sequences given above).\n\
See also the Color and Orientation menu options\n\
in the View menu.\n\
\n\
";

char *get_fft_keypad_help(void) {return(fft_keypad_help);}

static char fft_menu_help[] = 
"The FFT performs a projection of the\n\
time domain into the frequency domain.\n\
Good discussions of the Fourier Transform\n\
and the trick used in the FFT itself\n\
can be found in many DSP books; those\n\
I know of include 'A Digital Signal Processing\n\
Primer', Ken Steiglitz, Addison-Wesley,\n\
1996; or 'Numerical Recipes in C', mentioned\n\
below.\n\
\n\
The FFT size can be any power of 2. The\n\
larger, the longer it takes to compute,\n\
and the larger the amount of the time domain\n\
that gets consumed.  Interpretation of the\n\
FFT results is not straightforward!\n\
\n\
The window choices are taken primarily\n\
from Harris' article.\n\
\n\
  Fredric J. Harris, 'On the Use of Windows\n\
     for Harmonic Analysis with the Discrete\n\
     Fourier Transform', Proceedings of the\n\
     IEEE, Vol. 66, No. 1, January 1978.\n\
\n\
with updates from:\n\
\n\
  Albert H. Nuttall, 'Some Windows with Very\n\
     Good Sidelobe Behaviour', IEEE Transactions\n\
     of Acoustics, Speech, and Signal Processing,\n\
     Vol. ASSP-29, 1, February 1981.\n\
\n\
Some of the windows take an additional parameter\n\
sometimes known as alpha or beta.  This is set\n\
in Snd by the FFT Beta menu.  The FFT display\n\
is activated by setting the 'f' button on the\n\
channel's window.  It then updates itself each\n\
time the time domain waveform moves or changes.\n\
The update function runs in the background, so\n\
in some cases, notably very large FFTs, you will\n\
notice that the FFT updates less often than the\n\
time domain.\n\
\n\
To display the y axis in dB, use the FFT in dB\n\
menu option; similarly to get a logarithmic x\n\
axis, use the FFT Log Freq menu choice.\n\
\n\
To get a sonogram display, rather than a simple\n\
FFT, use the Sonogram option in the FFT Style menu.\n\
To reset the maximum frequency displayed (on the\n\
sonogram's y axis), use the Snd variable sono_max.\n\
To change the color map used when printing, set\n\
the Snd variable color_max. It ranges between 0.0\n\
and 1.0, with smaller values giving darker results.\n\
\n\
All the FFT choices can be set at initialization\n\
time by setting the appropriate variable in the\n\
init file (normally named '.snd' and placed on\n\
your home directory).  The relevant variables\n\
with example (the default) settings are:\n\
\n\
(setf fft-size 256)\n\
(setf fft-window 6) ;Blackman order 2\n\
  ;; see snd-fft.c for the complete list\n\
(setf fft-beta 2.5)\n\
(hide-fft)          ;(show-fft) to turn fft on\n\
(fft-linear)        ;(fft-dB) for dB\n\
(fft-linear-freq)   ;(fft-log-freq) for log freq\n\
(fft-style 0)       ;1=sonogram, 2=spectrogram\n\
sono_max = 1.0      ;1.0 corresponds to srate/2\n\
\n\
The actual FFT algorithm used here is the\n\
'realft' function from 'Numerical Recipes in C',\n\
by Press et al, Cambridge Univ Press, 1989.\n\
\n\
";

char *get_fft_menu_help(void) {return(fft_menu_help);}

static char find_menu_help[] = 
"Searches in Snd refer to the sound data, and are\n\
in general patterned after Emacs.  When you type\n\
c-s or c-r, the minibuffer below the graph is\n\
activated and you are asked for the search expression.\n\
The expression is a piece of C-like code that describes\n\
which sample satisifies the search.  For example,\n\
to look for the next sample that is greater than\n\
.1, we could type: y>.1.  The cursor then moves\n\
to the next such sample, if any.  Successive c-s\n\
or c-r repeat the search.  c-x c-s can redefine the\n\
search pattern, which is also cleared in other\n\
events, much like Emacs.\n\
\n\
The search (and c-x c-x eval) expression\n\
syntax includes most of C's operators, and the\n\
standard math library, as well as many variables\n\
internal to Snd.  To get at the current sample's\n\
value, use 'y'.  'y(n)' refers to the sample\n\
n samples from the current one. 'x' is the current\n\
sample number. 'samples' is the total number of\n\
samples.\n\
\n\
Normally, the search applies only to the current channel.\n\
To search\n\
all current files at once, use the Edit menu's\n\
find option.\n\
\n\
";

char *get_find_menu_help(void) {return(find_menu_help);}

static char expression_help[] = 
"The C operators implemented are:\n\
\n\
+ - * / > >= < <= == != ( ) { }\n\
=+ *= /= -= = || && ? : !\n\
\n\
The math library functions included are:\n\
\n\
log log10 exp cos sin abs (i.e. fabs)\n\
pow sqrt atan acos asin cosh sinh tanh fmod\n\
ceil floor\n\
\n\
Variables can be defined with 'float'.\n\
\n\
Snd-internal variables that are accessible\n\
in these expressions include:\n\
\n\
  auto_open      force open window upon activation\n\
  explen:        segment length in expand\n\
  exprmp:        ramp size in expand\n\
  exphop:        hop size in expand\n\
  revfb:         reverb volume\n\
  y_max:         y axis bounds\n\
  revlp:         reverb feedback low-pass coefficient\n\
  x:             cursor sample number\n\
  y:             value at cursor (y(n) also)\n\
  samples:       current length of channel\n\
  srate:         current srate of file\n\
  x_max:         x axis bounds\n\
  color_scale:   darkness setting\n\
  color_cutoff:  small values ignored?\n\
  revdecay:      length(secs) of reverb decay\n\
  line_size:     length of a 'line' (for C-p etc)\n\
  contrast_amp:  scaler on contrast input\n\
  fft_size:      fft size\n\
  sono_max:      sonogram y axis limit\n\
  sono_color:    sonogram color set (0..4)\n\
  spectro_color: spectrogram color set (-1..4)\n\
  spectro_hop:   density of spectrogram traces\n\
  spectro_xangle:viewing angle of spectrogram (also spectr_yangle,spectro_zangle)\n\
  spectro_zscl:  height of peaks in spectrogram (also spectro_xscl, spectro_yscl)\n\
  dot_size:      size of graph dots\n\
\n\
";

char *get_expression_help(void) {return(expression_help);}


static char undo_menu_help[] = 
"Snd supports unlimited undo in the\n\
sense that you can backup through all\n\
the edits since the last save, and at\n\
any point redo those edits.  Certain\n\
operations require that temporary files\n\
be written, so disk space may eventually\n\
become a problem.  Revert is the same\n\
as backing up to the last save.\n\
\n\
In addition, eight or so of the previous\n\
selections are saved on a stack accessible\n\
via c-y.\n\
\n\
";

char *get_undo_menu_help(void) {return(undo_menu_help);}


static char sync_menu_help[] = 
"The sync button causes certain operations to\n\
apply to all channels simultaneously.  In mono\n\
sounds, the sync button has a similar effect,\n\
but applied across multiple sounds.\n\
\n\
To get multi-channel selections, set the sync\n\
button, then define the selection (by dragging\n\
the mouse) in one channel, and the parallel\n\
portions of the other channels will also be\n\
selected.\n\
\n\
Currently the sync-able operations include\n\
those that move the cursor, reset or resize\n\
the graph bounds, make or paste selections,\n\
or perform searches.\n\
\n\
";

char *get_sync_menu_help(void) {return(sync_menu_help);}


static char speed_menu_help[] = 
"'Speed' here refers to the rate at which the\n\
sound data is consumed during playback.\n\
Another term might be 'srate'.  Snd uses\n\
linear interpolation to perform the speed\n\
change.  The arrow button on the right determines\n\
the direction we move through the data.\n\
\n\
";

char *get_speed_menu_help(void) {return(speed_menu_help);}


static char expand_menu_help[] = 
"'Expand' here refers to a kind of granular\n\
synthesis used to change the tempo of events\n\
in the sound without changing pitch.  Successive\n\
short slices of the file are overlapped with\n\
the difference in size between the input and\n\
output hops (between successive slices) giving\n\
the change in tempo.  This doesn't work in all\n\
files -- it sometimes sounds like execrable reverb\n\
or is too buzzy -- but it certainly is more\n\
robust than the phase vocoder approach to the\n\
same problem.  The phase vocoder NEVER works!\n\
\n\
There are a variety of variables that control\n\
hop sizes, segment lengths, and overall segment\n\
envelopes.  These can be set in the minibuffer\n\
via c-x c-x, or in your Snd init file.  In the\n\
former, the syntax is C-like; in the latter,\n\
Lisp-like.  The variables are:\n\
\n\
  exprmp: the length of the ramp up (.4, 0 to .5)\n\
  explen: the length of each slice (.15)\n\
  exphop: the hop size (.05)\n\
\n\
The expander is on only if the expand\n\
button is set.\n\
\n\
";

char *get_expand_menu_help(void) {return(expand_menu_help);}


static char reverb_menu_help[] = 
"The Snd reverberator is a version of Michael\n\
McNabb's Nrev.  In addition to the controls\n\
in the control pane, you can set the reverb\n\
feedback gains and the coefficient of the low\n\
pass filter in the allpass bank. The variables\n\
are 'revfb' and 'revlp'.  The reverb is on only\n\
if the reverb button is set.\n\
";
char *get_reverb_menu_help(void) {return(reverb_menu_help);}


static char contrast_menu_help[] = 
"'Contrast enhancement' is my name for this\n\
somewhat weird waveshaper or compander.  It\n\
phase-modulates a sound, which can in some\n\
cases make it sound sharper or brighter.\n\
For softer sounds, it causes only an amplitude\n\
change.  Contrast is on only if the contrast\n\
button is set.\n\
\n\
";
char *get_contrast_menu_help(void) {return(contrast_menu_help);}


static char env_menu_help[] = 
"An envelope in Snd is a sequence of x y\n\
break-point pairs. The x axis range is\n\
arbitrary. For example, to define a triangle\n\
curve: '0 0 1 1 2 0'. There is no (obvious) limit\n\
on the number of breakpoints.\n\
\n\
To apply an envelope to a sound, use the extended\n\
command C-x C-a. If this command gets a numeric\n\
argument, the envelope is applied from the cursor\n\
for that many samples.\n\
\n\
  C-x a     apply amplitude envelope to selection\n\
  C-x C-a   apply amplitude envelope to channel\n\
\n\
You can also specify a file name to the C-x C-a\n\
prompt. In this case the envelope breakpoints are\n\
read from the file which is assumed to contain an\n\
even number of floats. The corresponding M-x\n\
commands are:\n\
\n\
  amp-env beg dur scaler env ;beg and dur in samples, env=breakpoints\n\
  amp-envelope env           ;applies from sample 0 to end, scaler=1.0\n\
  selection-amp-envelope env ;same but applied to all of selection\n\
\n\
M-x (amp-envelope 0 1 1 0 2 1), for example, ramps\n\
the sound down to 0 in its middle, then ramps back\n\
up to the original by the end.\n\
\n\
To scale a file or selection by or to some\n\
amplitude, use the M-x commands:\n\
\n\
  scale-by args\n\
  scale-to args\n\
  scale-selection-by args\n\
  scale-selection-to args\n\
\n\
scale-by scales the current sync'd channels by its\n\
arguments, and scale-to scales them to its\n\
arguments (a normalization). The arguments in\n\
each case are either a list of floats\n\
corresponding to each successsive member of the\n\
current set of sync'd channels, or just one\n\
argument. In the latter case, scale-by uses that\n\
scaler for all its channels, and scale-to\n\
normalizes all the channels together so that the\n\
loudest reaches that amplitude (that is, scale-to\n\
.5) when applied to a stereo file means that both\n\
channels are scaled by the same amount so that the\n\
loudest point in the file becomes .5).\n\
";
char *get_env_menu_help(void) {return(env_menu_help);}


static char format_menu_help[] = 
"Snd can read and write any of the sound\n\
file data and header formats that CLM can\n\
handle:\n\
\n\
Supported read/write:\n\
  NeXT/Sun/DEC/AFsp 8-bit mulaw and alaw, 8, 16, 24, 32-bit linear, 32, 64-bit float\n\
  AIFF 8, 16, 24, 32-bit linear, 8-bit mulaw and alaw (AIFC in these cases)\n\
  RIFF ('wave') 16-bit linear, 8-bit unsigned, 32-bit linear, 8-bit mulaw, 8-bit alaw\n\
  IRCAM (old style) 16-bit linear, 32-bit float, 8-bit mulaw and alaw\n\
  no header, any data format\n\
\n\
Supported read-only:\n\
  8SVX 8-bit linear, 16-bit linear\n\
  IRCAM 32-bit Vax float\n\
  EBICSF, INRS, ESPS, SPPACK, ADC (OGI) 16-bit linear\n\
  NIST-SPHERE 16-bit linear, 8-bit mulaw and alaw\n\
  AVR 16-bit linear and unsigned, 8-bit linear and unsigned\n\
  VOC 8-bit unsigned, 16-bit linear\n\
  Sound Tools 8-bit unsigned\n\
  Turtle Beach SMP, SoundFont 2.0 16-bit linear\n\
  Sound Designer I\n\
  PSION alaw, MAUD 8/16 bit\n\
  Tandy DeskMate new and old style 8-bit unsigned\n\
  Gravis Ultrasound 16-bit unsigned, Comdisco SPW\n\
  Goldwave sample, Sonic Foundry Resource\n\
\n\
Translated automatically:\n\
  IEEE text, Mus10 SAM 16-bit (modes 1 and 4)\n\
  IBM CVSD, HCOM, NIST shortpack\n\
  MIDI sample dump, Intel ADPCM\n\
\n\
'Linear' here means 2's complement integer.\n\
The files can have any number of channels.\n\
Data can be either big or little endian.\n\
\n\
When edits are saved, files in the first\n\
group are changed in place; those in the second\n\
group are changed to use one of the first\n\
group's headers (normally NeXT); those in\n\
the third group are translated when opened\n\
and an new (perhaps redundant) '.snd' extension\n\
is added to distinguish the original from the\n\
translated form; the latter is then treated\n\
as the original by the editor.\n\
\n\
";

char *get_format_menu_help(void) {return(format_menu_help);}


static char info_help[] = 
"This is the 'minibuffer', to use Emacs\n\
jargon.  Although it looks inert and wasted,\n\
there is in fact a text window lurking beneath\n\
that has access to a C-syntax evaluator, not\n\
to mention much of the innards of the Snd program.\n\
Click on the middle of the empty portion, and\n\
type some expression like '3+2'. It will report\n\
'3+2 => 5.0', which, given that it knows only\n\
floats, is not surprising.\n\
\n\
The minbuffer comes to life in many situations\n\
where information is needed to continue, but a\n\
fancy dialog window struck me as silly.\n\
\n\
";

char *get_info_help(void) {return(info_help);}


static char play_help[] =
"Snd can play any number of sounds at once\n\
or should be able to anyway.  A sort of\n\
clumsy realtime mixer, although it was not\n\
intended to fill that role. \n\
\n\
";

char *get_play_help(void) {return(play_help);}


static char mark_help[] = 
"A mark in Snd is attached to a particular\n\
sample in the sound data.  It moves with that\n\
sample as you edit the data, and if the sample\n\
is deleted, so is its mark.  Marks also follow\n\
the undo/redo edit history -- I'm not sure this\n\
is a good idea, but it seemed more intuitive\n\
than other alternatives.  This means that marks\n\
are 'undone' and 'redone' alongside the edits\n\
that they accompany.\n\
\n\
The mark symbol itself has three or four\n\
parts.  The name, if any, is at the top.\n\
Then a 'tab'.  You can click the name or\n\
tab portion and drag the mark to redefine it.\n\
Then a line to the bottom of the graph, showing\n\
where the mark is. And, below the x axis, an\n\
arrow.  You can click and drag the arrow to\n\
play the data following the mouse -- sort of\n\
like listening to a tape as you rock it back\n\
and forth by hand on the spindles. Or just\n\
click the arrow to play the data starting\n\
at the mark.\n\
\n\
";

char *get_mark_help(void) {return(mark_help);}


static char init_file_help[] =
"Nearly everything in Snd, program state\n\
and actions, can be set in an initialization\n\
file, read after a system crash from an\n\
automatically generated backup file,\n\
specified via inter-process communciation\n\
by any other program, invoked via M-x, or\n\
imbedded in a macro.  The syntax used is\n\
lisp-like; the point of view adopted here\n\
will be that of someone writing an intialization\n\
file to customize his version of Snd.  The\n\
same syntax is used in the backup file (normally\n\
called '.snd-backup'), the initialization file\n\
(normally called '~/.snd'), and the IPC channel.\n\
The latter is a pair of FIFOs called '/tmp/snd-clm-fifo'\n\
for Snd communication to the other program\n\
(obviously CLM is the intended recipient), and\n\
and /tmp/clm-snd-fifo for the other direction.\n\
The commands that Snd recognizes are:\n\
\n\
 (disconnect): close the FIFOs (no more IPC)\n\
 (exit): quit snd\n\
 (open file): open a file (no quotes around name)\n\
 (view file): open file read-only\n\
 (save file) (save-as file1 file2)\n\
 (revert file)\n\
 (close file)\n\
 (new)\n\
 (sound file): returns data in file\n\
 (cut) (copy) (paste n) \n\
 (undo n) (redo n) \n\
 (dots) (lines)\n\
 (show-peaks) (hide-peaks)\n\
 (show-marks) (hide-marks) (save-marks)\n\
 (show-y-zero) (hide-y-zero)\n\
 (show-fft) (hide-fft) \n\
 (show-wave) (hide-wave) \n\
 (fft-style n)\n\
 (focus-style n)\n\
 (sync) (unsync) (unite) (separate)\n\
 (normalize)\n\
 (fft-dB) (fft-linear)\n\
 (fft-log-freq) fft-linear-freq)\n\
 (subsampling-on) (subsampling-off) \n\
 (x-axis low high) (y-axis max) \n\
 (axes x0 x1 y0 y1)\n\
 (find expr) (maxamp) (info)\n\
 (goto-mark name) (mark name) (setf (mark name) sample)\n\
 (goto-sound file) (goto-channel file chan)\n\
 (region n) (setf-region low high)\n\
 (play file) (stop file)\n\
 (insert beg num) (change beg num) (delete beg num)\n\
 (command cmd state): cmd here is a keyboard \n\
    command (ASCII) that snd is to execute, state = \n\
    control/shift/meta bits (4/1/8)\n\
 (key key state): same as command but key = char not ASCII\n\
 (new data): create new buffer, display data (int array)\n\
 (float a)\n\
 (load file) (temp-dir dir)\n\
 (load-function lib fun) (function fun)\n\
 (select-sound n) and (select-channel n)\n\
 (show-controls) and (hide-controls)\n\
 (save-controls) (restore-controls)\n\
 (silent-cursor) and (verbose-cursor)\n\
 (just-sounds) and (all-files)\n\
 (eval expr): send expr to Snd's C-style parser/evaluator\n\
 (default-output-type n)\n\
 (save-macros) (save-macro name)\n\
 (raw-sound srate chans format defaults)\n\
 (amp-env beg dur scl env)\n\
\n\
The variables that Snd recognizes are:\n\
   cursor y\n\
   fft-window fft-size fft-beta\n\
   expand-button contrast-button reverb-button filter-button\n\
   window-height window-width dot-size\n\
   amp speed contrast expand revscl revlen line-size\n\
   filter filter-order remember-state combine-channels\n\
   explen exprmp exphop revfb y-max\n\
   revlp x color-max sono-max contrast-amp\n\
   raw-srate raw-chans raw-format raw-defaults header-type\n\
   auto-open spectro-[xyz]angle spectro-[xyz]scl spectro-hop\n\
   mix-waving mix-stating mix-controling mix-width mix-height\n\
   mix-tiny-font-name mix-tiny-font-size mix-normal-font-name mix-normal-font-size\n\
\n\
As an example, say we always want the fft\n\
graph, and its associated peaks displayed.\n\
And we want the file browser to default to\n\
listing only sound files. We create the file\n\
~/.snd and place in it:\n\
\n\
(show-peaks)\n\
(show-fft)\n\
(just-sounds)\n\
\n\
If you'd like Snd to start up in the state\n\
you left it in upon last exiting, set the\n\
variable remember-state to 1.\n\
\n";

char *get_init_file_help(void) {return(init_file_help);}

static char resource_help[] =
"I'm not a big fan of X's notion of\n\
resources, since I can't disambiguate\n\
the weird syntax; but if you'd like to\n\
change the colors or fonts used, the\n\
Snd-specific resources (for the SGI) are:\n\
\n\
initFile: ~/.snd\n\
backupFile: .snd-backup\n\
epsFile: snd.eps\n\
\n\
buttonFont: -*-times-medium-r-*-*-14-*-*-*-*-*-iso8859-1\n\
boldbuttonFont: -*-times-bold-r-*-*-14-*-*-*-*-*-iso8859-1\n\
axisLabelFont: -*-times-medium-r-normal-*-20-*-*-*-*-*-iso8859-1\n\
axisNumbersFont: -*-courier-medium-r-normal-*-14-*-*-*-*-*-iso8859-1\n\
\n\
useSchemes: False\n\
\n\
lightestcolor: ivory1\n\
basiccolor: ivory2\n\
darkcolor: ivory3\n\
darkestcolor: ivory4\n\
textcolor: lightsteelblue1\n\
cursorcolor: cyan\n\
selectioncolor: ivory4\n\
\n\
If you use schemes, the color resources are ignored.\n\
Also, the LIBS statement in the Snd makefile is\n\
different if you choose to use schemes.  If you\n\
use schemes with the simpler LIBS statement, Snd\n\
will die with complaints about corrupt data.\n\
\n\
See Snd.ad.\n\
\n";

char *get_resource_help(void) {return(resource_help);}


static char region_browser_help[] =
"This is the 'region browser'.  The scrolled\n\
window contains the list of current regions\n\
with a brief title to indicate the provenance\n\
thereof, and two buttons.  The 'save' button\n\
protects or unprotects the region from deletion.\n\
The 'play' button plays the associated region.\n\
One channel of the currently selected region\n\
is displayed in the graph window.  The up and\n\
down arrows move up or down in the region's\n\
list of channels.  If you click a region's\n\
title, the text is highlighted, and that region\n\
is displayed in the graph area.  You can cause\n\
that region to become the current 'selection'\n\
by clicking the 'Select' button (this merely\n\
moves the region to the top slot in the region\n\
list).  You can delete the selected region by\n\
clicking the 'Delete' button.  To dismiss the\n\
browser, click 'Ok'.\n\
\n";

char *get_region_browser_help(void) {return(region_browser_help);}


static char ufun_help[] = 
"User functions are external functions, loaded\n\
into a shared library or shared object file.\n\
They can be loaded into Snd at any time and\n\
thereafter called via the commands given below.\n\
These functions have access to all the sound\n\
data and can operate on it in many ways.\n\
Due to limitations in shared object files,\n\
the communication path between Snd and a\n\
user function is somewhat peculiar.\n\
\n\
There are several examples of user functions\n\
in the Snd source file snd-ufunex.c, normally\n\
loaded into sndlib.so during the Snd make process.\n\
These examples should give an idea of how to add\n\
your own favorite functions to Snd.\n\
\n\
The interface is defined in snd-ufun.h; briefly,\n\
a user function is loaded via C-X C-L or the\n\
command (load-function).  In both cases the\n\
arguments are the library name (no quotes)\n\
followed by the function name (no quotes).\n\
For example, the rms function in snd-ufunex.c\n\
can be loaded into Snd with:\n\
\n\
C-X C-L sndlib.so,rms\n\
\n\
Once loaded, the function can be invoked with\n\
\n\
C-X C-H rms\n\
\n\
and thereafter with C-H.  If instead, you\n\
invoke the function with C-X C-Y, the function\n\
will be called automatically thereafter each time\n\
the data in the channel window changes.  This can\n\
be cancelled by giving a '-' argument to C-X C-Y.\n\
To apply the function to the current selection,\n\
use C-X h or C-X y.  Arguments can be passed to\n\
the user function:\n\
\n\
C-X C-H a_func(4,3.14)\n\
\n\
See snd-ufunex.c if you're interested in writing\n\
one of these functions.\n\
\n\
";

char *get_ufun_help(void) {return(ufun_help);}


static char mixing_help[] =
"No mixing help yet...\n\
\n\
";
char *get_mixing_help(void) {return(mixing_help);}
