#include "snd.h"

/* extracted from cmus.c and changed slightly for Snd */

static void c_io_bufclr (int *io, int *datai, int beg)
{
  int i,k,end;
  int *j;
  if (io[io_dats+c_aref_block] == 0) clm_printf("attempt to clear deallocated IO buffer");
  else
    {
      end=io[io_bufsiz];
      for (k=0;k<io[io_chans];k++)
	{
	  j=((int *)datai[io[io_dats+c_aref_block]+k]);
	  if (j) {for (i=beg; i<end;i++) j[i]=0;}
	}
    }
}

#if 0
void print_io(int *io, int *datai)
{
  fprintf(stderr,"fd: %d, chans: %d, size: %d, beg: %d, end: %d, bufsiz: %d, data_start: %d, data_end: %d\n",
	 io[io_fd],io[io_chans],io[io_size],io[io_beg],io[io_end],io[io_bufsiz],io[io_data_start],io[io_data_end]);
  fprintf(stderr,"index: %d, dir: %d, loc: %d, hdr: %d, incr: %d, dats: %d, dats[0]: %d\n",
	 io[io_open_index],io[io_dir],io[io_loc],io[io_hdr_end],io[io_incr],io[io_dats],datai[io[io_dats]]);
}
#endif

void clm_file_reset(int loc0, int *io, int *datai)
{
  /* called when loc is outside the current in-core frame for the file pointed to by io */
  /* equivalent to the io.lisp function file-check + read-in */

  int file_end,bytes,loc;
  int bufend,filbytes;
  char *str;
  loc = loc0;
  if (io[io_dir] != io_in_f) 
    {
      if ((io[io_fd] != cl_false) &&
	  (io[io_data_end] != 0) &&
	  (io[io_data_start] != io[io_data_end]))
	{
	  if (io[io_data_end] > io[io_bufsiz])
	    {
	      str=(char *)calloc(256,sizeof(char));
	      sprintf(str,"data end indication in IO buffer is too big: %d > %d",io[io_data_end],io[io_bufsiz]);
	      clm_printf(str);
	      free(str);
	    }
	  else
	    {
	      clm_seek(io[io_fd],io[io_hdr_end]+(2*io[io_chans]*(io[io_beg]+io[io_data_start])),0);
	      if ((io[io_data_start] < 0) || (io[io_data_end] < 0)) 
		{
		  clm_printf("file buffer index is negative! -- will try to fix it...");
		  if (io[io_data_start] < 0) io[io_data_start] = 0; else io[io_data_end] = 0;
		}
	      clm_write(io[io_fd],io[io_data_start],io[io_data_end],io[io_chans],(int **)(datai+io[io_dats+c_aref_block]));
	      io[io_data_start] = io[io_data_end];
	      if (io[io_size] < (io[io_beg] + io[io_data_end])) io[io_size] = (io[io_beg] + 1 + io[io_data_end]);
	    }
	}
    }
  if ((loc < io[io_beg]) && ((loc + (int)(.9*io[io_bufsiz])) > io[io_beg]))
    {
      if ((loc + 10) > io[io_beg]) loc -= (int)(.75*io[io_bufsiz]);
      if (loc < 0) loc = 0;
      if (io[io_chans] == 1) loc = (2 * (int)(loc / 2));
    }
  file_end = io[io_size];
  bytes = file_end - loc;
  if (bytes > io[io_bufsiz]) bytes=io[io_bufsiz];
  if (bytes < 0)                   /* tried to access beyond current end of file */
    {
      if (io[io_dir] == io_in_f) {io[io_beg]=loc; c_io_bufclr(io,datai,0);} /* different from CLM */
      else
	{
	  c_io_bufclr(io,datai,0);
	  bytes = io[io_bufsiz];
	  io[io_data_start] = 0;
	  io[io_data_end] = 0;
	  clm_seek(io[io_fd],0,2);  /* go to end of file */
	  if (io[io_chans] != 1)
	    {
	      clm_write_zeros(io[io_fd],io[io_chans]*(loc-file_end)); 
	      io[io_beg]=loc;
	    }
	  else
	    {
	      clm_write_zeros(io[io_fd],loc-file_end); 
	      if ((loc%2)==0) io[io_beg]=loc; 
	      else io[io_beg]=loc-1;
	    }
	}
    }
  else /* bytes is positive or 0 */
    {
      clm_seek(io[io_fd],io[io_hdr_end]+(2*io[io_chans]*loc),0);
      io[io_beg] = loc;
      if (bytes > 0) 
	{
	  if (bytes > io[io_bufsiz]) 
	    {
	      str=(char *)calloc(256,sizeof(char));
	      sprintf(str,"input request is too big: %d", bytes);
	      clm_printf(str);
	      free(str);
	    }
	  else
	    {
	      clm_read_chans(io[io_fd],0,bytes-1,io[io_chans],
			     (int **)(datai+io[io_dats+c_aref_block]),
			     (int *)(datai+io[io_dats+c_aref_block]));
	      /* too clever -- I'm using the array of pointers to data buffers as the channel chooser as well */
	      /* there are cases (file_override_samples) where this is necessary. or at least less wasteful */
	    }
	}
      if (bytes < io[io_bufsiz]) c_io_bufclr(io,datai,bytes);
      io[io_data_start] = 0;
      io[io_data_end] = 0;
      if (io[io_dir] == io_in_f)
	{
	  bufend = io[io_bufsiz]-1;
	  filbytes = file_end-io[io_beg]-1;
	  if (filbytes < bufend) bufend = filbytes;
	  if (bufend > 0) io[io_data_end] = bufend;
	}
    }
  io[io_end] = io[io_beg]+io[io_bufsiz]-1;
  io[io_loc] = (loc0-io[io_beg]);
}


/* extracted from merge.c and changed slightly (this is actually for the clm-snd debugger linkage) */

int file_maxamps(char *ifile, float *vals, int *changes)
{
  int ifd,ichans,idataloc,bufnum,n,cursamples,idatasize,loc,i,samples,chn,fc;
  int *buffer,*amps;
  int **ibufs;
  if ((ifd=clm_open_read(ifile)) == -1) return(0);
  /* c_read_header_with_fd(ifd); */
  open_clm_file_descriptors(ifd,c_snd_header_format(),c_snd_header_datum_size(),c_snd_header_data_location());
  idataloc = c_snd_header_data_location();
  ichans = c_snd_header_chans();
  idatasize = c_snd_header_data_size();
  samples = (idatasize / ichans);
  if (samples <= 0) {clm_close(ifd); return(0);}
  loc=clm_seek(ifd,idataloc,0);
  if (loc<idataloc) {clm_close(ifd); return(0);}
  ibufs = (int **)calloc(ichans,sizeof(int *));
  for (i=0;i<ichans;i++) ibufs[i] = (int *)calloc(FILE_BUFFER_SIZE,sizeof(int));
  amps = (int *)calloc(ichans,sizeof(int));
  bufnum = (FILE_BUFFER_SIZE);
  for (n=0;n<samples;n+=bufnum)
    {
      if ((n+bufnum)<samples) cursamples = bufnum; else cursamples = (samples-n);
      clm_read(ifd,0,cursamples-1,ichans,ibufs);
      for (chn=0;chn<ichans;chn++)
	{
	  buffer = (int *)(ibufs[chn]);
	  fc=amps[chn];
	  for (i=0;i<cursamples-1;i++) 
	    {
	      if ((buffer[i] > fc) || (fc < -buffer[i])) 
		{
		  fc=buffer[i]; 
		  if (changes[chn] == 0) {if ((n+i) > 0) changes[chn] = 1;}
		  if (fc<0) fc = -fc;
		}
	    }
	  amps[chn]=fc;
	}
    }
  clm_close(ifd);
  for (chn=0;chn<ichans;chn++) vals[chn]=(float)(clm_sndflt*amps[chn]);
  return(1);
}

#ifdef NEXT
char *tempnam(char *ignored, char *tmp)
{
  return(copy_string(tmpnam(NULL)));
}
#endif
