/* X-specific function declarations */


typedef struct {int slice; snd_state *ss; Widget shell; Display *dpy;} task_manager;

axis_context *free_axis_context(axis_context *ax);
GC copy_GC(chan_info *cp);
GC erase_GC(chan_info *cp);

void draw_line (axis_context *ax,int x0,int y0,int x1,int y1);
void fill_rectangle (axis_context *ax,int x0, int y0, int width, int height);
void fill_rectangles (axis_context *ax, XRectangle *rects, int num);
void fill_polygon(axis_context *ax,int points, ...);
void draw_polygon(axis_context *ax,int points, ...);
void draw_string (axis_context *ax, int x0, int y0, char *str, int len);
void draw_lines (axis_context *ax,XPoint *points,int num);
void draw_points (axis_context *ax,XPoint *points,int num, int size);
void set_number_font(axis_context *ax);
void set_label_font(axis_context *ax);
int label_width(axis_context *ax, char *txt);
int number_width(axis_context *ax, char *num);
int number_height(axis_context *ax);
int label_height(axis_context *ax);

int map_over_children (Widget w, int (*func)(), void *userptr);
int set_main_color_of_widget (Widget w,void *userptr);
void make_button_label(Widget button,char *str);
void make_bold_button_label(Widget button,char *str);
void make_name_label(Widget label,char *str);

void goto_window(Widget text);
void goto_graph(chan_info *cp);
void goto_minibuffer(snd_info *sp);
void text_set_string(Widget txt, char *str);
char *text_get_string(Widget txt);
int get_window_height(Widget w);
int get_window_width(Widget w);

void set_chan_fft_in_progress(chan_info *cp, XtWorkProcId fp);
Widget add_menu(snd_state *state);
Widget get_menubar(void);

int background_zoom_color(Arg *args, int n, snd_state *ss);
int background_scale_color(Arg *args, int n, snd_state *ss);
int background_main_color(Arg *args, int n, snd_state *ss);
int background_high_color(Arg *args, int n, snd_state *ss);
int background_white_color(Arg *args, int n, snd_state *ss);
void change_color(Widget w,Pixel color);

void set_button_font(axis_context *ax, snd_state *ss);

Widget main_SHELL(void *w);
Widget main_PANE(void *w);
Display *main_DISPLAY(void *w);
int main_SCREEN(void *w);
XtAppContext main_APP(void *w);
XmFontList button_FONT(void *w);
XmFontList bold_button_FONT(void *w);
XmFontList help_text_FONT(void *w);
XFontStruct *peak_numbers_FONTSTRUCT(void *w);
XFontStruct *bold_peak_numbers_FONTSTRUCT(void *w);
XFontStruct *axis_label_FONTSTRUCT(void *w);
XFontStruct *axis_numbers_FONTSTRUCT(void *w);

Boolean CreateOpenDialog(Widget w,XtPointer clientData);

Widget snd_widget(snd_info *sp,int w);
Widget chan_widget(chan_info *cp,int w);
void make_graph_cursor(task_manager *tm);

void intern_atoms (snd_state *ss);
void InitializeDrop(snd_state *ss);

axis_context *copy_context (chan_info *cp);
axis_context *selection_context (chan_info *cp);
axis_context *cursor_context (chan_info *cp);

void make_axes(chan_info *cp, axis_info *ap);
void set_scrollbar(Widget w,float position,float range, int scrollbar_max);
float get_scrollbar(Widget w,int val, int scrollbar_max);

XtCallbackList make_callback_list(XtCallbackProc callback, XtPointer closure);

void add_channel_window(snd_info *sound, int channel, snd_state *ss, int chan_y, int insertion, Widget main);
void CopyToClipboard(Widget w, snd_state *ss);
void ClaimSelection(Widget w, XButtonEvent *ev, chan_info *cp);
void PasteSelection(Widget w, chan_info *cp);
void AddSelection(Widget w,chan_info *cp);

void StartMarkWatch(chan_info *cp);
void CancelMarkWatch(void);

void clear_window(axis_context *ax);

void set_color(axis_context *ax, Pixel color);
void reset_color(chan_info *cp);
void StartSelectionWatch(chan_info *cp);
void CancelSelectionWatch(void);

Time main_TIME(snd_state *ss);


/* these are currently implemented in X-specific files */

void snd_printf(void *ss,char *msg);
int chan_fft_in_progress(chan_info *cp);
int calculate_fft(chan_info *cp, void *ptr);
void create_popup_menu(snd_state *ss);
void reflect_file_open_in_menu (void);
void reflect_file_change_in_menu (void);
void reflect_file_lack_in_menu (void);
void reflect_file_revert_in_menu (snd_state *ss);
void reflect_file_save_in_menu (snd_state *ss);
void reflect_edit_with_selection_in_menu (void);
void reflect_edit_without_selection_in_menu (void);
void reflect_undo_in_menu(void);
void reflect_redo_in_menu(void);
void reflect_no_more_redo_in_menu(snd_info *sp);
void reflect_regions_in_menu(void);
void reflect_no_regions_in_menu(void);
int mark_name_width(snd_state *ss, char *txt);
int sound_unlock_ctrls(snd_info *sp, void *ptr);
int sound_lock_ctrls(snd_info *sp, void *ptr);
void snd_info_cleanup(snd_info *sp);
void chan_info_cleanup(chan_info *cp);
int channel_unlock_pane(chan_info *cp, void *ptr);
int channel_lock_pane(chan_info *cp, void *ptr);
void add_chan_callbacks(chan_info *cp);
void set_title(snd_state *ss, char *title);
void unlock_ctrls(snd_info *sp);
void snd_doit(snd_state *state,int argc, char **argv);

void set_peak_numbers_font(chan_info *cp);
void set_bold_peak_numbers_font(chan_info *cp);

void view_lines(snd_state *ss);
void view_dots(snd_state *ss);
void show_peaks(snd_state *ss);
void hide_peaks(snd_state *ss);
void show_marks(snd_state *ss);
void hide_marks(snd_state *ss);
void show_y_zero(snd_state *ss);
void hide_y_zero(snd_state *ss);
void show_fft(chan_info *cp);
void hide_fft(chan_info *cp);
void show_wave(chan_info *cp);
void hide_wave(chan_info *cp);
void syncb(snd_info *cp);
void unsyncb(snd_info *cp);
void fft_dB(snd_state *ss);
void fft_linear(snd_state *ss);
void subsampling_on(snd_state *ss);
void subsampling_off(snd_state *ss);
void fft_linear_freq(snd_state *ss);
void fft_log_freq(snd_state *ss);
void CLM_connect(snd_state *ss);
void CLM_disconnect(snd_state *ss);

void erase_graph_border(chan_info *cp);
void display_graph_border(chan_info *cp);

void remove_amp_env(snd_info *sp);
void signal_amp_env_done(snd_info *sp);
void remove_apply(snd_info *sp);

void set_grf_points(int xi, int j, int ymin, int ymax);
void set_grf_point(int xi, int j, int yi);
void allocate_grf_points(void);
void draw_grf_points(snd_state *ss,chan_info *cp, int j);
void draw_both_grf_points(snd_state *ss,chan_info *cp, int j);

void toggle_expand_button(snd_info *sp, int state);
void toggle_contrast_button(snd_info *sp, int state);
void toggle_reverb_button(snd_info *sp, int state);
void toggle_filter_button(snd_info *sp, int state);
void toggle_direction_arrow(snd_info *sp, int state);
void toggle_just_sounds(int n);

int snd_window_width(snd_state *ss);
int snd_window_height(snd_state *ss);
void set_snd_window_width(snd_state *ss,int width);
void set_snd_window_height(snd_state *ss,int height);


void relinquish_selection_ownership(void);
void show_controls(snd_state *ss);
void hide_controls(snd_state *ss);
void sound_show_ctrls(snd_info *sp);
void sound_hide_ctrls(snd_info *sp);
void set_view_ctrls_label(char *lab);
void reflect_play_region_stop(region_info *r);
int region_browser_is_active(void);
void update_region_browser(int grf_too);
void set_play_button(snd_info *sp, int val);
void fft_style(snd_state *ss, int style);

void allocate_sono_rects(snd_state *ss, int size);
void set_sono_rectangle(int j, int color, int x, int y, int width, int height);
void draw_sono_rectangles(chan_info *cp, int color, int jmax);

void move_selection_2(chan_info *cp);
void move_selection(chan_info *cp, int x);

void reflect_play_stop (snd_info *sp);
void set_play_in_progress (snd_state *ss, dac_manager *dac_m);

void snd_amp_changed(snd_info *sp, int val);
void snd_srate_changed(snd_info *sp, int val);
void snd_expand_changed(snd_info *sp, int val);
void snd_contrast_changed(snd_info *sp, int val);
void snd_revscl_changed(snd_info *sp, int val);
void snd_revlen_changed(snd_info *sp, int val);

int get_raw_value(Widget w);
int get_raw_size(Widget w);
void set_raw_value(Widget w, int val);
void alert_new_file(void);

void call_replay_amp(snd_state *ss, XtPointer ap,int time);
void call_replay_speed(snd_state *ss, XtPointer ap,int time);
void call_replay_contrast(snd_state *ss, XtPointer ap,int time);
void call_replay_expand(snd_state *ss, XtPointer ap,int time);
void call_replay_reverb(snd_state *ss, XtPointer ap,int time);
void call_replay_direction(snd_state *ss, XtPointer ap,int time);
void start_amp_env(snd_info *sp, int anew);
void set_apply_button(snd_info *sp, int val);

void lock_apply(snd_state *ss, snd_info *sp);
void lock_play_and_record(snd_state *ss, snd_info *sp);
void unlock_apply(snd_state *ss,snd_info *sp);
void unlock_play_and_record(snd_state *ss,snd_info *sp);
void verbose_cursor(snd_state *ss);
void silent_cursor(snd_state *ss);
file_info *get_file_info(char *filename, snd_state *ss);
void set_raw_data_defaults(int srate, int chans, int dformat, int defaults);
void get_raw_data_defaults(int *dat);

void add_snd_help(snd_state *ss, char *str);
int snd_yes_or_no_p(snd_state *ss,char *question);

void normalize_sound(snd_state *ss, snd_info *sp, snd_info *osp, chan_info *ncp);
void set_normalize_option(int on);

void combine_sound(snd_info *sp);
void separate_sound(snd_info *sp);
void combineb(snd_info *sp, int val);
void set_global_combine(snd_state *ss, int val);

void draw_spectro_line(chan_info *cp, int color, int x0, int y0, int x1, int y1);
void allocate_color_map(snd_state *ss, int colormap);

void reflect_spectro(snd_state *ss);
void remember_me(snd_state *ss, char *shortname, char *fullname);
void greet_me(snd_state *ss, char *shortname);
void make_a_big_star_outa_me(snd_state *ss, char *shortname, int big_star);
void highlight_selected_sound(snd_state *ss);
void set_file_browser_play_button(char *name, int state);
void get_current_color(int colormap, int j, int *r, int *g, int *b);
void add_files_to_prevlist(snd_state *ss, char **shortnames, char **longnames, int len);
void add_directory_to_prevlist(snd_state *ss, char *dirname);
void save_dialog_state (snd_state *ss, int fd);
void start_color_dialog(snd_state *ss, int width, int height);
void start_orientation_dialog(snd_state *ss, int width, int height);
void start_file_dialog(snd_state *ss, int width, int height);
void start_clm_dialog(snd_state *ss, char *msg, int beg, int num);
void cleanup_clm_dialog(snd_state *ss);


void free_mixes(chan_info *cp);
void get_mix_preferences(snd_state *ss);
void show_consoles(snd_state *ss);
void hide_consoles(snd_state *ss);
void update_all_consoles(snd_state *ss);
void set_mix_char_var (int which, char *val);
void set_mix_int_var (int which, int val);
char *get_mix_char_var (int which);
int get_mix_int_var (int which);

XtTranslations get_textfield_translations(void);
void textfield_focus_Callback(Widget w,XtPointer clientData,XtPointer callData);
void textfield_unfocus_Callback(Widget w,XtPointer clientData,XtPointer callData);
Widget sndCreateTextFieldWidget(snd_state *ss, char *name, Widget parent, Arg *args, int n);
