/* Sound display/edit/etc
 *
 * a re-implementation in summer 1996 of my much-missed dpysnd -- the Foonly/SAIL/E/Mus10/Grnlib sound editor from ca 1983.
 * with much help from Douglas Young's "The X Window System, Programming and Applications with Xt" Prentice-Hall 1994.
 *
 *
 * Snd code is split between the sound editor proper (every file without an 'x' in the name),
 * and anything that is specific to X/Motif.  To port to another window system, it should be 
 * sufficient to reimplement whatever is in snd-x*.h, and approximate the user interface in 
 * snd-xmain, snd-xsnd, and snd-xchn.  Except for tempnam, the DAC stuff in snd-dac, and 
 * open/read (I like unbuffered IO), all the code is (or is thought to be) straight ANSI C.
 *
 *
 * On the SGI:
 * if you want to use SGI's enhanced widgets and 'schemes', use this sequence in the makefile:
 *
 *              -laudio -lSgw -lSgm -lXmu -lXm -lXt -lX11 -lPW -lc -lm -ly
 *
 * then make a file named Snd on your home directory, and insert:
 *
*sgiMode:        true
*useSchemes:     all
*scheme:         Base
 *
 * or whatever scheme you want.  Then, in a shell
 * 
xrdb -load Snd
 * 
 * Snd-specific resources are lightestcolor, basiccolor, darkcolor, darkestcolor, textcolor, 
 *                            boldbuttonFont, buttonFont, axisLabelFont, axisNumbersFont, cursorcolor,
 *                            selectioncolor, initFile, epsFile, backupFile, defaultOutputType
 * see Snd.ad for an app-defaults file setting these to their default values.
 */

#include "snd.h"
/* #include <locale.h> */

#ifdef SGI
  #include <sys/fpu.h>
#endif

void main (int argc, char **argv)
{
  snd_state *state;                      /* global state info, carried around via callData arg in callbacks */
  /* there are also 2 global variables -- 
   *    snd_IO_error which parallels C's errno, 
   *    snd_search_fd which provides global access to the current active data.
   */
  int links[LINK_TABLE_SIZE];            /* fire up clm library (headers.c, io.c) */
#ifdef SGI
  union fpc_csr f; f.fc_word = get_fpc_csr(); f.fc_struct.flush = 1; set_fpc_csr(f.fc_word);
#endif
  create_header_buffer(links);
  create_descriptors (links);
  init_regions();
  /* if (setlocale(LC_ALL,"") == NULL) setlocale(LC_ALL,"C"); */
  /* apparently handled in Xt toolkit via XtSetLanguageProc (snd-xmain.c) */
  /* in Linux with Metrolink Motif 2.0, there's XLocale.h but do I need it? */
  
  state=(snd_state *)calloc(1,sizeof(snd_state));
  state->s_type = make_snd_pointer_type(SND_STATE);
  state->global_fft_size = 256;
  state->global_fft_window = default_fft_window(NULL);
  state->subsampling = 1;
  state->graph_style = graph_lines;
  state->selected_sound = NO_SELECTION;
  state->peaking = 0;
  state->dBing = 0;
  state->logxing = 0;
  state->viewing = 0;
  state->zero_visible = 0;
  state->marks_visible = 0;
  state->from_clm = 0;
  state->to_clm = 0;
  state->mx_sp = NULL;
  state->editor_line_size = 128;
  state->fft_style = normal_fft;
  state->reverb_decay = 1.0;             /* secs */
  state->max_sounds = 4;                 /* expands to accomodate any number of files */
  state->sounds = (snd_info **)calloc(state->max_sounds,sizeof(snd_info *));
  state->default_output_type = DEFAULT_OUTPUT_TYPE;
  state->remember_state = 0;
  state->pending_open = NULL;
  state->auto_open = 1;
  state->fit_data = -1;
  state->global_combining = 0;
  state->dot_size = 1;
  state->wavo = 0;
  state->zoom_focus_anchor = FOCUS_ACTIVE;
  state->temp_dir = NULL;
  state->ask_before_overwrite = 0;
  reset_spectro(state);
  state->session_name = NULL;
  state->consoling = 1;
  snd_IO_error = snd_no_error;
  snd_doit(state,argc,argv);
}

/* snd change log
 *
 * 14-Mar:   scale-by, scale-to, amp-envelope, with selection cases added. More header types.
 * 1-Mar:    data command for clm through-snd.
 * 24-Feb:   Next switches, sessions, ufun action lists, more linux bugs.
 * 17-Feb:   file browser (view files) added.
 * 12-Feb:   save-as dialog improved
 * 10-Feb:   view color and orientation menu options, with associated color variables.
 * 31-Jan:   file-loadable filter/envelopes.
 * 27-Jan:   1+1 where i+1 intended in spectrum!
 * 24-Jan:   memory leaks and other bugs
 * 20-Jan:   improved spectrogram rotation, added keypad keymap, wavogram.
 * 17-Jan:   dot-size. 'unite' button and Combine channels menu option. zoom focus choices (option menu).
 * 8-Jan-97: fixed bug in fft peak calculation. Save-As in Edit menu improved.
 * ---------
 * 30-Dec:   clm display hooks.
 * 23-Dec:   amp env improved.
 * 18-Dec:   new file option smarter, spectrogram improved.
 * 16-Dec:   more clm-snd connections, peaks command.
 * 9-Dec:    added Info menu option, save-marks.  More Linux bugs fixed.
 * 4-Dec:    Linux fixups (XmCreateMessageDialog -> bad drawable)
 * 20-Nov:   clm marks, fixed several apply and aiff header bugs
 * 24-Oct:   more Linux changes
 * 18-Oct:   Linux port. added (info), c-X c-V
 * 30-Sep:   added snd-trans.c
 * 17-Sep:   better support for schemes, cross disk saves
 * 9-Sep-96: launched!
 */
