/*                      Copyright (c) 1992,1993 Bellcore
 *                            All Rights Reserved
 *       Permission is granted to copy or use this program, EXCEPT that it
 *       may not be sold for profit, the copyright notice must be reproduced
 *       on copies, and credit should be given to Bellcore where it is due.
 *       BELLCORE MAKES NO WARRANTY AND ACCEPTS NO LIABILITY FOR THIS PROGRAM.
 */

/* am modulate a sine wave - test program (SAU) */

#include <sys/time.h>
#include <math.h>
#include <stdio.h>
#include "audio.h"

#define RECURSE(c,n1,n2,out) (\
	out = n1, out = n2, \
	n1 = c*n2 - n1, \
	n2 = c*n1 - n2 )

#define ssleep() \
   { \
   struct timeval time; \
   time.tv_sec = 0; \
   time.tv_usec = 50000; \
   select(0,0,0,0,&time); \
   }

#define LOOP8(x) x;x;x;x;x;x;x;x
#define MPS		400.0				/* modulation sampling rate */
#define HUNK	800				/* hunk size (divisible by 16?) */

double buff[HUNK];
double buff2[HUNK];

char line[100] = "440.0 6.0 10";
main(argc,argv)
int argc;
char **argv;
	{
	char *getenv();
	static int init = 1;
	double c, n1, n2;		/* promary recursion */
	double dc, m1, m2;		/* modulation */	
	double x;					/* modulated recursion coefficient */
	double *out = buff;
	double *out2 = buff2;
	double f1=440.0, f2=6.0 ,a=5.0;			/* input parameters */
	int n;
	int start = 0;
	int q;
	int fd=0;
	int wrote;
	printf("Starting\n"); fflush(stdout);

	while (1) {
		if (wait_read(0,line,sizeof(line)) > 0) {
			fprintf(stderr,"Got %s\n",line);
			if (*line == '+' && start==0)  {
				start++;
				fd = open("/dev/audio",1);
				wrote=0;
				}
			if (*line == '-' && start) {
				start=0;
				close(fd);
				}
			if (*line == 'Q') exit(0);
			if (sscanf(line,"%lf %lf %lf",&f1,&f2,&a) != 3) continue;
			if (f1 < 100.0 || f2 > f1/2.0 || a > 500.0) continue;
			if (f2 > 0.01) f2 /= 5.0;
			c =  2.0 * cos(2.0 * M_PI * f1 / SPS);
			n1 = 0.0;
			n2 = sin(2.0 * M_PI * f1 / SPS);

			dc = 2 * cos( 2 * M_PI * (f1+f2) / SPS);
			m1 = 0;
			m2 = (a/100.0) * sin(2.0 * M_PI * (f1+f2) / SPS);
			}
			
		if (start == 0) {
			ssleep();continue;
			}
			
		if ((q=wrote - audio_wrote(fd)) > 1200) {
			/* fprintf(stderr,"Skipping (%d)\n",q); */
			ssleep();
			continue;
			}

		for(out=buff,out2=buff2,n=400;n>0;n--) {
			RECURSE(c,n1,n2,*out++);	
			RECURSE(dc,m1,m2,*out2++);
			}	
		/* fprintf(stderr,"Outing\n"); */
		output(fd,buff,buff2,800);							/* output data */
		wrote += 800;
		}
	}

char ulaw[HUNK];

output(fd,x,y,n)
int fd;
double *x, *y;										/* data to output */
int n;												/* number of items */
	{
	char *s = ulaw;
	int sample;
	int count = n;
	while (n-- > 0) {
		sample = (*x++ + *y++) * 1000;
		*s++ = Ub2i[(B13ZERO + sample) & B13MAX]; 
		}
	write(fd,ulaw,count);
	}

/* return # of samples written */

int
audio_wrote(fd)
int fd;
   {
   int n;
   struct audio_info info;

   n = ioctl(fd,AUDIO_GETINFO,&info);
	if (n<0)
		return(-1);
	else
		return(info.play.samples);
   }

/* read from fd non blocking */

int
wait_read(fd,buff,n)
int fd;			/* file descriptor to read from */
char *buff;		/* read into here */
int n;			/* max # to read */
	{
	int mask = 1<<fd;
	int cnt=0;
   struct timeval time;
   time.tv_sec = 0;
   time.tv_usec = 0;

	if (select(32,&mask,0,0,&time)==1) {
		cnt = read(fd, buff, n);
		}
	return(cnt);
	}
