#!/bin/wish -f
# sample AM modulation stuff

#                      Copyright (c) 1992,1993 Bellcore
#                            All Rights Reserved
#       Permission is granted to copy or use this program, EXCEPT that it
#       may not be sold for profit, the copyright notice must be reproduced
#       on copies, and credit should be given to Bellcore where it is due.
#       BELLCORE MAKES NO WARRANTY AND ACCEPTS NO LIABILITY FOR THIS PROGRAM.

set am ./am

set command ""

proc poke {} {
	global f1 f2 a command control msg

   set new "$f1 $f2 $a"
	if {"$new" != "$command" && $msg == "running" } {
		set command "$new"
		puts $control "$command"
		flush $control
		}
	after 200 poke
	}

proc do {s} {
	global control
	puts $control "$s"
	flush $control
	}

set l 250
wm title . "AM modulated sine wave"
frame .top
button .top.start -text "start" -relief raised -command \
	{do +;set msg running}
button .top.stop -text  "stop" -relief raised -command \
	{do -;set msg stopped}
button .top.quit -text  "quit" -relief raised -command {do Q; destroy .}
pack append .top \
		.top.start {left fillx expand} \
		.top.stop {left fillx expand} \
		.top.quit {left fillx expand}

scale .1 -orient horiz -length $l -to 3000 -from 100 -command "set f1" -label "Frequency"
scale .2 -orient horiz -length $l -to 30 -from 1 -command "set f2" -label "modulation rate"
scale .3 -orient horiz -length $l -to 100 -from 0 -command "set a" -label "modulation intensity"
.1 set 440; .2 set 6; .3 set 10

label .bottom -textvariable msg -text "waiting for audio to open"

pack append . .top {top fillx} .1 {top} .2 {top} .3 {top} .bottom {bottom}
bind . <Control-c> {puts $control Q; destroy .}
#set control [open /dev/console w]

set control [open |$am "r+"]
puts stderr STARTING
after 300
gets $control foo
set msg "Stopped"
poke
