/*                      Copyright (c) 1992,1993 Bellcore
 *                            All Rights Reserved
 *       Permission is granted to copy or use this program, EXCEPT that it
 *       may not be sold for profit, the copyright notice must be reproduced
 *       on copies, and credit should be given to Bellcore where it is due.
 *       BELLCORE MAKES NO WARRANTY AND ACCEPTS NO LIABILITY FOR THIS PROGRAM.
 */

/* run an audio signal through a band pass filter (S A UHLER) */

#include <sys/time.h>
#include <math.h>
#include <stdio.h>
#include "audio.h"
#include "bpf.h"

#define ssleep() \
   { \
   struct timeval time; \
   time.tv_sec = 0; \
   time.tv_usec = 50000; \
   select(0,0,0,0,&time); \
   }

#define HUNK	1000				/* hunk size */

double in_b[HUNK+2];					/* unput buffer */
double out_b[HUNK+2];					/* output buffer */
char line[100];
static char plot[2048];

main(argc,argv)
int argc;
char **argv;
	{
	char *getenv();
	struct filt_coef coef_data, *coef = &coef_data;
	int n;					/* # of elements in current hunk */
	int x,y;					/* plot scaling factors */
	int ok = 0;
	double fc,f3;			/* filter center frequency and 3-db point */
	int start = 0;			/* true iff running */
	int out_fd=0;			/* output fd */
	int in_fd=0;			/* input fd */
	char *result="start";		/* command result (if error) */
	double *in = &in_b[2];		/* input buffer */
	double *out = &out_b[2];	/* output buffer */
	double gain = 1.0;			/* overal gain multiplier */
	int wrote;						/* number of bytes written */

	x = y = 100;
	printf("READY\n"); fflush(stdout);
	while (1) {
		if (wait_read(0,line,sizeof(line)) > 0) {
			line[strlen(line)-1] = '\0';
			result = "x";
			switch(*line) {
				case '+':			/* start output */
					if (start==0 && in_fd >0 && ok)  {
						start++;
						out_fd = open("/dev/audio",1);
						result="starting";
						wrote=0;
						}
					break;
				case '-':			/* stop output */
					if (start) {
						start=0;
						result="stopping";
						close(out_fd);
						}
					break;
				case 'F':			/* new input file */
					if (in_fd>0) close(in_fd);
					if(line[2]) in_fd = open(line+1,0);
					result = in_fd>0 ? "opened file" : "bad file";
					break;
				case 'Q':			/* quit */
					exit(0);
					break;
				case 'S':			/* plotting scale factors */
					if (sscanf(line+1,"%d %d",&x,&y) < 2) continue;
					result = "setting response scale";
					break;
				case 'B':			/* band pass filter coef's */
					gain=0.0;
					if (sscanf(line+1,"%lf %lf %lf ",&fc,&f3,&gain) < 2) continue;
					ok++;
					bpf(coef,fc,f3,8000.0);
					fprintf(stderr,"b1=%f, b2=%f, k=%f\n",
						coef->b1, coef->b2, coef->k);
					sprintf(line,"k=%.3f b1=%.3f b2=%.3f",
								coef->k,coef->b1,coef->b2);
					if (gain > 1.0)
						coef->k *= gain;
					get_plot(coef,fc,x,y-24);
					result=plot;
					break;
				}
			printf("%s\n",result); fflush(stdout);
			bzero(line,sizeof(line));
			}
			
		if (start == 0) {
			ssleep();continue;
			}
			
		if (wrote - audio_wrote(out_fd) > 1200) {
			ssleep();
			continue;
			}

		n = input(in_fd,in,HUNK);
		if (n <=0) {
			start = 0;
			close(out_fd);
			result = "EOF";
			}
		else
			{
			do_bpf(coef, in, out, n);
			output(out_fd,out,n);							/* output data */
			in[-2] = in[n-2];
			in[-1] = in[n-1];
			out[-2] = out[n-2];
			out[-1] = out[n-1];
			wrote += n;
			}
		}
	}

char ulaw[HUNK];

output(fd,x,n)
int fd;
double *x;											/* data to output */
int n;												/* number of items */
	{
	char *s = ulaw;
	int sample;
	int count = n;
	while (n-- > 0) {
		sample = *x++;
		*s++ = Ub2i[(B13ZERO + sample) & B13MAX]; 
		}
	write(fd,ulaw,count);
	}

/* return # of samples written */

int
audio_wrote(fd)
int fd;
   {
   int n;
   struct audio_info info;

   n = ioctl(fd,AUDIO_GETINFO,&info);
	if (n<0)
		return(-1);
	else
		return(info.play.samples);
   }

/* read from fd non blocking */

int
wait_read(fd,buff,n)
int fd;			/* file descriptor to read from */
char *buff;		/* read into here */
int n;			/* max # to read */
	{
	int mask = 1<<fd;
	int cnt=0;
   struct timeval time;
   time.tv_sec = 0;
   time.tv_usec = 0;

	if (select(32,&mask,0,0,&time)==1) {
		cnt = read(fd, buff, n);
		}
	return(cnt);
	}

int
do_bpf(coef, in, out, count)
struct filt_coef *coef;		/* the filter coef's */
register double *in, *out;	/* the input and output queues */
int count;						/* # of samples */
	{
	register double b1 = coef->b1;
	register double b2 = coef->b2;
	register double k  = coef->k;
	register double *end;

	for(end=in+count;in<end;out++,in++)
		out[0] = k * (in[0] - in[-2]) - (b1*out[-1] + b2*out[-2]);
	return(1);
	}


static unsigned char mu_law[HUNK];

int
input(fd,in,n)
int fd;		/* fd to read from */
double *in;		/* where to put the result */
int n;		/* number to read */
	{
	double *end = in + n;
	unsigned char *m = mu_law;

	if (fd <=0) return(0);
	n = read(fd,mu_law,n);
	
	while(in < end)
		*in++ = I2sb[*m++];
	return(n);
	}

#define W(f) (2.0 * M_PI * (f) / 8000.0)

get_plot(coef,fc,x,y)
struct filt_coef *coef;		/* filter coef's */
double fc;						/* center frequency */
int x,y;							/* plot scaling */
	{
	double resp();
	double f;
	int n = 0;
	plot[0] = 'P';
	plot[2] = '\0';

	for(f=0;f<4000;f+=40) {
		if (f>fc && n==0) {
			n++;
			sprintf(plot+strlen(plot)," %.0f %.3f",
					(f-10)*x/4000,20+y*(1-resp(coef,W(f-5),0)));
			sprintf(plot+strlen(plot)," %.0f %.3f",
					f*x/4000,20+y*(1-resp(coef,W(f),0)));
			sprintf(plot+strlen(plot)," %.0f %.3f",
					(f+10)*x/4000,20+y*(1-resp(coef,W(f+5),0)));
			}
		sprintf(plot+strlen(plot)," %.0f %.3f",
					f*x/4000,20+y*(1-resp(coef,W(f),0)));
		}
	sprintf(plot+strlen(plot)," %d %d", x,20+y);
	}
