/*                      Copyright (c) 1992,1993 Bellcore
 *                            All Rights Reserved
 *       Permission is granted to copy or use this program, EXCEPT that it
 *       may not be sold for profit, the copyright notice must be reproduced
 *       on copies, and credit should be given to Bellcore where it is due.
 *       BELLCORE MAKES NO WARRANTY AND ACCEPTS NO LIABILITY FOR THIS PROGRAM.
 */

/* parse a command line, set appropriate parameters  (SAU) */

#include <stdio.h>
#include "synth.h"
#include "reverb.h"

static struct  reverb_params rp[4] = {	/* temporary */
	0,0, 0,0, 0,0, 0,0
	};

char *
parse_command(params,voice,line)
struct params *params;	/* current performance parameters */
struct voice voice[];	/* set of voice parameters */
char *line;					/* command line to parse */
	{
	int new;		/* new value */
	int i;
	char *start;	/* pointer to command code */
	char *end;		/* pointer to next field (if any) */
	char *value;	/* pointer to value (if any) */
	int partial=0;		/* which partial (none by default) */
	int voice_num=0;	/* which voice (none by default) */
	int filter=0;		/* overall response filter # */
	static char msg[MAXLINE];	/* error message (if any) */

	/* strip off '\n' */

	if (end=index(line,'\n'))
		*end = '\0';
	*msg = '\0';

	for(start=line;start;start=end) {
		end = index(start,';');
		if (end) *end++ = '\0';
		if (value=index(start,'=')) *value++ = '\0';
		dprintf('P')(stderr," Command=[%s]value=[%s]\n",
				start,value?value:"(NONE)");
		while(*start && ISWHITE(*start))		/* skip leading white space */
			start++;
		switch (*start) {
			case '#':	/* comment, skip it */
				dprintf('p')(stderr,"%s\n",start);
				break;
			case 'D':	/* change the debugging flags */
				strcpy(debug_list,value);
				break;
			case '?':	/* send back parameters */
				if (filter) {
					if (!P(shape))	/* this can't happen */
						sprintf(msg,"No response curved entered\n");
					else
						sprintf(msg,"filter=%d %.1f %.1f %.1f",filter,
							P(shape)[filter-1].peak, P(shape)[filter-1].width,
							P(shape)[filter-1].gain);
					break;
					}
				if (!voice_num) {	/* main parameters only */
					sprintf(msg,"Tempo=%d; trans=%d; gain=%d; legato=%d; intensity=%d; mask=0x%x; hunk=%d",
						P(tempo),P(trans),P(gain),P(duration),
						P(factor),P(mask),P(hunk));
					}
				else if (!partial) {	/* main voice parameters */
					sprintf(msg,"voice=%d; cutoff=%d; stretch=%d",
						voice_num,
						voice[voice_num-1].cutoff,voice[voice_num-1].stretch);
					}
				else {					/* partial # */
					sprintf(msg,"voice=%d; partial=%d; weight=%d; damping=%d",
						voice_num, partial,
						voice[voice_num-1].weights[partial-1].weight,
						voice[voice_num-1].weights[partial-1].damping);
					}
				break;
			case 'A':	/* set Alaw/Mulaw */
				if (value && atoi(value))
					P(state) |= ALAW;	/* set alaw mode */
				else
					P(state) &= ~ALAW;	/* UNset alaw mode */
				dprintf('p')(stderr,"Changing Alaw to %s\n",
						P(state)&ALAW ? "ON":"OFF");
				break;
			case 'i':	/* adjust the velocity intensity factor */
				if (!value) break;
				new=atoi(value);
				P(factor)=BETWEEN(0,new,10);
				dprintf('p')(stderr,"Changing vel. fctr. to %d\n",P(factor));
				break;
			case 'g':	/* adjust the gain */
				if (!value) break;
				new=1<<(atoi(value));
				P(gain)=BETWEEN(1,new,4100);
				dprintf('p')(stderr,"Changing gain to %d\n",P(gain));
				break;
			case 'p':	/* Change a partial number */
				if (!value) break;
				partial = BETWEEN(1,atoi(value),10);
				dprintf('p')(stderr,"Changing partial # to %d\n",partial);
				break;
			case 'f':	/* Change overall response (temporary) */
				if (!value) break;
				new = atoi(value);
				filter = BETWEEN(1,new,5);
				dprintf('p')(stderr,"Changing filter number %d\n",filter);

				/* fill in the parameters: fx,fd,g: */
					{
					int n;
					double fc,fd,g;
					n = sscanf(value,"%*s %lf %lf %lf",&fc,&fd,&g);
					if (n != 3)
						break;
					if (!P(shape)) {
						P(shape) = (struct shape *) malloc(sizeof (struct shape) * 5);
						bzero(P(shape),sizeof(struct shape) * 5);
						}
					P(shape)[filter-1].peak = fc;
					P(shape)[filter-1].width = fd;
					P(shape)[filter-1].gain = g;
					}

				P(state) |= RESPONSE;	/* set voice resp recalc flag */
				if (voice_num)
					P(voice) |= 1<<(voice_num-1);
				else
					P(voice) |= P(mask);

				break;
			case 'v':	/* Change a voice number */
				if (!value) break;
				voice_num = 0xF&atoi(value);
				P(state) |= NEW_VOICE;	/* set voice recalc flag */
				P(voice) |= 1<<(voice_num-1);
				dprintf('p')(stderr,"Changing voice number %d\n",voice_num);
				break;
			case 'l':	/* adjust the note duration (legato setting) */
				if (!value) break;
				new=atoi(value);
				P(duration)=BETWEEN(10,new,300);
				dprintf('p')(stderr,"Changing legato to %d\n",P(duration));
				break;
			case 'M':	/* mix in an auxilliary signal */
				if (P(aux_fd)>0)  {
					close(P(aux_fd));
					P(aux_fd) = -1;
					}
				if (value) {
					P(aux_fd) = open(value,0);
					fprintf(stderr,"Opening aux file %s code %d\n",value,P(aux_fd));
					}
				break;
			case 'm':	/* set the channel mask */
				if (value)
					P(mask) = strtol(value, NULL, 16);
				else
					P(mask) = 0xFFFF;
				dprintf('p')(stderr,"Changing mask to 0x%.4x\n",P(mask));
				break;
			case 'z':	/* adjust the tuning */
				if (value)
					P(tuning) = atoi(value);
				else 
					P(tuning) = 0;
				dprintf('p')(stderr,"Changing tuning. to %d\n",P(tuning));
				P(state) |= NEW_VOICE;	/* set voice recalc flag */
				P(voice) |= 0xffff;
				break;
			case 't':	/* adjust the transposition */
				if (!value) break;
				new=atoi(value);
				P(trans)=BETWEEN(-24,new,24);
				dprintf('p')(stderr,"Changing trans. to %d\n",P(trans));
				break;
			case 'T':	/* adjust the tempo */
				if (!value) break;
				P(old) = P(tempo);
				new=atoi(value);
				P(tempo)=BETWEEN(20,new,240);
				P(state) |= NEW_TEMPO;
				dprintf('p')(stderr,"Changing tempo to %d\n",P(tempo));
				break;
			case 'r':	/* adjust reverberation parameters (temporary) */
				if (value) {
					sscanf(value,"%d %d %d %d %d %d",
						&rp[0].delay, &rp[0].gain,
						&rp[1].delay, &rp[1].gain,
						&rp[2].delay, &rp[2].gain);
					if (!P(reverb_params))
						P(reverb_params) = reverb_init(rp);
					dprintf('p')(stderr,"setting reverb parameters\n");
					}
				else if (P(reverb_params)) {
					reverb_free(P(reverb_params));
					dprintf('p')(stderr,"Clearing reverb parameters\n");
					P(reverb_params) = NULL;
					}
				break;
			case 'd':	/* adjust the partial damping */
				if (value && voice_num && partial) {
					voice[voice_num-1].weights[partial-1].partial = partial-1;
					voice[voice_num-1].weights[partial-1].damping =
							 BETWEEN(0,atoi(value),100);
					dprintf('p')(stderr,"Changing damping %d, partial %d to %d\n",
							voice_num,partial,atoi(value));
					}
				break;
			case 'w':	/* adjust the partial weight */
				if (value && voice_num && partial) {
					voice[voice_num-1].weights[partial-1].partial = partial-1;
					voice[voice_num-1].weights[partial-1].weight =
							 BETWEEN(0,atoi(value),100);
					dprintf('p')(stderr,"Changing weight %d, partial %d to %d\n",
							voice_num,partial,atoi(value));
					}
				break;
			case 's':	/* adjust the harmonic stretch */
				if (value && voice_num) {
					voice[voice_num-1].stretch = BETWEEN(-100,atoi(value),100);
					dprintf('p')(stderr,"Changing stretch %d, to %d\n",
							voice_num,atoi(value));
					}
				break;
			case 'c':	/* adjust the cutoff frequency */
				if (value && voice_num) {
					voice[voice_num-1].cutoff = BETWEEN(200,atoi(value),4000);
					dprintf('p')(stderr,"Changing cutoff %d, to %d\n",
							voice_num,atoi(value));
					}
				break;
			case 'h':	/* adjust the hunk size (same as kernel Q size) */
				if (!value) break;
				new=atoi(value);
				P(hunk)=BETWEEN(800,new,MAXBUFF);
				dprintf('p')(stderr,"Changing hunk # to %d\n",P(hunk));
				break;
			case '+':	/* start */
				if (P(file)) {
					P(state) |= RUNNING;
					}
				else
					strcat(msg,"No file to start");
				break;
			case '-':	/* stop */
				P(state) &= ~RUNNING;
				break;
			case 'F': 	/* get a new file (rewind if no file) */
				if (!value && P(file)) {	/* rewind */
					rewind(P(file));
					P(state) |= RESTART;
					break;
					}
				if (P(file))
					fclose(P(file));
				P(file) = fopen(value,"r");
				if (!P(file) && P(state)&RUNNING) {
					P(state) &= ~RUNNING;
					}
				dprintf('m')(stderr,"new file %sOK\n",P(file)?"":"NOT ");
				P(state) |= RESTART;
				if (P(file))
					strcat(msg,value);
				else
					strcat(msg,"No such file");
				break;
			case 'Q':	/* quit */
				printf("Q\n"); fflush(stdout);
				exit(0);	/* we could clean up better */
				break;
			}
		}
	return(msg);
	}
