/*                      Copyright (c) 1992,1993 Bellcore
 *                            All Rights Reserved
 *       Permission is granted to copy or use this program, EXCEPT that it
 *       may not be sold for profit, the copyright notice must be reproduced
 *       on copies, and credit should be given to Bellcore where it is due.
 *       BELLCORE MAKES NO WARRANTY AND ACCEPTS NO LIABILITY FOR THIS PROGRAM.
 */

/* add reverb to an audio stream (This is very broken - SAU) */

#include <malloc.h>
#include <stdio.h>
#include <reverb.h>

#define dprintf	if (debug) fprintf

static int debug = 0;

/* private list of samples */

static struct reverb_list {
	int id;			/* id of this sample (for debugging) */
	int count;		/* number of samples */
	float *data;	/* data in samples */
	struct reverb_list *next;	/* item in the list */
	};

/* private reverb structure */

static struct reverb {
	int count;					/* total # of samples in this list */
	int max_count;				/* total number of samples needed in this list */
	struct reverb_params *delays;	/* list of delays (in sorted order) */
	struct reverb_list *list;	/* list of saved samples */
	};

static int del_list();
add_list();

/* initialize a reverb structure */

char *
reverb_init(list)
struct reverb_params *list;	/* list of reverb parameters */
	{
	struct reverb *reverb;

	debug = getenv("DEBUG");
	reverb = (struct reverb *) malloc(sizeof (struct reverb));
	reverb->count = 0;
	reverb->delays = list;
	reverb->list = NULL;
	
	return((char *)reverb);
	}

/* free a reverb parameter list */

int
reverb_free(params)
char *params;
	{
	struct reverb  *reverb = (struct reverb *) params;
	struct reverb_list *list;

	if (!reverb)
		return(0);
	if (reverb->list) {
		del_list(reverb->list);
		free(reverb->list->data);
		free(reverb->list);
		}
	free(reverb);
	return(1);
	}

/*
 * Add reverb to a sample buffer. 
 */

int
reverb(params,in,out,count)
char *params;		/* cookie of reverb parameters */
float *in;			/* input buffer */
float *out;			/* output buffer */
int count;			/* count of items */
	{
	struct reverb *reverb = (struct reverb *) params;
	struct reverb_params *delays;
	struct reverb_list *list;	/* history list */
	struct reverb_list *end = NULL;	/* past end of list, removable */
	int current = 0;	/* current historical sample count */
	float *to;			/* next sample in out to sum */
	float *from;		/* next sample in history list */
	int offset;			/* offset into history item */

	if (!reverb)
		return(0);
	list = reverb->list;

	/* add reverb to input samples */

	if (in != out)
		bcopy(in,out,count*sizeof(*in));
	add_list(reverb,out,count);

	for(delays = reverb->delays;delays->delay;delays++) {
		dprintf(stderr,"Doing delay %d, gain %d\n",delays->delay,delays->gain);
		to = out;
		for(list=reverb->list;list;list=list->next) {
			dprintf(stderr,"  %d: %d->%d (need %d->%d)\n",
						list->id,current,current+list->count,
						delays->delay, delays->delay+count);
			current += list->count;
			if (delays->delay > current) {		/* too soon */
				dprintf(stderr,"    Skipping - too soon\n");
				continue;
				}
			if (delays->delay+count < current-count) {		/* too late */
				end = list;
				dprintf(stderr,"    Skipping - too late\n");
				break;
				}
			offset = list->count - (current - delays->delay);
			if (offset < 0) offset = 0;
			dprintf(stderr,"  Copy starting with byte offset %d/%d\n",
						offset,list->count);
			from = list->data + offset;
			
			while(to < out+count && from < list->data + list->count) {
				*to++ += *from++ * delays->gain / 1000.0;
				}
			if (to == out+count) {
				break;
				}
			}
		}

	bcopy(out,reverb->list->data,count*sizeof(*out));
	if (list) del_list(list); /* remove used up history items */
	return(1);
	}

/* delete every item past END */

static int
del_list(end)
struct reverb_list *end;
	{
	if (end && end->next) {
		del_list(end->next);
		dprintf(stderr,"Deleting id %d\n",end->id);
		free(end->next->data);
		free(end->next);
		end->next = NULL;
		}
	}

/* add a buffer of samples to the history list */

static int
add_list(reverb,out,count)
struct reverb *reverb;
float *out;						/* data to add to the list */
int count;						/* size of out */
	{
	struct reverb_list *list;
	float *data;
	static id = 1;		/* id counter */

	dprintf(stderr,"Creating id %d, %d bytes\n",id,count);
	list = (struct reverb_list *) malloc(sizeof(*list));
	data = (float *) malloc(sizeof(float) * count);
	list -> next = reverb -> list;
	list -> count = count;
	list -> data = data;
	bcopy(out,list->data,count * sizeof(*out));
	list->id = id++;
	reverb->list = list;
	return(1);
	}

/* test out this mess */

#ifdef MAIN

/* read mu-law on standard input, add reverb, and dump on stdout */

#define HUNK 1000

float in[HUNK], out[HUNK];
char mu[HUNK];
double atof();

main(argc,argv)
int argc;
char **argv;
	{
	struct reverb_params *data, *p;
	char *cookie;
	int n;
	float gain=.5;		/* overall gain */
	int xtra = 4000;	/* end of file reverb time */

	while (argv[1][0] == '-') {
		switch (argv[1][1]) {
			case 'g':		/* overall gain */
				gain = atof(argv[2]);
				fprintf(stderr,"Setting overall gain to %f\n",gain);
				break;
			case 'x':		/* extra reverb time */
				xtra = atoi(argv[2]);
				fprintf(stderr,"Setting end of file decay to %d\n",xtra);
				break;
			}
		argv+=2, argc-=2;
		}

	if ((argc&1) == 0) {
		fprintf(stderr,"usage: %s delay gain [delay gain]...\n",*argv);
		exit(0);
		}

	debug = getenv("DEBUG");
	p = data = (struct reverb_params *) malloc((argc+1)/2 * sizeof(*data));
	while(argc > 1) {
		p->delay = atoi(argv[1]);
		p->gain  = atoi(argv[2]);
		dprintf(stderr,"setting %d,%d\n",p->delay,p->gain);
		p++, argv+=2, argc-=2;
		}
	p->delay = 0;

	/* set up the delay line */

	cookie = reverb_init(data);

	/* do the work */

	while((n=read(0,mu,HUNK)) > 0) {
		to_float(mu,in,n);
/*
		reverb(cookie,in,out,n);
		to_mu(out,mu,n);
*/
		reverb(cookie,in,in,n);
		to_mu(in,mu,n);
		write(1,mu,n);
		}

	/* end the file gracefully */

	for(n=0;n<HUNK;n++) in[n] = 0.0;
	while(xtra>0) {
		n = xtra>=HUNK ? HUNK:xtra;
		reverb(cookie,in,out,n);
		to_mu(out,mu,n);
		write(1,mu,n);
		xtra -= n;
		}
	}

extern short I2sb[];
extern unsigned char Ub2i[];

int
to_float(in,out,count)
unsigned char *in;	/* mu law input */
float *out;	/* float output */
int count;	/* # of samples */
	{
	unsigned char *end = in + count;

	while(in < end)
		*out++ = I2sb[*in++];
	}

int
to_mu(in,out,count)
float *in;	/* fp input */
char *out;	/* mu law output */
int count;	/* number of samples */
	{
	float *end = in + count;
	unsigned char *cnvt = Ub2i+0x1000;
	register int sample;
	int clip = 0;

	while(in < end)  {
		sample = *in++/2.0;
		if (sample < -4010 || sample > 4010)  {	/* for testing */
			sample = sample>0 ? 4000 : -4000;
			clip++;
			}
		*out++ = cnvt[sample];
		if (clip) fprintf(stderr,"Clip %d/%d\n",clip,count);
		}
	}
#endif
