/*                      Copyright (c) 1992,1993 Bellcore
 *                            All Rights Reserved
 *       Permission is granted to copy or use this program, EXCEPT that it
 *       may not be sold for profit, the copyright notice must be reproduced
 *       on copies, and credit should be given to Bellcore where it is due.
 *       BELLCORE MAKES NO WARRANTY AND ACCEPTS NO LIABILITY FOR THIS PROGRAM.
 */

/* structures used in MPU-SPARC synthesizer */

/* short sleep: units in samples */

#define ssleep(samples) \
   { \
	if (samples > 0) { \
      struct timeval _time; \
      _time.tv_sec = (samples)/8000; \
      _time.tv_usec = ((samples)%8000)*1000/8; \
       select(0,0,0,0,&_time); \
       } \
   }

/* this is the type for each sample.  Either floating point or integers will
 * do, synth doesn't care
 */

typedef float data;

/* data for each note */

struct note {
	int chan;	/* which midi channel */
	int key;		/* which midi note # */
	int vel;		/* note velocity */
	long start;	/* starting time */
	long stop;	/* ending time */
	data *data;	/* pointer to rendered data */
	int id;		/* note id (for debugging) */
	struct note *next;	/* pointer to next note */
	};

/* define the "to_audio" state */

struct audio_state {
	int current;	/* next outputtable sample */
	int done;		/* next sample to be output */
	int now;			/* current time in file */
	int offset;		/* time offset for tempo changes */
	int id;			/* note id */
	int no_notes;	/* no more notes */
	struct note *list;
	};

/* parameters to define each partial */

struct part {
	int partial;		/* partial number (0 is fundamental) */
	int weight;			/* partial weight (0-100) */
	int damping;		/* damping rate   (0-100) */
	};
	
/* describe overall response shape of an instrument (preliminary) */

struct shape {
	double peak;			/* frequency of peak in response curve */
	double width;			/* frequence with ad 3-db point */
	double gain;			/* maximum gain at peak */
	};

/* data to define channel characteristics */

struct voice {		/* channel instrument characteristics */
	int id;				/* voice id (for debugging) */
	int cutoff;			/* cutoff frequency (hz) */
	int stretch;		/* variance from harmonic in % */
	struct part *weights;	/* partial weightings */
	struct shape *shape;		/* pointer to pre-voice reponse characteristics */
	};

/* parameters that can change during a performance */

struct params {
	int aux_fd;		/* fd for auxilliary input file */
	FILE *file;		/* file to read midi commands from */
	int gain;		/* gain factor (%) */
	int tempo;		/* tempo (bpm) */
	int old;			/* old tempo (bpm) */
	int trans;		/* transposition (in semi-tones) */
	int duration;	/* note duration (%) */ 
	int factor;		/* velocity factor (0-10) */
	int tuning;		/* which tuning */
	int hunk;		/* bytes spit-out at each iteration */
	int verbose;	/* generate verbose information */
	int state;		/* state flags (defined below) */
	int max_samples;	/* max number of samples in a note */
	int channels;	/* channels used since previous query */
	int mask;	/* valid channels */
	int voice;		/* which voice to change */
	struct shape *shape;	/* pointer to overall reponse characteristics */
	char *reverb_params;	/* reverberation parameters */
	};

/* state flags (preliminary) */

#define RUNNING		1		/* performance is stopped */
#define RESTART		2		/* restart from scratch on a new file */
#define NEW_TEMPO		4		/* start a new tempo */
#define NEW_VOICE		8		/* start a new voice */
#define CLIPPED		16		/* clipping occurred */
#define RESPONSE		32		/* got a new overall response curve */
#define ALAW			64		/* using alaw instead of mu-law */

/* debugging stuff */

#define dprintf(x)	if (debug_list && index(debug_list,x)) fprintf
extern char *index();
extern char debug_list[];		/* list of debugging flags */

#define real float
#define MAXLINE	512		/* maximum input line size */
#define A(x)	audio->x		/* short hand */
#define P(x)	params->x	/* short hand */
#define BETWEEN(a,x,b)   (x)<(a)?a:((x)>(b)?b:x)
#define ISWHITE(c)			((c)==' ' || (c) == '\t')
#define MAXBUFF	24000		/* maximum hunk size */
#define MAXNOTE	32000		/* longest possible note */
