// bpbw.cc
// bpbw: a Butterworth band-pass filter
/*
	Copyright (c) 1994 Kai Lassfolk
*/

#include <stdio.h>
#include <spkit/spkit.h>

int main(int argc, char *argv[])
{
    SPKitReader source;
    SPKitBWBandPassFilter bpbw;
    SPKitWriter dest;
    double freq;
    double bw;

    if (argc != 5) {
	fprintf(stderr, "Usage: bpbw centerFreq bandwidth source dest\n");
	exit(1);
    }

    if (source.setInput(argv[3]) < 0) {
	fprintf(stderr, "bpbw: cannot open input: %s\n", argv[3]);
	exit(1);
    }
    bpbw.setInput(&source);
    if (dest.setInputOutput(&bpbw, argv[4]) < 0) {
	fprintf(stderr, "bpbw: cannot open output: %s\n", argv[4]);
	exit(1);
    }

    sscanf(argv[1], "%lf", &freq);
    sscanf(argv[2], "%lf", &bw);
    bpbw.setCenterFreqAndBW(freq, bw);

    dest.run();

    exit(0);
}
