// lpbw.cc
// lpbw: a Butterworth low-pass filter example program
/*
	Copyright (c) 1994 Kai Lassfolk
*/

#include <stdio.h>
#include <spkit/spkit.h>

int main(int argc, char *argv[])
{
    SPKitReader source;
    SPKitBWLowPassFilter lpbw;
    SPKitWriter dest;
    double freq;

    if (argc != 4) {
	fprintf(stderr, "Usage: lpbw cutOffFreq source dest\n");
	exit(1);
    }

    if (source.setInput(argv[2]) < 0) {
	fprintf(stderr, "lpbw: cannot open input: %s\n", argv[2]);
	exit(1);
    }
    lpbw.setInput(&source);
    if (dest.setInputOutput(&lpbw, argv[3]) < 0) {
	fprintf(stderr, "lpbw: cannot open output: %s\n", argv[3]);
	exit(1);
    }

    sscanf(argv[1], "%lf", &freq);
    lpbw.setCutOffFreq(freq);

    dest.run();

    exit(0);
}
