// fader.cc
/*
 * fader: a simple SoundProcessor Kit program
 *
 * Copyright (c) 1994 Kai Lassfolk
 */

#include <stdio.h>
#include <spkit/spkit.h>

int main(int argc, char *argv[])
{
    SPKitReader reader;
    SPKitAmp fader;
    SPKitWriter writer;
    double gain;

    if (argc != 4) {
	fprintf(stderr, "Usage: fader gain sourcefile destfile\n");
	return 1;
    }

    /*
     * Connect objects
     */
    if (reader.setInput(argv[2]) < 0) { // Open source soundfile
	fprintf(stderr, "fader: cannot open input file %s\n", argv[2]);
	return 1;
    }
    
    fader.setInput(&reader);  // Set reader as input to fader
    
    /*
     *  Set fader as input to writer and open destination soundfile
     */
    if (writer.setInputOutput(&fader, argv[3]) < 0) {
	fprintf(stderr, "fader: cannot open output file %s\n", argv[3]);
	return 1;
    }
    
    /*
     * Setup processing parameters
     */
    sscanf(argv[1], "%lf", &gain);
    fader.setGain(gain); // Set fader gain

    /*
     * Run
     */
    writer.run();

    return 0;
}
