// comblowp.h

#ifndef _SPKIT_COMBLOWPASS_H_
#define _SPKIT_COMBLOWPASS_H_

#include <spkit/spkit.h>
#include "z1lpf.h"

class SPKitCombLowPass : public SPKitProcessor {
public:
    SPKitCombLowPass();
    ~SPKitCombLowPass();
    
    int setInputAndDelayTime(SPKitProcessor* input, SPKitFloat delayTime);
    void setG(SPKitFloat value);
    void setG1(SPKitFloat value);
    void setReverbTime(SPKitFloat reverbTime);
    
    SPKitFloat getReverbTime();
    
protected:
    void updateGains();
    
    SPKitFloat reverbTime;
    SPKitFloat delayTime;
    
    SPKitFloat g;
    SPKitFloat g1;
    SPKitFloat g2;
    
    SPKitFeedback* feedback;
    SPKitFBDelay* delay;
    SPKitZ1LowPassFilter* lpf;
    SPKitAmp* amp;
    SPKitMux* mux;
};

#endif
