// wshape.cc
/*
 * wshape: a waveshaping program
 *
 * Copyright (c) 1995 Kai Lassfolk
 */

#include <stdio.h>
#include <spkit/spkit.h>

int main(int argc, char *argv[])
{
    SPKitReader reader;
    SPKitReader bufReader1;
    SPKitReader bufReader2;
    SPKitAmp inAmp;
    SPKitAmp midAmp;
    SPKitAmp outAmp;
    SPKitWaveShaper shaper1;
    SPKitWaveShaper shaper2;
    SPKitBWLowPassFilter filter;
    SPKitWriter writer;
    double gain;
    double freq;

    if (argc != 9) {
	fprintf(stderr, "Usage: wshape2 inputVolume shapefile1 midVolume");
	fprintf(stderr, " shapefile2 outputVolume cutOffFreq");
	fprintf(stderr, " sourcefile destfile\n");
	exit(1);
    }

    /*
     * Connect objects
     */
    reader.setInput(argv[7]); // Open source soundfile
    inAmp.setInput(&reader);  // Set reader as input to input amp
    
    bufReader1.setInput(argv[2]); // Open transfer function file
    shaper1.setInputAndBuffer(&inAmp, &bufReader1);
    midAmp.setInput(&shaper1);  // Set reader as input to fader

    bufReader2.setInput(argv[4]); // Open transfer function file
    shaper2.setInputAndBuffer(&midAmp, &bufReader2);
    outAmp.setInput(&shaper2);  // Set reader as input to fader

    filter.setInput(&outAmp);
    
    writer.setInputOutput(&filter, argv[8]); // Set fader as input to writer
					    // and open destination soundfile
    /*
     * Setup processing parameters
     */
    sscanf(argv[1], "%lf", &gain);
    inAmp.setGain(gain); // Set amp gain

    sscanf(argv[3], "%lf", &gain);
    midAmp.setGain(gain);

    sscanf(argv[5], "%lf", &gain);
    outAmp.setGain(gain);

    sscanf(argv[6], "%lf", &freq);
    filter.setCutOffFreq(freq);

    /*
     * Run
     */
    writer.run();

    exit(0);
}
