// complim.h
/*
 * SPKitCompressorLimiter: a compressor limiter class
 *
 * Copyright (c) 1995 Kai Lassfolk
 */

#ifndef _SPKIT_COMPRESSORLIMITER_H_
#define _SPKIT_COMPRESSORLIMITER_H_

#include "compress.h"
#include "limiter.h"

class SPKitCompressorLimiter : public SPKitProcessor {
public:
    SPKitError setInputAndEstimationTime(SPKitProcessor* ip, SPKitFloat et);

    void setCompressorThreshold(SPKitFloat value);
    void setLimiterThreshold(SPKitFloat value);
    void setCompressionRatio(SPKitFloat value);

protected:
    SPKitCompressor compressor;
    SPKitLimiter limiter;
};

inline void SPKitCompressorLimiter::setCompressorThreshold(SPKitFloat value)
{
    compressor.setThreshold(value);
}

inline void SPKitCompressorLimiter::setLimiterThreshold(SPKitFloat value)
{
    limiter.setThreshold(value);
}

inline void SPKitCompressorLimiter::setCompressionRatio(SPKitFloat value)
{
    compressor.setRatio(value);
}

#endif
