// delay.cc

#include "delay.h"

SPKitDelay::SPKitDelay()
{
    buffer = 0;
}

SPKitDelay::~SPKitDelay()
{
    if (buffer)
	delete [] buffer;	
}

int SPKitDelay::setInputAndDelayTime(SPKitProcessor* ip, SPKitFloat dt)
{
    SPKitProcessor::setInput(ip);

    delayTime = dt;
    bufSize = int(delayTime * inputSamplingRate) * inputChannelCount;

    buffer = new SPKitSample[bufSize];
    
    if ((buffer = new SPKitSample[bufSize]) == 0)
	return -1;
    
    for(int i = 0; i < bufSize; i++)
	buffer[i] = 0;
    
    oldestSampleIndex = lastSampleIndex = 0;
    
    haveSamples = 0;
    endOfInput = 0;

    return 0;
}

int SPKitDelay::getSample(SPKitSample& outputSample)
{
    SPKitSample inputSample;

    if (endOfInput) {
        if (oldestSampleIndex == lastSampleIndex)
	    return 0;
	outputSample = buffer[oldestSampleIndex++];
	oldestSampleIndex %= bufSize;
	return 1;
    }	

    if (input->getSample(inputSample) == 0) {
	endOfInput = 1;
        if (!haveSamples)
	    return 0;
	outputSample = buffer[oldestSampleIndex++];
	oldestSampleIndex %= bufSize;
	return 1;
    }	

    haveSamples = 1;

    outputSample = buffer[oldestSampleIndex];
    buffer[oldestSampleIndex++] = inputSample;
    oldestSampleIndex %= bufSize;

    lastSampleIndex = oldestSampleIndex;

    return 1;
}
