// sgiwrite.cc

#include "sgiwrite.h"
#include <stdio.h>

SPKitWriter::SPKitWriter()
{
    sampleBuffer = 0;
}

SPKitWriter::~SPKitWriter()
{
    if (sampleBuffer)
	delete [] sampleBuffer;
}

SPKitError SPKitWriter::setInputOutput(SPKitProcessor* sp, const char* fname)
{
    if (SPKitProcessor::setInput(sp))
	return -1;

    samplesWritten = 0;

    framesPerBuffer = 1024;
    samplesPerBuffer = framesPerBuffer * inputChannelCount;
    sampleBuffer = new int16[samplesPerBuffer];
    
    if ((fd = open(fname, O_CREAT|O_TRUNC|O_WRONLY, 0644)) < 0)
	return -1;

//    printf("open succeeded\n");

    audioFileSetup  = AFnewfilesetup();

    if (originalDataFormat == AF_COMPRESSION_NONE)
	    AFinitfilefmt(audioFileSetup, AF_FILE_AIFF);
    else
	    AFinitfilefmt(audioFileSetup, AF_FILE_AIFFC);

    AFinitcompression(audioFileSetup, AF_DEFAULT_TRACK, originalDataFormat);
    AFinitchannels(audioFileSetup, AF_DEFAULT_TRACK, inputChannelCount);
    AFinitrate(audioFileSetup, AF_DEFAULT_TRACK, inputSamplingRate);
    AFinitsampfmt(audioFileSetup, AF_DEFAULT_TRACK, AF_SAMPFMT_TWOSCOMP, 16);
    
    if ((audioFile = AFopenfd(fd, "w", audioFileSetup))
	== AF_NULL_FILEHANDLE)
	return -1;

//    printf("setInput succeeded\n");
    return 0;
}

void SPKitWriter::run()
{
    SPKitSample inputSample;
    SPKitInt sampleIndex = 0;
    int inputRetVal = 0;
    long framesWritten;
//    int inputSuccess = 0;

//    printf("run called\n");
    do {
	while (sampleIndex < samplesPerBuffer) {
	    if ((inputRetVal = input->getSample(inputSample)) == 0)
		break;
//	    inputSuccess++;
	    if (inputSample < -1.0)
		sampleBuffer[sampleIndex++] = SPKIT_INT16_MIN;
	    else if (inputSample > 1.0)
		sampleBuffer[sampleIndex++] = SPKIT_INT16_MAX;
	    else
		sampleBuffer[sampleIndex++] = int16(inputSample
						    * SPKIT_INT16_MAX);
	}
	if (sampleIndex > 0) {
	    framesWritten = AFwriteframes(audioFile, AF_DEFAULT_TRACK,
			    (void *)sampleBuffer,
			    sampleIndex / inputChannelCount);
	    samplesWritten += framesWritten * inputChannelCount;
	    sampleIndex = 0;
	}
    } while (inputRetVal); 
//    printf("%d samples written\n", samplesWritten);
//    printf("Input called successfully %d times.\n", inputSuccess);

    // These should really be in the destructor, but it didn't
    // work when I tried
    AFclosefile(audioFile);
    AFfreefilesetup(audioFileSetup);	
}

SPKitInt SPKitWriter::runFor(SPKitInt count)
{
    static int inputRetVal;
    SPKitSample inputSample;
    short outputSample;
    long framesWritten;
    
    if (count != samplesPerBuffer) {
	delete [] sampleBuffer;
	sampleBuffer = new int16[count];
	samplesPerBuffer = count;
	framesPerBuffer = samplesPerBuffer / inputChannelCount;
    }
    
    SPKitInt i = count;
    SPKitInt sampleIndex = 0;

    while (i) {
 	if ((inputRetVal = input->getSample(inputSample)) == 0)
	    break;
	if (inputSample < -1.0)
	    sampleBuffer[sampleIndex++] = SPKIT_INT16_MIN;
	else if (inputSample > 1.0)
	    sampleBuffer[sampleIndex++] = SPKIT_INT16_MAX;
	else
	    sampleBuffer[sampleIndex++] = int16(inputSample * SPKIT_INT16_MAX);
	i--;
    }
    if (sampleIndex > 0) {
	framesWritten = AFwriteframes(audioFile, AF_DEFAULT_TRACK,
				      (void *)sampleBuffer,
				      sampleIndex / inputChannelCount);
	return framesWritten * inputChannelCount;
    }

    AFclosefile(audioFile);
    AFfreefilesetup(audioFileSetup);	

    return 0;
}
