/* swapbyte.h */
/*
 * Byte swapping functions
 *
 * Copyright (c) 1994 Kai Lassfolk
 */

#ifndef _SWAP_BYTES_H__
#define _SWAP_BYTES_H__

/*
inline int16 swapInt16(int16);
inline int32 swapInt32(int32);
inline uint16 swapUint16(uint16);
inline uint32 swapUint32(uint32);

inline int16 swapInt16(int16 x)
{
    return (x << 8) + (x >> 8);
}

inline int32 swapInt32(int32 x)
{
    return (x << 24) + (x << 8 & 0xFF0000)
	   + (x >> 8 & 0xFF00) + (x >> 24);
}

inline uint16 swapUint16(uint16 x)
{
    return (x << 8) + (x >> 8);
}

inline uint32 swapUint32(uint32 x)
{
    return (x << 24) + (x << 8 & 0xFF0000)
	   + (x >> 8 & 0xFF00) + (x >> 24);
}

*/

#define swapInt16(x) (((int16)(x) << 8 & 0xFF00) | ((uint16)((int16)(x)) >> 8 & 0xFF))

#define swapUint32(x) (((uint32)(x)<<24) + (((uint32)(x)<<8) & 0xFF0000) + (((uint32)(x)>> 8) & 0xFF00) + ((uint32)(x)>>24))

#endif
