.Dd December 26, 1994
.Dt RAND N
.Os
.Sh NAME
.Nm rand
.Nd "tclmidi command for the generation of random numbers"
.Sh SYNOPSIS
.Nm
.Op dist Op value
.Op mean Op value
.Op variance Op value
.Op width Op value
.Op seed Op value
.Op type Op value
.Op state

.Sh DESCRIPTION
.Nm
is a
.Xr tclmidi 1
command for the generation of random numbers.
.Pp
Without arguments
.Nm
generates a random number based on the current distribution function.
To modify or examine the state of the random number generator,
the 
.Nm
command also supports the several arguments.
Each argument should be a list consisting of the parameter
name followed by an optional value.
If a value for a parameter is not specified then the current
setting is reported.
If a value is specified then that parameter is changed.
.Pp
Available options are:
.Bl -tag -width division
.It dist
specifies the probability distribution of random numbers generated.
Legal values are 
.Dq uniform 
and 
.Dq normal .
The default value is
.Dq uniform .
.Pp
Under the 
.Dq uniform
distribution, random numbers are chosen from the specified interval
with uniform probability.
.Pp
Under the 
.Dq normal
distribution, random numbers will be chosen according to a Gaussian 
distribution with the specified mean and variance.
.It mean
This parameter determines the mean or expected value of random numbers
generated.  The default value is 0.
.It variance
This parameter determines the spread of random numbers about the mean.
For a normal distribution, it is the variance.  For a uniform distribution,
it corresponds to the half-width.
.It width
Same as variance.
.It seed
This argument is used to supply a new seed to the random number generator.
See 
.Xr srand 3
for details.  The default value is 0.
.It type
This argument is used to determine the type of random numbers generated.
Legal values are
.Dq integer
and
.Dq double .
The default value is
.Dq double .
.It state
This argument is used to display the current state, i.e. all of the 
above mentioned parameters.
.El
.Sh RETURN VALUES
If no arguments are given, 
.Nm 
returns the string representation of a random number. 
If parameters are being set,
.Nm
will return nothing.
If parameters are being queried,
a list of lists will be returned.
Each sublist will contain the parameter
name and its associated value.
The parameters are returned in the order
specified.
.Pp
.Sh BUGS/FEATURES
All computations are done using double-precision math.  Integer precision
return values are just rounded-off doubles.  That means you can specify
double-precision values for the mean and variance, and have 
.Nm
return integer values with non-integer mean/variance.  The generation of
integer random numbers could be sped up if you don't need that
functionality.
.Pp
For uniform distributions, the width
parameter is really a half-width.  For example, using mean 0 and width 1,
you will get numbers distributed on the interval [-1,1].
.Pp
.Sh SEE ALSO
.Xr tclmidi 1 ,
.Xr rand 3 ,
.Xr srand 3 .
.Sh AUTHOR
Greg Wolodkin - greg@eecs.berkeley.edu
