#include <stdlib.h>
#include <math.h>
#include "erfi.h"

/*
 * To generate normally-distributed (i.e. Gaussian) random variables,
 * I need the inverse of the error function.
 *
 * This function uses the IEEE function infnan() which is included in
 * the Linux math library.  I know it's not there on a DEC Alpha, but
 * haven't figured out what to do about it yet.
 *
 */

double
erfi(y)
    double y;
{
    double s, z, x, e;
    double alpha[] =				
        {0.76462792672, 1.66427503973, -3.92229111230, 3.34014728722};
    double eps = 1.0e-16;
    int k;

    /* 
     * GJW 12/21/94 :: some notes:
     *   1) alpha is just a least squares fit to the polynomial basis.
     *   2) speed could be improved using a better initial guess and
     *      less iterations.
     */

    /* function has odd symmetry -- remove sign for now */
    if (y < 0) {
      s = -1.0;
      y = -y;
    } else 
      s = 1.0;

      /* don't iterate on special cases */
      if (y == 1)
        x = infnan((int)s * ERANGE);
      else if (y > 1)
        x = infnan((int)s * EDOM);
      else {
        /* an initial guess */
        x = 0.0;
        z = y;
        for (k = 0; k < 4; k++) {
          x += alpha[k] * z;
          z *= y * y;
	}

        /* Newton-Raphson iterations get the right answer */
        /* Rarely will this take more than 2-3 iterations */
        for (k = 0; k < 25; k++) {
          e = erf(x) - y;
          x -= e / (M_2_SQRTPI * exp(-x*x));
#if 0
          fprintf(stderr,"Iter %u  error %e\n", k, fabs(e));
#endif
          if (fabs(e) < eps)
            break;
          }
	  x = s * x;
	}
	return x;
}

#if 0
void main (void)
{
	double y;

	y = 0.5;
	printf("erfi(%e) = %e\n", y, erfi(y));

/*
 * This should generate Inf floating point exception
	y = -1.0;
	printf("erfi(%e) = %e\n", y, erfi(y));
*/

/*
 * This should generate NaN floating point exception 
	y = 2;
	printf("erfi(%e) = %e\n", y, erfi(y));
*/

	y = 0.02;
	printf("erfi(%e) = %e\n", y, erfi(y));

	y = -0.4;
	printf("erfi(%e) = %e\n", y, erfi(y));

/*
 * This should take a lot of iterations.. maybe a rational approximation
 * with a pole near (1-y) would help..
 */
	y = 0.999999999;
	printf("erfi(%e) = %e\n", y, erfi(y));
}
#endif
