#ifndef TCLMIDI_H
#define TCLMIDI_H

extern "C" {
#include <tcl.h>
}

#if defined(__WIN32__)
#   define WIN32_LEAN_AND_MEAN
#   include <windows.h>
#   undef WIN32_LEAN_AND_MEAN

/*
 * VC++ has an alternate entry point called DllMain, so we need to rename
 * our entry point.
 */

#   if defined(_MSC_VER)
#	define EXPORT(a,b) __declspec(dllexport) a b
#	define DllEntryPoint DllMain
#   else
#	if defined(__BOLANDC__)
#	    define EXPORT(a,b) a _export b
#	else
#	    define EXPORT(a,b) a b
#	endif
#   endif
#else
#   define EXPORT(a,b) a b
#   undef Tcl_Ckfree
#   define Tcl_Ckfree free
#endif

#include "TclmIntp.h"

EXTERN EXPORT(int,Tclmidi_Init) _ANSI_ARGS_((Tcl_Interp *interp));
extern int Tclm_PlayInit(Tcl_Interp *interp, TclmInterp *tclm_interp);
extern int Tclm_PatchInit(Tcl_Interp *interp, TclmInterp *tclm_interp);
extern int Tcl_GetLong(Tcl_Interp *interp, const char *string, long *longPtr);
extern int Tclm_ParseDataByte(Tcl_Interp *interp, const char *str, int *val);
extern void Tclm_PrintData(ostream &buf, const unsigned char *data,
    long length);
#endif
