/************************************************************
   OBJECT-ORIENTED Protein Data Bank Project
   Copyright (c) 1992, 1993 Columbia University
   Biochemistry and Molecular Biophysics, Computer Science depts.
 **************************************************************

   File: main.c
   Responsable: Weider Chang, Ph.D
  
 **************************************************************/

#include <iostream.h>
#include <stdlib.h>
#include <string.h>
#include "oopdb_setup.h"
#include "iterator.h"
#include "aa.h"
#include "pdbfile.h"


#if NEED_OBJECTSTORE

#include "os_connectivity.h"

#endif


main() {

  PdbFile pdbfile;
  Compound* compound;
  char tmp[80];
  if ((compound = pdbfile.import()) == NULL ) {
    cout << endl << " The importing process failed!!!" << endl;
    exit(1);
  };
   
//
// browse all chains, subentitys, atoms of p1
// $$ output very long, try it using run | more
//

#if NEED_CALC

  for ( EntityIter cit1(*compound);cit1; ++cit1) {
    cout << endl << "Entity is: " <<cit1().d_identifier
      << endl  << endl;
    for (SubEntityIter rit(cit1()); rit; ++rit) {
      cout << "The atoms belonged to -- " ;
      cout << rit().d_seq_no << "th  subentity: "
	<< rit().d_name << " type "<<rit().myType()<<" -- are:" <<endl;
      cout << "Omega angle is: "
	<< rit().omega_angle()<<" "<<rit().omega_angle(1)<<endl;
      cout << "Phi angle is:   "<< rit().phi_angle()<<endl;
      cout << "Psi angle is:   "<< rit().psi_angle()<<endl;
      if (rit().atom_to_previous_subentity())
	cout << "Atoms connected to other subentitys are "
	  <<(rit().atom_to_previous_subentity())->d_name<<"  "
	    <<(rit().atom_to_next_subentity())->d_name<<endl;
      for ( AtomIter ait(rit()); ait; ++ait) {
	if (!ait().is_missing_atom()){
	  for (AltAtomIter alt_ait(ait()); alt_ait; ++alt_ait){
	    cout << alt_ait().d_no << " " << alt_ait().d_name;
	    for (int i=0; i<alt_ait().number_of_alt_position(); ++i)
	      cout<< " position "<<i<<" is " << alt_ait().d_x(i)
		<< " " << alt_ait().d_y(i) << " "<< alt_ait().d_z(i)<<endl;
	    cout <<" connected to : ";
	    for (List_of_atoms * head_p=alt_ait().bound_atoms();
		 head_p;
		 head_p=head_p->next)
	      cout<<(head_p->bound_atom)->d_name<<" ";
	    cout<<endl;
	  }
	}
	else
	  cout<<ait().d_name<<" is a dummy atom."<<endl;
      };
      cout<<endl;
    };
    cout << endl;
  };


  cout << endl << endl <<" -- subentitys belong to compound:" << endl;
  for ( SubEntityIter rit1(*compound); rit1; ++rit1) {
	cout << rit1().d_seq_no << " -> "  ;
  }
  cout << endl << endl;



//
// browse all secondary structures of p1
//

cout << endl << " -- List of secondarys structures belong to compound:" << endl << endl;

for ( SecondaryStrucIter sit1(*compound); sit1; ++sit1) {
  cout << sit1().d_identifier << "(" << sit1().d_type << sit1().d_serial_no
	<< ")" << " -> "  ;
};
cout << endl << endl;

//
// browse subentitys belong to these secondary structures
//

cout << "-- List of subentitys belonged to following secondary structures:" << endl << endl;

for ( SecondaryStrucIter sit2(*compound); sit2; ++sit2) {
cout << sit2().d_identifier << "(" << sit2().d_type << sit2().d_serial_no << ")" << "  :"  ;
	for ( SubEntityIter rit2(sit2()); rit2; ++rit2)
	cout << rit2().d_seq_no << " -> ";
	cout << endl << endl;
};
cout << endl << endl;

/*******************************
 cout << compound->d_header_p << endl;
 cout << compound->d_obslte_p << endl;
 cout << compound->d_compnd_p << endl;
 cout << compound->d_source_p << endl;
 cout << compound->d_expdta_p << endl;
 cout << compound->d_author_p << endl;
 cout << compound->d_revdat_p << endl;
 cout << compound->d_sprsde_p << endl;
 cout << compound->d_jrnl_p << endl;
 cout << compound->d_remark_p << endl;

*********************************/
/*


for ( PdbInfoIter i1(compound->d_header_p); i1; ++i1) {
	cout << i1();
	strcat( tmp, i1());
	if(tmp[0]=='\n') cout << "why I begin with n? " << endl;
	cout << "tmp =  " << tmp << endl;
	cout << "i1() = " << i1() << endl;
};
cout << endl;
*/
/****************************************************
for ( PdbInfoIter i2(compound->d_compnd_p); i2; ++i2) {
	cout << i2();
};
cout << endl;

for ( PdbInfoIter i3(compound->d_source_p); i3; ++i3) {
	cout << i3();
};
cout << endl;

for ( PdbInfoIter i4(compound->d_author_p); i4; ++i4) {
	cout << i4();
};
cout << endl;

for ( PdbInfoIter i5(compound->d_jrnl_p); i5; ++i5) {
	cout << i5();
};
cout << endl;
for ( PdbInfoIter i6(compound->d_remark_p); i6; ++i6) {
	cout << i6();
};
*****************************************************/

/*  cout << endl<<endl<<"The ramachandran plot quality is :"
	 <<compound->ramachandran_quality()<<endl;

 HistogramValues * head=compound->delta_omegas();

 while (head) {
	cout<<head->value<<" for subentity "<<(head->subentity_p)->d_name<<endl;
	head=head->next_p;
 };
*/
#endif /* of #if CALC */

/*  SubEntityIter rita(*compound->non_polymers_p);
  for (SubEntityIter rit(rita()); rit; ++rit){
    cout<<rit().d_name<<endl;
//    cout<<"Omega angle is "<<rit().omega_angle()<<endl;
    for (AtomIter ait(rit()); ait; ++ait)
      cout<<ait().d_name<<" "<<ait().d_no<<endl;
  }
*/  
/*  cout<<"Is compound == core compound "<<(compound->self() 
					== compound->core_self())
    <<endl;

  compound->connectivity_map_p()->check();*/

#if NEED_OBJECTSTORE

   OS_BEGIN_TXN(tx1, 0, os_transaction::update) 

   OSConnectivitySet 
       *cp=new(db1) OSConnectivitySet(*compound->connectivity_set_p());
   /*  cp = *(compound->connectivity_map_p());*/
   db1->create_root("connectivities")->set_value(cp);
   cp->check();
   OS_END_TXN(tx1)

   OS_BEGIN_TXN(tx2, 0, os_transaction::update) 

   ConnectivitySet *cp1=(OSConnectivitySet*)(db1->find_root("connectivities")
					     ->get_value());
   cp1->check();


   OS_END_TXN(tx2)
   
   db1->close();
   
#endif

  if ( compound != NULL ) delete compound;

}











