c#subroutine wtrec     srs     v1.0     jan 81
	subroutine wtrec(iun,ifmt,icount,in_an,in_rn,nr,x,d)
c
c	Write a coordinate record for a protein data file
c	Arguments as as follows:
c
c	IUN ... unit number for write
c	IFMT .. format selection; Available formats
c		are documented in comments to 
c		FTCHUZ.
c	ICOUNT. record counter. Set by calling routine
c	AN .... atom name; a character*4 variable
c	RN .... residue name; as above
c	NR .... residue number
c	X ..... x,y,z for the atom
c	D ..... up to two associated variables
c
c  2/9/88 Bug fix for Hendrickson write [PEB]
c**********************************************************
c&
	dimension x(3), d(2)
	character*4 in_an,in_rn,an,rn,oldrna,blank4
	integer oldrnu
	integer idw(5)
	character*1 atmtyp(5)
	character*1 onelet
	character*2 blank2
c
c
	data atmtyp/'C','N','O','P','S'/
	data idw/1,2,3,4,5/
	data blank4,blank2/'    ','  '/
c  *** forget case conversion.. PDB always uppercase [PEB 6/23/87]
c	call str$upcase(an,in_an)
        an = in_an
c	call str$upcase(rn,in_rn)
        rn = in_rn
	ichain = 1
	go to (10,20,30,40,50),ifmt
c
c ***   PDB format
10	write(iun,1)icount,an,rn,nr,x,d,blank2,blank4,blank4,blank4
	return
c
c ***   KRAUT format
20 	if( nr .ne. oldrnu) then
	oldrna = rn
	oldrnu = nr
	write(iun,2)rn,nr
	endif
	write(iun,3)an,x,d(1),an,nr
	return
c
c ***	DIAMOND
30	do 35 i=1,5
	if (an(1:1) .eq. atmtyp(i))go to 36
35	continue
	print *,'WTREC BOMB; unknown atom type for Diamond file: ',atom
	stop
36	itype = idw(i)
	write(iun,4)x,d(1),itype,nr,icount,d(2),rn,an
	return
c
c ***   HENDRICKSON
40	call encode(rn,onelet)
	d(1) = 1.00         ! set occupancy to 1.0 [peb]
        write(iun,6)ichain,rn,onelet,nr,an,x,d(2),d(1)   ![peb]
	return
c
c **	SHAPELEY MODEL
c
50	if( an .ne. 'CA ' ) return
	ncount = ncount + 1
	write(iun,5)an,rn,ncount,x
	return
1	format('ATOM',2x,i5,2x,2a4,i5,4x,3f8.3,2f6.2,a2,3a4)
2	format('RESIDU',2x,a4,i4)
3	format('ATOMG',4x,a4,3f8.3,f6.2,a4,i4)
4	format(4f10.5,3i5,f9.4,1x,a4,6x,a4)
5	format(1x,a2,2x,a3,2x,i4,5x,3(f7.3,1x))
6	format(i2,1x,a3,1x,a1,i3,a4,5f10.5)
	end
