/*
**  File: TorGraph.h
**  Author: K.R. Sloan, Jr.
**          James Painter
**          David Meyers
**  Last Modified: 2 July 1990
**  Purpose: definitions for Toroidal graphs
*/

#include <REAL.h>

GraphType *NewGraph();  /* G = NewGraph( NRows, NColumns ) */
PathType *NewPath();   /* G = NewPath ( NRows, NColumns ) */
PathType *DuplPath();  /* G = DuplPath( Path ) */
void DisposePath();    /* DisposePath( Path ) */
void FillPath();	/* FillPath( G,  StartRow, StartCol, P ) */

GraphType *MakeCostGraph();
 /* G = MakeCostGraph ( Contour1, Contour2, CostFunction )
      GraphType *G;
      PointsType *Contour1, *Contour2;
      REAL (*CostFunction) ();
 */
REAL OnePath();
REAL OnePathFence(); /* cost = OnePath(StartRow, StartCol, G, P)
                             int StartRow, StartCol;
                             GraphType *G;                
                             PathType *P;     */


extern REAL BtlnckAllPaths();
                    /* cost = BtlnckAllPaths( G, P, StartRow, StartCol )
                              GraphType *G;
                              PathType  *P;
                              int *StartRow;
                              int *StartCol; */


