/*
  File: NumberFilter.c
  Author: David Meyers
  Last Modified: 3 July 1990
  Purpose: Condition number formats
 */

#include <stdio.h>

main()
{
 int ch;
 double n1, n2, n3;

 ch = fgetc(stdin);
 for(;;)
  {
   if(EOF == ch) break;
   if((char) ch == '[')
    {
     if(3 != fscanf(stdin,"%f, %f, %f", &n1, &n2, &n3))
      {
       (void)fprintf(stderr,"error in input: expecting 3 numbers, exiting\n");
       return(-1);
      }
     
     (void) fprintf(stdout,"[%3.15f, %3.15f, %3.15f", n1, n2, n3);
    }
   else
    {
     (void) fputc(ch, stdout);
    }
   ch = fgetc(stdin);
  }
 if(feof(stdin)) return(0);
 else
  {
   (void) fprintf(stderr,"Error reading input, exiting\n");
   return(-1);
  }
}
