/*
  File: OnePath.c
  Author: K.R. Sloan, Jr.
          James Painter,
	  David Meyers
  Last Modified: 27 November 1989
  Purpose: searching toroidal graphs
 */

#include <stdio.h>
#include <TypeDefinitions.h>
#include <Meters.h>
#include <TorGraph.h>

extern int outputPaths;

REAL OnePath(StartRow, StartCol, G, P)
 int StartRow, StartCol;
 GraphType *G;
 PathType *P;
 {
  int R, C, ThisR, ThisC;
  REAL FromAbove, FromLeft, Cost;
  
  G->PSN[0][0].BestCost = 0.0; 

  Cost = 0.0;
  for (R = 1, ThisR = StartRow+1; R <= G->Rows; R++, ThisR++)
   { /* fill in 0'th Column */
    if (ThisR == G->Rows) ThisR = 0;
    Cost += G->N[ThisR][StartCol].UpCost;
    G->PSN[R][0].BestCost = Cost;
    G->PSN[R][0].WhichWay = UP;
   } /* fill in 0'th Column */

  Cost = 0.0;
  for (C = 1, ThisC = StartCol+1; C <= G->Columns; C++, ThisC++)
   { /* fill in 0'th Row */
    if (ThisC == G->Columns) ThisC = 0;
    Cost += G->N[StartRow][ThisC].LeftCost;
    G->PSN[0][C].BestCost = Cost;
    G->PSN[0][C].WhichWay = LEFT;
   } /* fill in 0'th Row */
  
  for (R = 1, ThisR = StartRow+1; R <= G->Rows; R++, ThisR++)
   {
    if (ThisR == G->Rows) ThisR = 0;
    for (C = 1, ThisC = StartCol+1; C <= G->Columns; C++, ThisC++)
     {
      if (ThisC == G->Columns) ThisC = 0;
      FromAbove = G->N[ThisR][ThisC].UpCost   + G->PSN[R-1][C].BestCost;
      FromLeft  = G->N[ThisR][ThisC].LeftCost + G->PSN[R][C-1].BestCost;

      if (FromAbove <= FromLeft)
       {
        G->PSN[R][C].BestCost = FromAbove;
        G->PSN[R][C].WhichWay = UP;
       }  
      else
       {
        G->PSN[R][C].BestCost = FromLeft;
        G->PSN[R][C].WhichWay = LEFT;
       }
     }
   }

  FillPath ( G, StartRow, StartCol, P );
  return G->PSN[G->Rows][G->Columns].BestCost;
 }
