/*
  File: SectionOutput.c
  Author: Cheryl Buck
  Last Modified: 29 January 1990
  Purpose: routines to rewrite editted Contour Data files to be reused as
           input to the ContourEditor, ContourFitter or DrawContour programs.
 */

#include <stdio.h>
#include <string.h>
#include <math.h>
#include <TypeDefinitions.h>

/**************************************************************************/

/*
  Write any adjacency information for next section associated with a contour.
 */
void WriteAdjNextList(AdjacentPtr, FilePtr)
 Adjacency *AdjacentPtr;
 FILE *FilePtr;
{
   Adjacency *FirstAdjacent;
   FirstAdjacent = AdjacentPtr;

   fprintf(FilePtr, "    { ADJNEXT { %s %d %d }", 
                              AdjacentPtr->Name,
                              AdjacentPtr->LocalIndex,
                              AdjacentPtr->AdjacentIndex) ;

   while ( AdjacentPtr->next != FirstAdjacent)
     {
        AdjacentPtr = AdjacentPtr->next;   
        fprintf(FilePtr, "                   { %s %d %d }",
                              AdjacentPtr->Name,
                              AdjacentPtr->LocalIndex,
                              AdjacentPtr->AdjacentIndex) ;
     }

   fprintf(FilePtr, " }\n");
}

/**************************************************************************/

/*
  Write any adjacency information for previous sections associated with a    
contour.
 */
void WriteAdjPrevList(AdjacentPtr, FilePtr)
 Adjacency *AdjacentPtr;
 FILE *FilePtr;
{
   Adjacency *FirstAdjacent;

   FirstAdjacent = AdjacentPtr;
   fprintf(FilePtr, "    { ADJPREVIOUS { %s %d %d }", 
                              AdjacentPtr->Name,
                              AdjacentPtr->LocalIndex,
                              AdjacentPtr->AdjacentIndex) ;

   while ( AdjacentPtr->next != FirstAdjacent)
     {
        AdjacentPtr = AdjacentPtr->next;   
        fprintf(FilePtr, "                   { %s %d %d }", 
                              AdjacentPtr->Name,
                              AdjacentPtr->LocalIndex,
                              AdjacentPtr->AdjacentIndex) ;
     }

   fprintf(FilePtr, " }\n");
}

/**************************************************************************/

/*
     Write Alias information
 */
void WriteAlias(TheContour, FilePtr)
 Contour TheContour;
 FILE *FilePtr;
{
 int i, n;

 n = TheContour.NAliases; 
 fprintf(FilePtr, "    { ALIAS %d", n);
 fprintf(FilePtr," { %s }", &(TheContour.Aliases[0]));

 for (i=1; i<n; i++)
    fprintf(FilePtr,"\n                  { %s }", &(TheContour.Aliases[i*80]));

 fprintf(FilePtr, " }\n"); 

}

/**************************************************************************/

extern void WriteSection(FilePtr, TheSection)
 FILE *FilePtr;
 Section *TheSection;
{
 int Npts;

 if (NULL != TheSection -> TheContours)
  {
   int i;
   fprintf(FilePtr, "{ SECTION %s %d\n",  
                          TheSection->Name,
                          TheSection->NContours);
  
   for(i=0; i<TheSection->NContours; i++)
     { int j;

       fprintf(FilePtr,"  { CONTOUR %s %d \n",TheSection->TheContours[i].Name, 
                               TheSection->TheContours[i].ContourPoints->n);

       Npts = TheSection->TheContours[i].ContourPoints->n ;
       for(j=0; j<Npts; j++)
        {
          fprintf(FilePtr, "    { %f %f %f }\n",
             TheSection->TheContours[i].ContourPoints->P[j].x,
             TheSection->TheContours[i].ContourPoints->P[j].y,
             TheSection->TheContours[i].ContourPoints->P[j].z);
        }

       if ( TheSection->TheContours[i].NAliases > 0)
         WriteAlias(TheSection->TheContours[i], FilePtr);
       if ( TheSection->TheContours[i].AdjContPrev != NULL)
         WriteAdjPrevList(TheSection->TheContours[i].AdjContPrev, FilePtr) ;
       if ( TheSection->TheContours[i].AdjContNext != NULL)
         WriteAdjNextList(TheSection->TheContours[i].AdjContNext, FilePtr) ;
 
       fprintf(FilePtr,"  }\n");
    } 
  fprintf(FilePtr, "}\n");
 }
}
