/*
  File: TestSGP.c
  Author: K.R. Sloan, Jr.
  Last Modified: 26 April 1991
  Purpose: test SGP
 */
#include <stdio.h>
#include <math.h>
#include "SGP.h"

static char *RoutineName;
static void usage()
 {
  fprintf(stderr,"Usage is\n\t%s\n", RoutineName);
 }

static sgpColorType Red   = {1.0, 0.0, 0.0};
static sgpColorType Green = {0.0, 1.0, 0.0};
static sgpColorType Blue  = {0.0, 0.0, 1.0};
static sgpColorType White = {1.0, 1.0, 1.0};
static sgpColorType Gray18= {0.5, 0.5, 0.5};
static sgpColorType Black = {0.0, 0.0, 0.0};
static sgpColorType Pink  = {1.0, 0.5, 0.5};
static sgpColorType Purple= {0.8, 0.1, 0.8};
static sgpColorType Yellow= {0.8, 0.8, 0.1};
static sgpColorType Orange= {1.0, 0.6, 0.1};
static sgpColorType Brown = {0.5, 0.3, 0.1}; 

main(argc, argv)
 int argc;
 char *argv[];
 {
  int ArgsParsed = 0;
  sgpDisplayType Display = ColorDisplay;
  sgpRectangleType Window, Viewport;
  sgpPointType Origin, Point, Screen;
  sgpPointType Points[3];
  sgpColorType Colors[3];
  sgpColorType Greys, Reds, Greens, Blues;
  sgpRectangleType Frame, Bar;
  int i, m, n;
  double angle;
  double TwoPi = 2.0*3.1415926;
  double Pi    =     3.1415926;
  sgpPointType CirclePoints[16];
  int Wedge, Wedges = 16;
  double GridSpacing = 0.1;

  RoutineName = argv[ArgsParsed++];

  while (ArgsParsed < argc) { usage(); exit (-1); }

  Origin.x = 0.0; Origin.y = 0.0; 
  for (Wedge=0; Wedge<Wedges; Wedge++)
   {
    angle = (double) Wedge * TwoPi / (double) Wedges;
    CirclePoints[Wedge].x = cos(angle); CirclePoints[Wedge].y = sin(angle);
   }


  fprintf(stderr,"TestSGP      26 April 1991     K.R. Sloan\n");
  sgpInit(Display);

                        Window.Top    = 1.0;
  Window.Left   = -1.0;                        Window.Right = 1.0;
                        Window.Bottom = -1.0;
  sgpSetWindow(Window);

                        Viewport.Top   = 0.9;
  Viewport.Left   = 0.1;                       Viewport.Right = 0.9;
                        Viewport.Bottom = 0.1;
  sgpSetViewport(Viewport);

  Point.x = 0.0; Point.y = 0.0;
  sgpWorldToScreen(Point, &Screen);
  fprintf(stderr,"World(%f, %f) is at Screen(%f, %f)\n",
                  Point.x, Point.y, Screen.x, Screen.y);
  sgpScreenToWorld(Screen, &Point);
  fprintf(stderr,"Screen(%f, %f) represents World(%f, %f)\n",
                  Screen.x, Screen.y, Point.x, Point.y);
  sgpColor(Gray18);
  sgpClearScreen();
  sgpColor(Black); 
  sgpRectangle(Window);

  sgpColor(Red);
  for (Point.x = Window.Left+(GridSpacing/2.0); 
       Point.x < Window.Right; 
       Point.x = Point.x+GridSpacing)
   for (Point.y = Window.Bottom+(GridSpacing/2.0);
        Point.y < Window.Top;
        Point.y = Point.y+GridSpacing)
    sgpPoint(Point);

                        Viewport.Top   = 0.9;
  Viewport.Left   = 0.1;                       Viewport.Right = 0.5;
                        Viewport.Bottom = 0.5;
  sgpSetViewport(Viewport);

  
  sgpColor(Blue);
  sgpCircle(Origin, 1.0); sgpCircle(Origin, 0.5);
  for (Wedge=0; Wedge<Wedges; Wedge++)
   sgpLine(Origin, CirclePoints[Wedge]);

                        Viewport.Top   = 0.9;
  Viewport.Left   = 0.5;                       Viewport.Right = 0.9;
                        Viewport.Bottom = 0.5;
  sgpSetViewport(Viewport);

  sgpColor(Gray18);  sgpDisc(Origin, 1.0);
  sgpColor(Black);   sgpDisc(Origin, 0.5);
  sgpColor(Green);
  for (Wedge=0; Wedge<Wedges; Wedge++)
   {
    Points[0] = CirclePoints[Wedge%Wedges];
    Points[1] = CirclePoints[(Wedge+1)%Wedges];
    Points[2] = CirclePoints[(Wedge+2)%Wedges];
    sgpSolidTriangle(Points);
   }

                        Viewport.Top   = 0.5;
  Viewport.Left   = 0.1;                       Viewport.Right = 0.9;
                        Viewport.Bottom = 0.1;
  sgpSetViewport(Viewport);

                       Frame.Top = 0.8; 
  Frame.Left = -0.8;                           Frame.Right = 0.8;
                       Frame.Bottom = -0.8;
  for (i=0; i<16; i++)
   {
    Greys.r = White.r+(((float) i)/16.0)*(Black.r-White.r);
    Greys.g = Greys.r;
    Greys.b = Greys.r;
    sgpColor(Greys);
    sgpRectangle(Frame);
                      Frame.Top  = Frame.Top-0.01;
    Frame.Left = Frame.Left+0.01;             Frame.Right  = Frame.Right-0.01;
                      Frame.Bottom = Frame.Bottom+0.01;
   }

                      Bar.Top = Frame.Top;
  Bar.Left = Frame.Left;
                      Bar.Bottom = Frame.Bottom;
                   Reds.g  = 0.0; Reds.b   = 0.0;
  Greens.r = 0.0;                 Greens.b = 0.0;
  Blues.r  = 0.0;  Blues.g = 0.0;
  for (i=0; i<16; i++)
   {
    Bar.Right=Frame.Left+(((float) (i+1))/16.0)*(Frame.Right-Frame.Left);
    Greys.r = Black.r+(((float) i)/16.0)*(White.r-Black.r);
    Greys.g = Greys.r;
    Greys.b = Greys.r;
    Bar.Bottom = Frame.Bottom;
    Bar.Top = Bar.Bottom + (Frame.Top-Frame.Bottom)/4.0;
    sgpColor(Greys);
    sgpRectangle(Bar);
    
    Bar.Bottom = Bar.Top;
    Bar.Top = Bar.Bottom + (Frame.Top-Frame.Bottom)/4.0;
    Blues.b = Greys.b;
    sgpColor(Blues);
    sgpRectangle(Bar);

    Bar.Bottom = Bar.Top;
    Bar.Top = Bar.Bottom + (Frame.Top-Frame.Bottom)/4.0;
    Greens.g = Greys.g;
    sgpColor(Greens);
    sgpRectangle(Bar);

    Bar.Bottom = Bar.Top;
    Bar.Top = Bar.Bottom + (Frame.Top-Frame.Bottom)/4.0;
    Reds.r = Greys.r;
    sgpColor(Reds);
    sgpRectangle(Bar);
    Bar.Left = Bar.Right;
   }

                        Viewport.Top   = 0.855;
  Viewport.Left   = 0.545;                       Viewport.Right = 0.855;
                        Viewport.Bottom = 0.545;

  sgpSetViewport(Viewport);

  Points[0] = CirclePoints[11];  Colors[0] = Blue;
  Points[1] = CirclePoints[5];   Colors[1] = Green;
  Points[2] = CirclePoints[14];  Colors[2] = Red;
  sgpShadeTriangle(Points, Colors);

  sgpColor(Red);
  m = 100; n = 3;
  sgpCurve(m, n, Points);

  sgpQuit();

  fprintf(stderr,"                   -30-\n");
  exit(0);
 }
