/*
  File: devTriangle.c
  Author: K.R. Sloan
          Jamie Painter
  Last Modified: 7 July 1989
  Purpose: draw solid and shaded triangles.
  Assumptions: L<R , B<T           
 */

#include <stdio.h>
#include "DEVICE.h"

#define Interpolate(u, u0, u1, v0, v1 ) \
  ((u1 == u0) ? (v0+v1) / 2 : (v0 + (u-u0)*(v1-v0)/(u1-u0)))

/*
   This is the place to optimize for a particular device...

   This version draws everything using devSetColor and devRect
 */

static void devShadeLine(y, xL, xR, rL, gL, bL, rR, gR, bR)
 int y, xL, xR;
 double rL, gL, bL, rR, gR, bR;
 {
  int x, cxL, cxR, t;
  double r, g, b, d;
  int SavedColorCode;

  SavedColorCode = devCurrentColor;
  if (xL > xR)
   {
    t = xL; xL = xR; xR = t;
    d = rL; rL = rR; rR = d;
    d = gL; gL = gR; gR = d;
    d = bL; bL = bR; bR = d;
   }

  cxL = xL; cxR = xR;

  if (  (y  < devClipB)
      ||(y  > devClipT)
      ||(xR < devClipL)
      ||(xL > devClipR) 
     )
   return;
  if (cxL < devClipL) cxL = devClipL;
  if (cxR > devClipR) cxR = devClipR;

  for (x = cxL; x <= cxR; x++)
   {
    r = Interpolate(x, xL, xR, rL, rR);
    g = Interpolate(x, xL, xR, gL, gR);
    b = Interpolate(x, xL, xR, bL, bR);
    (void) devSetColor(devColorCode(r,g,b));
    (void) devRect(x, y, x, y);
   }   
  devCurrentColor = SavedColorCode;
 }

int devSolidTriangle(x0, y0, x1, y1, x2, y2)
 int x0, y0, x1, y1, x2, y2;
 {
  int xR, xL, x, y, t;
  int left, right, middle, top, bottom;

  /* sort the vertices in increasing order */
  if (y0 > y1)
   {
    t=y0; y0 = y1; y1 = t;
    t=x0; x0 = x1; x1 = t;
   }
  if (y1 > y2)
   {
    t=y1; y1 = y2; y2 = t;
    t=x1; x1 = x2; x2 = t;
   }
  if (y0 > y1)
   {
    t=y0; y0 = y1; y1 = t;
    t=x0; x0 = x1; x1 = t;
   }

  /* look for a quick kill */
  top = y2; bottom = y0;
  left = x0; middle = x1; right = x2;
  if (left   > middle) { t =   left; left   = middle; middle = t; }
  if (middle > right ) { t = middle; middle =  right; right  = t; }
  if (left   > middle) { t =   left; left   = middle; middle = t; }

  if (devClipRectangle(&left, &top, &right, &bottom)) return 0;

  /* scan convert */
  for (y = y0; y <= y1; y++)
   {
    xL=Interpolate(y, y0, y1, x0, x1);
    xR=Interpolate(y, y0, y2, x0, x2);
    devRect(xL, y, xR, y);
   }

  for (y = y1; y<= y2; y++)
   {
    xL=Interpolate(y, y1, y2, x1, x2);
    xR=Interpolate(y, y0, y2, x0, x2);
    devRect(xL, y, xR, y);
   }

  return (0); /* success */
 } 

int devShadeTriangle(x0, y0, c0, x1, y1, c1, x2, y2, c2)
 int x0, y0, c0, x1, y1, c1, x2, y2, c2; 
 {
  int t;
  double r0, g0, b0, r1, g1, b1, r2, g2, b2;
  int y, xL, xR;
  double rL, rR, gL, gR, bL, bR;
  int left, top, right, bottom, middle;

  /* sort vertices in increasing y order */
  if (y0 > y1)
   {
    t=y0; y0 = y1; y1 = t;
    t=x0; x0 = x1; x1 = t;
    t=c0; c0 = c1; c1 = t;
   }
  if (y1 > y2)
   {
    t=y1; y1 = y2; y2 = t;
    t=x1; x1 = x2; x2 = t;
    t=c1; c1 = c2; c2 = t;
   }
  if (y0 > y1)
   {
    t=y0; y0 = y1; y1 = t;
    t=x0; x0 = x1; x1 = t;
    t=c0; c0 = c1; c1 = t;
   }

  /* look for a quick kill */
  top = y2; bottom = y0;
  left = x0; middle = x1; right = x2;
  if (left   > middle) { t =   left; left   = middle; middle = t; }
  if (middle > right ) { t = middle; middle =  right; right  = t; }
  if (left   > middle) { t =   left; left   = middle; middle = t; }

  if (devClipRectangle(&left, &bottom, &right, &top)) return 0;

  /* in general, we can't interpolate codes - go to r,g,b */
  (void)devColorDecode(c0, &r0, &g0, &b0);
  (void)devColorDecode(c1, &r1, &g1, &b1);
  (void)devColorDecode(c2, &r2, &g2, &b2);

  /* scan convert */
  for (y = y0; y <= y1; y++)
   {
    xL=Interpolate(y, y0, y1, x0, x1);
    rL=Interpolate(y, y0, y1, r0, r1);
    gL=Interpolate(y, y0, y1, g0, g1);
    bL=Interpolate(y, y0, y1, b0, b1);
    xR=Interpolate(y, y0, y2, x0, x2);
    rR=Interpolate(y, y0, y2, r0, r2);
    gR=Interpolate(y, y0, y2, g0, g2);
    bR=Interpolate(y, y0, y2, b0, b2);
    devShadeLine(y, xL, xR, rL, gL, bL, rR, gR, bR);
   }

  for (y = y1; y <= y2; y++)
   {
    xL=Interpolate(y, y1, y2, x1, x2);
    rL=Interpolate(y, y1, y2, r1, r2);
    gL=Interpolate(y, y1, y2, g1, g2);
    bL=Interpolate(y, y1, y2, b1, b2);
    xR=Interpolate(y, y0, y2, x0, x2);
    rR=Interpolate(y, y0, y2, r0, r2);
    gR=Interpolate(y, y0, y2, g0, g2);
    bR=Interpolate(y, y0, y2, b0, b2);
    devShadeLine(y, xL, xR, rL, gL, bL, rR, gR, bR);
   }
 }
