#include <stdio.h>
#define Number double

#define TRUE (-1)
#define FALSE (0)

/*  ********Torben's code starts here ******** */
int sameside(x1,y1,x2,y2,lx1,ly1,lx2,ly2)
Number  x1,y1,x2,y2,lx1,ly1,lx2,ly2;
{
  Number dx,dy,t1,t2;

  dx = lx2 - lx1;
  dy = ly2 - ly1;
  t1 = dx*(y1-ly1)-dy*(x1-lx1);
  t2 = dx*(y2-ly1)-dy*(x2-lx1);
  return(t1<=0 && t2<=0 || t1>=0 && t2>=0);
}

int nsameside(x1,y1,x2,y2,lx1,ly1,lx2,ly2)
Number  x1,y1,x2,y2,lx1,ly1,lx2,ly2;
{
  Number  dx,dy,dx1,dy1,t1,t2;

  dx = lx2 - lx1;
  dy = ly2 - ly1;
  dx1 = x1 - lx1;
  dy1 = y1 - ly1;
  t1 = dx*dy1-dy*dx1;
  t2 = dx*(y2-ly1)-dy*(x2-lx1);
  if (t2<0) return(t1>=0);
  if (t2>0) return(t1<=0);
  return(t1==0 &&
	 (dx>=0 && dx1>=0 || dx<=0 && dx1<=0) &&
	 (dy>=0 && dy1>=0 || dy<=0 && dy1<=0));
}


int is_polygon_convex(x, y, n)
    Number *x, *y;
    int n;

{
  int c;
  int v1,vi,vi_1,vi_2;

  for (v1=1; v1<n && x[v1]==x[0] && y[v1]==y[0]; ++v1);
  vi_2 = v1;
  for (vi_1=v1+1; vi_1<n && x[vi_1]==x[v1] && y[vi_1]==y[v1]; ++vi_1);
  
  c = 1;
  for (vi=vi_1+1; vi<n-1 && c; ++vi)
    if (x[vi]!=x[vi_1] || y[vi]!=y[vi_1]) {
      c = nsameside(x[vi],y[vi],x[v1],y[v1],x[0],y[0],x[vi_1],y[vi_1])
          && sameside(x[vi],y[vi],x[vi_1],y[vi_1],x[0],y[0],x[v1],y[v1])
          && sameside(x[vi],y[vi],x[0],y[0],x[vi_1],y[vi_1],x[vi_2],y[vi_2]);
      vi_2 = vi_1;
      vi_1 = vi;
    }
  if (c && vi==n-1 &&
      (x[vi]!=x[vi_1] || y[vi]!=y[vi_1]) &&
      (x[vi]!=x[0] || y[vi]!=y[0]))
    c = nsameside(x[vi],y[vi],x[v1],y[v1],x[0],y[0],x[vi_1],y[vi_1])
        && sameside(x[vi],y[vi],x[vi_1],y[vi_1],x[0],y[0],x[v1],y[v1])
        && sameside(x[vi],y[vi],x[0],y[0],x[vi_1],y[vi_1],x[vi_2],y[vi_2]);
  return(c);
}

/*  ********Torben's code ends here ******** */

int
main()
 {
  Number x[64],y[64];
  int numpoints,i;
 
  for(i=0;;i++)
   {
    if (2 != fscanf(stdin," %f %f",&x[i],&y[i]))
     { numpoints = i; break; }
   }

  if (is_polygon_convex(x,y,numpoints) )
   { fprintf(stderr,"CONVEX\n"); exit(0); }
  else 
   { fprintf(stderr,"NOT CONVEX\n"); exit(-1); }
 }
