/*
  File: confocal2wff.c
  Authors: K.R. Sloan
  Last Modified: 27 September 1990
  Purpose: Convert a confocal microscope format file to .WFF format
*/
#include <assert.h>
#include <stdio.h>
#include "wff.h"

char *calloc();

static char *RoutineName;
static usage()
 {
  fprintf( stderr, "Usage: %s < confocal > wff\n", RoutineName );
  exit(1);
 }

static void FatalError(s)
 char *s;
 {
  fprintf(stderr,"%s: %s\n",RoutineName, s); exit(1);
 }

/* These function deal with WFF files */

static FrameBufferType *SetUpWFFFile(stream, xsize, ysize, zsize)
 FILE *stream;
 int xsize, ysize, zsize;
 {
  FrameBufferType *FrameBuffer;
  int Bottom, Left, Top, Right;
  int BitsPerBand;
  char WhatBands[10], Name[NameLength], Value[ValueLength];

  FrameBuffer = (FrameBufferType *)0;

  OpenFB(&FrameBuffer);
  assert(FrameBuffer);

  Bottom = 0; Left = 0; Top = ysize-1; Right = xsize-1;
  SetBounds(FrameBuffer, Bottom, Left, Top, Right);

  /* we only handle the simple cases...*/
  if (24 == zsize) { BitsPerBand =     8; strcpy(WhatBands,"RGB"); }
  else             { BitsPerBand = zsize; strcpy(WhatBands,"I"  ); }
  SetColorSystem(FrameBuffer, WhatBands,  BitsPerBand);

  strcpy(Name,"X-CreatedBy");
  strcpy(Value,RoutineName);
  SetDescriptor(FrameBuffer, Name, Value);

  strcpy(Name,"Encoding");
  strcpy(Value,"AIS");
  SetDescriptor(FrameBuffer, Name, Value);

  /* Header operations over, now we can start the output stream */
  PassImageOut(stream, FrameBuffer);
  return (FrameBuffer);
 }  

static void WriteWFFScanLine(FB, xsize, ScanLine)
 FrameBufferType *FB;
 int xsize;
 unsigned short *ScanLine;
 {
  assert (SUCCESS == NextNPixelsOut(FB, xsize, ScanLine));
 }


static void CloseWFFFile(FB)
 FrameBufferType *FB;
 {
  CloseFB(&FB);
 }

/*
  The Main Line (are we in Philadelphia, yet?)
 */
int
main(argc,argv)
 int argc;
 char *argv[];
 {
  int ArgsParsed = 0;
  int size = 256;
  FrameBufferType *FB;
  unsigned char *ScanLineIn;
  unsigned char *Iptr;
  unsigned short *ScanLineOut;
  unsigned short *Optr;
  int xsize, ysize, zsize;
  int x,y;

  RoutineName = argv[ArgsParsed++];
  for (; ArgsParsed < argc; )
   {
    if ('-' != argv[ArgsParsed][0]) { usage(); exit(1); }
    switch (argv[ArgsParsed++][1])
     {
      case 's': if (ArgsParsed >= argc) { usage(); exit(1); }
                size = atoi(argv[ArgsParsed++]);
                break;
      default:
      case 'h': { usage(); exit(1); }
     }
   }  

  xsize = size;   ysize = size; zsize = 8;  /* simple, no? */

  ScanLineIn  = (unsigned char *)calloc(xsize, sizeof(unsigned char));
  assert(ScanLineIn);
  ScanLineOut = (unsigned short *)calloc(xsize, sizeof(unsigned short));
  assert(ScanLineOut);

  FB = SetUpWFFFile(stdout, xsize, ysize, zsize);
  assert(FB);

  for(y=0;y<ysize;y++)
   {
    /* read one line */
    fread(ScanLineIn, sizeof(unsigned char), xsize, stdin);
    Iptr = ScanLineIn; Optr = ScanLineOut;

    /* if we wanted raw speed, we could look inside wff.c and ...naah! */
    for(x=0;x<xsize;x++)
     {
      if (24 == zsize)
       {
        *(Optr++) = (unsigned short) *(Iptr++);
        *(Optr++) = (unsigned short) *(Iptr++);
        *(Optr++) = (unsigned short) *(Iptr++);
       }
      else 
       {
        *(Optr++) = (unsigned short) *(Iptr++);
       }    
     }
    NextNPixelsOut(FB, xsize, (unsigned short *)ScanLineOut);
    wffFlush(FB);
   }
  CloseWFFFile(FB);
  exit(0);
 }
